/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.VirtualTransform;

public class VirtualPart {
    private final String loc;
    private final List<VirtualTransform> trans;

    protected VirtualPart(BuilderImpl builder) {
        this.loc = builder.loc();
        this.trans = builder.trans();
    }

    public String loc() {
        return this.loc;
    }

    public List<VirtualTransform> trans() {
        return this.trans;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String loc;
        protected List<VirtualTransform> trans;

        protected BuilderImpl() {
        }

        protected BuilderImpl(VirtualPart model) {
            this.loc = model.loc();
            this.trans = model.trans();
        }

        @Override
        public Builder loc(String loc) {
            this.loc = loc;
            return this;
        }

        @Override
        public String loc() {
            return this.loc;
        }

        @Override
        public Builder trans(List<VirtualTransform> trans) {
            this.trans = trans;
            return this;
        }

        @Override
        public List<VirtualTransform> trans() {
            return this.trans;
        }

        @Override
        public VirtualPart build() {
            if (Objects.isNull(this.loc())) {
                throw new IllegalArgumentException("Missing value for required field `loc`");
            }
            if (Objects.nonNull(this.loc()) && this.loc().length() < 1) {
                throw new IllegalArgumentException("The size of `loc` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.trans()) && this.trans().size() < 1) {
                throw new IllegalArgumentException("The size of `trans` must be greater than or equal to 1");
            }
            return new VirtualPart(this);
        }
    }

    public static interface Builder {
        public Builder loc(String var1);

        public String loc();

        public Builder trans(List<VirtualTransform> var1);

        public List<VirtualTransform> trans();

        public VirtualPart build();
    }
}

