"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateMetric = calculateMetric;
exports.calculateMetricNumber = calculateMetricNumber;
exports.getMergedMetricSettings = getMergedMetricSettings;
exports.getMergedStringSettings = getMergedStringSettings;
exports.getTimeAndUnitFromString = getTimeAndUnitFromString;
exports.getTimeUnitFromAbbreviation = getTimeUnitFromAbbreviation;
var _constants = require("../constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function calculateMetric(value, count, unit = '', factor = 1, defaultMsg = 'N/A') {
  if (value !== undefined && count !== undefined) {
    return `${calculateMetricNumber(value, count, factor).toFixed(2)} ${unit}`;
  }
  return defaultMsg;
}
function calculateMetricNumber(value, count, factor = 1) {
  if (value !== undefined && count !== undefined && count !== 0 && factor !== 0) {
    return value / count / factor;
  }
  return 0;
}
function getTimeUnitFromAbbreviation(timeUnit) {
  for (const [key, value] of Object.entries(_constants.TIME_UNIT_ABBREVIATION)) {
    if (value === timeUnit) {
      return key;
    }
  }
  return _constants.DEFAULT_TIME_UNIT; // Return default time unit if no match is found
}

function getTimeAndUnitFromString(time) {
  const defaultWindowSize = [_constants.DEFAULT_WINDOW_SIZE, _constants.TIME_UNIT_ABBREVIATION.MINUTES];
  if (!time) {
    return defaultWindowSize;
  }
  const timeAndUnit = time.match(/\D+|\d+/g);
  if (!timeAndUnit || timeAndUnit.length !== 2) {
    return defaultWindowSize;
  }
  return [timeAndUnit[0], getTimeUnitFromAbbreviation(timeAndUnit[1])];
}

// Helper to get merged settings with transient overwriting persistent
function getMergedMetricSettings(persistent, transient) {
  if (transient !== undefined) {
    return transient;
  }
  return {
    ...persistent
  };
}
function getMergedStringSettings(persistent, transient, defaultVal) {
  var _ref;
  return (_ref = transient !== null && transient !== void 0 ? transient : persistent) !== null && _ref !== void 0 ? _ref : defaultVal;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsImNhbGN1bGF0ZU1ldHJpYyIsInZhbHVlIiwiY291bnQiLCJ1bml0IiwiZmFjdG9yIiwiZGVmYXVsdE1zZyIsInVuZGVmaW5lZCIsImNhbGN1bGF0ZU1ldHJpY051bWJlciIsInRvRml4ZWQiLCJnZXRUaW1lVW5pdEZyb21BYmJyZXZpYXRpb24iLCJ0aW1lVW5pdCIsImtleSIsIk9iamVjdCIsImVudHJpZXMiLCJUSU1FX1VOSVRfQUJCUkVWSUFUSU9OIiwiREVGQVVMVF9USU1FX1VOSVQiLCJnZXRUaW1lQW5kVW5pdEZyb21TdHJpbmciLCJ0aW1lIiwiZGVmYXVsdFdpbmRvd1NpemUiLCJERUZBVUxUX1dJTkRPV19TSVpFIiwiTUlOVVRFUyIsInRpbWVBbmRVbml0IiwibWF0Y2giLCJsZW5ndGgiLCJnZXRNZXJnZWRNZXRyaWNTZXR0aW5ncyIsInBlcnNpc3RlbnQiLCJ0cmFuc2llbnQiLCJnZXRNZXJnZWRTdHJpbmdTZXR0aW5ncyIsImRlZmF1bHRWYWwiLCJfcmVmIl0sInNvdXJjZXMiOlsiTWV0cmljVXRpbHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBERUZBVUxUX1RJTUVfVU5JVCwgREVGQVVMVF9XSU5ET1dfU0laRSwgVElNRV9VTklUX0FCQlJFVklBVElPTiB9IGZyb20gJy4uL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBNZXRyaWNTZXR0aW5nc1Jlc3BvbnNlIH0gZnJvbSAnLi4vLi4vdHlwZXMvdHlwZXMnO1xuXG5leHBvcnQgZnVuY3Rpb24gY2FsY3VsYXRlTWV0cmljKFxuICB2YWx1ZT86IG51bWJlcixcbiAgY291bnQ/OiBudW1iZXIsXG4gIHVuaXQ6IHN0cmluZyA9ICcnLFxuICBmYWN0b3I6IG51bWJlciA9IDEsXG4gIGRlZmF1bHRNc2c6IHN0cmluZyA9ICdOL0EnXG4pOiBzdHJpbmcge1xuICBpZiAodmFsdWUgIT09IHVuZGVmaW5lZCAmJiBjb3VudCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgcmV0dXJuIGAke2NhbGN1bGF0ZU1ldHJpY051bWJlcih2YWx1ZSwgY291bnQsIGZhY3RvcikudG9GaXhlZCgyKX0gJHt1bml0fWA7XG4gIH1cbiAgcmV0dXJuIGRlZmF1bHRNc2c7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjYWxjdWxhdGVNZXRyaWNOdW1iZXIodmFsdWU/OiBudW1iZXIsIGNvdW50PzogbnVtYmVyLCBmYWN0b3I6IG51bWJlciA9IDEpOiBudW1iZXIge1xuICBpZiAodmFsdWUgIT09IHVuZGVmaW5lZCAmJiBjb3VudCAhPT0gdW5kZWZpbmVkICYmIGNvdW50ICE9PSAwICYmIGZhY3RvciAhPT0gMCkge1xuICAgIHJldHVybiB2YWx1ZSAvIGNvdW50IC8gZmFjdG9yO1xuICB9XG4gIHJldHVybiAwO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ2V0VGltZVVuaXRGcm9tQWJicmV2aWF0aW9uKHRpbWVVbml0OiBzdHJpbmcpOiBzdHJpbmcge1xuICBmb3IgKGNvbnN0IFtrZXksIHZhbHVlXSBvZiBPYmplY3QuZW50cmllcyhUSU1FX1VOSVRfQUJCUkVWSUFUSU9OKSkge1xuICAgIGlmICh2YWx1ZSA9PT0gdGltZVVuaXQpIHtcbiAgICAgIHJldHVybiBrZXk7XG4gICAgfVxuICB9XG4gIHJldHVybiBERUZBVUxUX1RJTUVfVU5JVDsgLy8gUmV0dXJuIGRlZmF1bHQgdGltZSB1bml0IGlmIG5vIG1hdGNoIGlzIGZvdW5kXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRUaW1lQW5kVW5pdEZyb21TdHJpbmcodGltZTogc3RyaW5nIHwgdW5kZWZpbmVkIHwgbnVsbCk6IHN0cmluZ1tdIHtcbiAgY29uc3QgZGVmYXVsdFdpbmRvd1NpemUgPSBbREVGQVVMVF9XSU5ET1dfU0laRSwgVElNRV9VTklUX0FCQlJFVklBVElPTi5NSU5VVEVTXTtcbiAgaWYgKCF0aW1lKSB7XG4gICAgcmV0dXJuIGRlZmF1bHRXaW5kb3dTaXplO1xuICB9XG4gIGNvbnN0IHRpbWVBbmRVbml0ID0gdGltZS5tYXRjaCgvXFxEK3xcXGQrL2cpO1xuICBpZiAoIXRpbWVBbmRVbml0IHx8IHRpbWVBbmRVbml0Lmxlbmd0aCAhPT0gMikge1xuICAgIHJldHVybiBkZWZhdWx0V2luZG93U2l6ZTtcbiAgfVxuICByZXR1cm4gW3RpbWVBbmRVbml0WzBdLCBnZXRUaW1lVW5pdEZyb21BYmJyZXZpYXRpb24odGltZUFuZFVuaXRbMV0pXTtcbn1cblxuLy8gSGVscGVyIHRvIGdldCBtZXJnZWQgc2V0dGluZ3Mgd2l0aCB0cmFuc2llbnQgb3ZlcndyaXRpbmcgcGVyc2lzdGVudFxuZXhwb3J0IGZ1bmN0aW9uIGdldE1lcmdlZE1ldHJpY1NldHRpbmdzKFxuICBwZXJzaXN0ZW50OiBNZXRyaWNTZXR0aW5nc1Jlc3BvbnNlIHwgdW5kZWZpbmVkLFxuICB0cmFuc2llbnQ6IE1ldHJpY1NldHRpbmdzUmVzcG9uc2UgfCB1bmRlZmluZWRcbik6IE1ldHJpY1NldHRpbmdzUmVzcG9uc2Uge1xuICBpZiAodHJhbnNpZW50ICE9PSB1bmRlZmluZWQpIHtcbiAgICByZXR1cm4gdHJhbnNpZW50O1xuICB9XG4gIHJldHVybiB7XG4gICAgLi4ucGVyc2lzdGVudCxcbiAgfTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldE1lcmdlZFN0cmluZ1NldHRpbmdzKFxuICBwZXJzaXN0ZW50OiBzdHJpbmcgfCB1bmRlZmluZWQsXG4gIHRyYW5zaWVudDogc3RyaW5nIHwgdW5kZWZpbmVkLFxuICBkZWZhdWx0VmFsOiBzdHJpbmdcbik6IHN0cmluZyB7XG4gIHJldHVybiB0cmFuc2llbnQgPz8gcGVyc2lzdGVudCA/PyBkZWZhdWx0VmFsO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUtBLElBQUFBLFVBQUEsR0FBQUMsT0FBQTtBQUxBO0FBQ0E7QUFDQTtBQUNBOztBQUtPLFNBQVNDLGVBQWVBLENBQzdCQyxLQUFjLEVBQ2RDLEtBQWMsRUFDZEMsSUFBWSxHQUFHLEVBQUUsRUFDakJDLE1BQWMsR0FBRyxDQUFDLEVBQ2xCQyxVQUFrQixHQUFHLEtBQUssRUFDbEI7RUFDUixJQUFJSixLQUFLLEtBQUtLLFNBQVMsSUFBSUosS0FBSyxLQUFLSSxTQUFTLEVBQUU7SUFDOUMsT0FBUSxHQUFFQyxxQkFBcUIsQ0FBQ04sS0FBSyxFQUFFQyxLQUFLLEVBQUVFLE1BQU0sQ0FBQyxDQUFDSSxPQUFPLENBQUMsQ0FBQyxDQUFFLElBQUdMLElBQUssRUFBQztFQUM1RTtFQUNBLE9BQU9FLFVBQVU7QUFDbkI7QUFFTyxTQUFTRSxxQkFBcUJBLENBQUNOLEtBQWMsRUFBRUMsS0FBYyxFQUFFRSxNQUFjLEdBQUcsQ0FBQyxFQUFVO0VBQ2hHLElBQUlILEtBQUssS0FBS0ssU0FBUyxJQUFJSixLQUFLLEtBQUtJLFNBQVMsSUFBSUosS0FBSyxLQUFLLENBQUMsSUFBSUUsTUFBTSxLQUFLLENBQUMsRUFBRTtJQUM3RSxPQUFPSCxLQUFLLEdBQUdDLEtBQUssR0FBR0UsTUFBTTtFQUMvQjtFQUNBLE9BQU8sQ0FBQztBQUNWO0FBRU8sU0FBU0ssMkJBQTJCQSxDQUFDQyxRQUFnQixFQUFVO0VBQ3BFLEtBQUssTUFBTSxDQUFDQyxHQUFHLEVBQUVWLEtBQUssQ0FBQyxJQUFJVyxNQUFNLENBQUNDLE9BQU8sQ0FBQ0MsaUNBQXNCLENBQUMsRUFBRTtJQUNqRSxJQUFJYixLQUFLLEtBQUtTLFFBQVEsRUFBRTtNQUN0QixPQUFPQyxHQUFHO0lBQ1o7RUFDRjtFQUNBLE9BQU9JLDRCQUFpQixDQUFDLENBQUM7QUFDNUI7O0FBRU8sU0FBU0Msd0JBQXdCQSxDQUFDQyxJQUErQixFQUFZO0VBQ2xGLE1BQU1DLGlCQUFpQixHQUFHLENBQUNDLDhCQUFtQixFQUFFTCxpQ0FBc0IsQ0FBQ00sT0FBTyxDQUFDO0VBQy9FLElBQUksQ0FBQ0gsSUFBSSxFQUFFO0lBQ1QsT0FBT0MsaUJBQWlCO0VBQzFCO0VBQ0EsTUFBTUcsV0FBVyxHQUFHSixJQUFJLENBQUNLLEtBQUssQ0FBQyxVQUFVLENBQUM7RUFDMUMsSUFBSSxDQUFDRCxXQUFXLElBQUlBLFdBQVcsQ0FBQ0UsTUFBTSxLQUFLLENBQUMsRUFBRTtJQUM1QyxPQUFPTCxpQkFBaUI7RUFDMUI7RUFDQSxPQUFPLENBQUNHLFdBQVcsQ0FBQyxDQUFDLENBQUMsRUFBRVosMkJBQTJCLENBQUNZLFdBQVcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ3RFOztBQUVBO0FBQ08sU0FBU0csdUJBQXVCQSxDQUNyQ0MsVUFBOEMsRUFDOUNDLFNBQTZDLEVBQ3JCO0VBQ3hCLElBQUlBLFNBQVMsS0FBS3BCLFNBQVMsRUFBRTtJQUMzQixPQUFPb0IsU0FBUztFQUNsQjtFQUNBLE9BQU87SUFDTCxHQUFHRDtFQUNMLENBQUM7QUFDSDtBQUVPLFNBQVNFLHVCQUF1QkEsQ0FDckNGLFVBQThCLEVBQzlCQyxTQUE2QixFQUM3QkUsVUFBa0IsRUFDVjtFQUFBLElBQUFDLElBQUE7RUFDUixRQUFBQSxJQUFBLEdBQU9ILFNBQVMsYUFBVEEsU0FBUyxjQUFUQSxTQUFTLEdBQUlELFVBQVUsY0FBQUksSUFBQSxjQUFBQSxJQUFBLEdBQUlELFVBQVU7QUFDOUMifQ==