/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec4(165ul, 133ul, 193ul, 76ul) << uvec4(16u, 24u, 23u, 25u)) => u64vec4(10813440ul, 2231369728ul, 1619001344ul, 2550136832ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) << uvec4(23u, 12u, 14u, 19u)) => u64vec4(1384120320ul, 544768ul, 3162112ul, 39845888ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) << uvec4(16u, 24u, 23u, 25u)) => u64vec4(5242880ul, 251658240ul, 427819008ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) << uvec4(23u, 12u, 14u, 19u)) => u64vec4(671088640ul, 61440ul, 835584ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) << uvec4(16u, 24u, 23u, 25u)), u64vec4(10813440ul, 2231369728ul, 1619001344ul, 2550136832ul))) ? 1 : -1] array0;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) << uvec4(23u, 12u, 14u, 19u)), u64vec4(1384120320ul, 544768ul, 3162112ul, 39845888ul))) ? 1 : -1] array1;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) << uvec4(16u, 24u, 23u, 25u)), u64vec4(5242880ul, 251658240ul, 427819008ul, 0ul))) ? 1 : -1] array2;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) << uvec4(23u, 12u, 14u, 19u)), u64vec4(671088640ul, 61440ul, 835584ul, 0ul))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
