/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2ServerHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2HandshakeMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SSL2ServerHelloMessage
extends SSL2HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableByte sessionIdHit;
    @ModifiableVariableProperty
    private ModifiableByte certificateType;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray protocolVersion;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger certificateLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger cipherSuitesLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger sessionIdLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.CERTIFICATE)
    private ModifiableByteArray certificate;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray cipherSuites;
    @ModifiableVariableProperty
    private ModifiableByteArray sessionId;

    public SSL2ServerHelloMessage() {
        super(HandshakeMessageType.SSL2_SERVER_HELLO);
        this.protocolMessageType = ProtocolMessageType.HANDSHAKE;
    }

    public SSL2ServerHelloMessage(Config config) {
        this();
    }

    @Override
    public String toCompactString() {
        return "SSL2 ServerHello Message";
    }

    @Override
    public SSL2ServerHelloHandler getHandler(TlsContext context) {
        return new SSL2ServerHelloHandler(context);
    }

    public ModifiableByte getSessionIdHit() {
        return this.sessionIdHit;
    }

    public void setSessionIdHit(ModifiableByte sessionIdHit) {
        this.sessionIdHit = sessionIdHit;
    }

    public void setSessionIdHit(byte sessionIdHit) {
        this.sessionIdHit = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.sessionIdHit, (Byte)sessionIdHit);
    }

    public ModifiableByte getCertificateType() {
        return this.certificateType;
    }

    public void setCertificateType(ModifiableByte certificateType) {
        this.certificateType = certificateType;
    }

    public void setCertificateType(byte certificateType) {
        this.certificateType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.certificateType, (Byte)certificateType);
    }

    public ModifiableByteArray getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ModifiableByteArray protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setProtocolVersion(byte[] protocolVersion) {
        this.protocolVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolVersion, (byte[])protocolVersion);
    }

    public ModifiableInteger getCertificateLength() {
        return this.certificateLength;
    }

    public void setCertificateLength(int certificateLength) {
        this.certificateLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificateLength, (Integer)certificateLength);
    }

    public void setCertificateLength(ModifiableInteger certificateLength) {
        this.certificateLength = certificateLength;
    }

    public ModifiableInteger getCipherSuitesLength() {
        return this.cipherSuitesLength;
    }

    public void setCipherSuitesLength(ModifiableInteger cipherSuitesLength) {
        this.cipherSuitesLength = cipherSuitesLength;
    }

    public void setCipherSuitesLength(int cipherSuitesLength) {
        this.cipherSuitesLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.cipherSuitesLength, (Integer)cipherSuitesLength);
    }

    public ModifiableInteger getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(ModifiableInteger sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public void setSessionIDLength(int connectionIDLength) {
        this.sessionIdLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.sessionIdLength, (Integer)connectionIDLength);
    }

    public ModifiableByteArray getCertificate() {
        return this.certificate;
    }

    public void setCertificate(ModifiableByteArray certificate) {
        this.certificate = certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.certificate, (byte[])certificate);
    }

    public ModifiableByteArray getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(ModifiableByteArray cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setCipherSuites(byte[] cipherSuites) {
        this.cipherSuites = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherSuites, (byte[])cipherSuites);
    }

    public ModifiableByteArray getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(ModifiableByteArray sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionID(byte[] sessionID) {
        this.sessionId = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.sessionId, (byte[])sessionID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSL2ServerHelloMessage:");
        sb.append("\n  Protocol Version: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Type: ");
        if (this.getType() != null && this.getType().getValue() != null) {
            sb.append(this.getType().getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Supported CipherSuites: ");
        if (this.getCipherSuites() != null && this.getCipherSuites().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getCipherSuites().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  SessionIdHit: ");
        if (this.getSessionIdHit() != null && this.getSessionIdHit().getValue() != null) {
            sb.append(this.getSessionIdHit().getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Certificate: ");
        if (this.getCertificate() != null && this.getCertificate().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getCertificate().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  SessionID: ");
        if (this.getSessionId() != null && this.getSessionId().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSessionId().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

