/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferCallbackAccumulator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;

public class ByteBufferMessageSink
extends AbstractMessageSink {
    private ByteBufferCallbackAccumulator accumulator;

    public ByteBufferMessageSink(CoreSession session, MethodHolder methodHolder, boolean autoDemand) {
        super(session, methodHolder, autoDemand);
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            long size = (this.accumulator == null ? 0 : this.accumulator.getLength()) + frame.getPayloadLength();
            long maxSize = this.getCoreSession().getMaxBinaryMessageSize();
            if (maxSize > 0L && size > maxSize) {
                callback.failed((Throwable)new MessageTooLargeException(String.format("Binary message too large: %,d > %,d", size, maxSize)));
                return;
            }
            if (frame.isFin() && (this.accumulator == null || this.accumulator.getLength() == 0)) {
                this.invoke(this.getMethodHolder(), frame.getPayload(), callback);
                this.autoDemand();
                return;
            }
            if (!frame.isFin() && !frame.hasPayload()) {
                callback.succeeded();
                this.getCoreSession().demand();
                return;
            }
            if (this.accumulator == null) {
                this.accumulator = new ByteBufferCallbackAccumulator();
            }
            this.accumulator.addEntry(frame.getPayload(), callback);
            if (frame.isFin()) {
                ByteBufferPool bufferPool = this.getCoreSession().getByteBufferPool();
                RetainableByteBuffer.Mutable buffer = bufferPool.acquire(this.accumulator.getLength(), false);
                ByteBuffer byteBuffer = buffer.getByteBuffer();
                this.accumulator.writeTo(byteBuffer);
                callback = Callback.from(() -> ((RetainableByteBuffer)buffer).release());
                this.invoke(this.getMethodHolder(), byteBuffer, callback);
                this.autoDemand();
            } else {
                this.getCoreSession().demand();
            }
        }
        catch (Throwable t) {
            this.fail(t);
            callback.failed(t);
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (this.accumulator != null) {
            this.accumulator.fail(failure);
        }
    }

    protected void invoke(MethodHolder methodHolder, ByteBuffer byteBuffer, Callback callback) throws Throwable {
        methodHolder.invoke(byteBuffer);
        callback.succeeded();
    }
}

