/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import nu.validator.messages.ImageReviewHandler;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.ResultHandler;
import nu.validator.messages.XhtmlExtractHandler;
import nu.validator.messages.XhtmlMessageTextHandler;
import nu.validator.messages.XhtmlResultHandler;
import nu.validator.messages.XhtmlSourceHandler;
import nu.validator.messages.types.MessageType;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.TreeParser;
import nu.validator.servlet.imagereview.Image;
import nu.validator.source.SourceHandler;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.XhtmlSaxEmitter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XhtmlMessageEmitter
extends MessageEmitter
implements ImageReviewHandler {
    private static final int IMAGE_CLAMP = 180;
    private static final char[] COLON_SPACE = new char[]{':', ' '};
    private static final char[] PERIOD = new char[]{'.'};
    private static final char[] ON_LINE = "On line ".toCharArray();
    private static final char[] AT_LINE = "At line ".toCharArray();
    private static final char[] FROM_LINE = "From line ".toCharArray();
    private static final char[] TO_LINE = "; to line ".toCharArray();
    private static final char[] COLUMN = ", column ".toCharArray();
    private static final char[] IN_RESOURCE = " in resource ".toCharArray();
    private static final char[] NOT_RESOLVABLE = "Not resolvable".toCharArray();
    private static final char[] EMPTY_STRING_AS_ALT = "Omit image in non-graphical presentation".toCharArray();
    private static final char[] NO_ALT = "Not available".toCharArray();
    private static final char[] IMAGE = "Image".toCharArray();
    private static final char[] TEXTUAL_ALTERNATIVE = "Textual alternative".toCharArray();
    private static final char[] LOCATION = "Location".toCharArray();
    private static final char[] IMAGE_REPORT = "Image report".toCharArray();
    private static final char[] SOURCE_CODE = "Source".toCharArray();
    private final AttributesImpl attrs = new AttributesImpl();
    private boolean listOpen = false;
    private final ContentHandler contentHandler;
    private final XhtmlSaxEmitter emitter;
    private final XhtmlMessageTextHandler messageTextHandler;
    private final XhtmlExtractHandler extractHandler;
    private boolean textEmitted;
    private String systemId;
    private int oneBasedFirstLine;
    private int oneBasedFirstColumn;
    private int oneBasedLastLine;
    private int oneBasedLastColumn;
    private boolean willShowSource;
    private final TreeParser treeParser;

    public XhtmlMessageEmitter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.emitter = new XhtmlSaxEmitter(contentHandler);
        this.messageTextHandler = new XhtmlMessageTextHandler(this.emitter);
        this.extractHandler = new XhtmlExtractHandler(this.emitter);
        this.treeParser = new TreeParser(contentHandler, null);
    }

    private void maybeOpenList() throws SAXException {
        if (!this.listOpen) {
            this.emitter.startElement("ol");
            this.listOpen = true;
        }
    }

    private void emitErrorLevel(char[] level) throws SAXException {
        this.emitter.startElement("strong");
        this.emitter.characters(level);
        this.emitter.endElement("strong");
    }

    @Override
    public void endMessage() throws SAXException {
        this.maybeCloseTextPara();
        this.emitter.endElement("li");
    }

    private void maybeCloseTextPara() throws SAXException {
        if (!this.textEmitted) {
            this.emitter.characters(PERIOD);
            this.emitter.endElement("p");
            this.maybeEmitLocation(true);
        }
    }

    private void maybeEmitLocation(boolean withPara) throws SAXException {
        if (this.oneBasedLastLine == -1 && this.systemId == null) {
            return;
        }
        if (withPara) {
            this.emitter.startElementWithClass("p", "location");
        }
        if (this.oneBasedLastLine == -1) {
            this.emitSystemId();
        } else if (this.oneBasedLastColumn == -1) {
            this.emitLineLocation();
        } else if (this.oneBasedFirstLine == -1 || this.oneBasedFirstLine == this.oneBasedLastLine && this.oneBasedFirstColumn == this.oneBasedLastColumn) {
            this.emitSingleLocation();
        } else {
            this.emitRangeLocation();
        }
        if (withPara) {
            this.emitter.endElement("p");
        }
    }

    private void maybeEmitInResource() throws SAXException {
        if (this.systemId != null) {
            this.emitter.characters(IN_RESOURCE);
            this.emitSystemId();
        }
    }

    private void emitSystemId() throws SAXException {
        this.emitter.startElementWithClass("span", "url");
        this.emitter.characters(this.systemId);
        this.emitter.endElement("span");
    }

    private void emitRangeLocation() throws SAXException {
        if (this.willShowSource && this.systemId == null) {
            this.attrs.clear();
            this.attrs.addAttribute("href", "#l" + this.oneBasedLastLine + "c" + this.oneBasedLastColumn);
            this.emitter.startElement("a", this.attrs);
        }
        this.emitter.characters(FROM_LINE);
        this.emitter.startElementWithClass("span", "first-line");
        this.emitter.characters(Integer.toString(this.oneBasedFirstLine));
        this.emitter.endElement("span");
        this.emitter.characters(COLUMN);
        this.emitter.startElementWithClass("span", "first-col");
        this.emitter.characters(Integer.toString(this.oneBasedFirstColumn));
        this.emitter.endElement("span");
        this.emitter.characters(TO_LINE);
        this.emitter.startElementWithClass("span", "last-line");
        this.emitter.characters(Integer.toString(this.oneBasedLastLine));
        this.emitter.endElement("span");
        this.emitter.characters(COLUMN);
        this.emitter.startElementWithClass("span", "last-col");
        this.emitter.characters(Integer.toString(this.oneBasedLastColumn));
        this.emitter.endElement("span");
        this.maybeEmitInResource();
        if (this.willShowSource && this.systemId == null) {
            this.emitter.endElement("a");
        }
    }

    private void emitSingleLocation() throws SAXException {
        if (this.willShowSource && this.systemId == null) {
            this.attrs.clear();
            this.attrs.addAttribute("href", "#cl" + this.oneBasedLastLine + "c" + this.oneBasedLastColumn);
            this.emitter.startElement("a", this.attrs);
        }
        this.emitter.characters(AT_LINE);
        this.emitter.startElementWithClass("span", "last-line");
        this.emitter.characters(Integer.toString(this.oneBasedLastLine));
        this.emitter.endElement("span");
        this.emitter.characters(COLUMN);
        this.emitter.startElementWithClass("span", "last-col");
        this.emitter.characters(Integer.toString(this.oneBasedLastColumn));
        this.emitter.endElement("span");
        this.maybeEmitInResource();
        if (this.willShowSource && this.systemId == null) {
            this.emitter.endElement("a");
        }
    }

    private void emitLineLocation() throws SAXException {
        if (this.willShowSource && this.systemId == null) {
            this.attrs.clear();
            this.attrs.addAttribute("href", "#l" + this.oneBasedLastLine);
            this.emitter.startElement("a", this.attrs);
        }
        this.emitter.characters(ON_LINE);
        this.emitter.startElementWithClass("span", "last-line");
        this.emitter.characters(Integer.toString(this.oneBasedLastLine));
        this.emitter.endElement("span");
        this.maybeEmitInResource();
        if (this.willShowSource && this.systemId == null) {
            this.emitter.endElement("a");
        }
    }

    @Override
    public void startMessage(MessageType type, String aSystemId, int aOneBasedFirstLine, int aOneBasedFirstColumn, int aOneBasedLastLine, int aOneBasedLastColumn, boolean exact) throws SAXException {
        this.systemId = aSystemId;
        this.oneBasedFirstLine = aOneBasedFirstLine;
        this.oneBasedFirstColumn = aOneBasedFirstColumn;
        this.oneBasedLastLine = aOneBasedLastLine;
        this.oneBasedLastColumn = aOneBasedLastColumn;
        this.maybeOpenList();
        this.emitter.startElementWithClass("li", type.getFlatType());
        this.emitter.startElement("p");
        this.emitErrorLevel(type.getPresentationName());
        this.textEmitted = false;
    }

    @Override
    public void endMessages(String language) throws SAXException {
        this.maybeCloseList();
    }

    private void maybeCloseList() throws SAXException {
        if (this.listOpen) {
            this.emitter.endElement("ol");
            this.listOpen = false;
        }
    }

    @Override
    public void endText() throws SAXException {
        this.emitter.endElement("span");
        this.emitter.endElement("p");
        this.textEmitted = true;
        this.maybeEmitLocation(true);
    }

    @Override
    public void startMessages(String documentUri, boolean willShowSource) throws SAXException {
        this.willShowSource = willShowSource;
    }

    @Override
    public MessageTextHandler startText() throws SAXException {
        this.emitter.characters(COLON_SPACE);
        this.emitter.startElement("span");
        return this.messageTextHandler;
    }

    @Override
    public void endSource() throws SAXException {
        this.emitter.endElement("code");
        this.emitter.endElement("p");
    }

    @Override
    public SourceHandler startSource() throws SAXException {
        this.maybeCloseTextPara();
        this.emitter.startElementWithClass("p", "extract");
        this.emitter.startElement("code");
        return this.extractHandler;
    }

    @Override
    public void endFullSource() throws SAXException {
    }

    @Override
    public SourceHandler startFullSource(int lineOffset) throws SAXException {
        this.maybeCloseList();
        this.attrs.clear();
        this.attrs.addAttribute("id", "source");
        this.emitter.startElement("h2", this.attrs);
        this.emitter.characters(SOURCE_CODE);
        this.emitter.endElement("h2");
        return new XhtmlSourceHandler(this.emitter, lineOffset);
    }

    @Override
    public void endResult() throws SAXException {
    }

    @Override
    public ResultHandler startResult() throws SAXException {
        this.maybeCloseList();
        return new XhtmlResultHandler(this.emitter);
    }

    @Override
    public void endElaboration() throws SAXException {
    }

    @Override
    public ContentHandler startElaboration() throws SAXException {
        return this.contentHandler;
    }

    @Override
    public void endImageReview() throws SAXException {
    }

    @Override
    public ImageReviewHandler startImageReview(DocumentFragment instruction, boolean fatal) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("id", "imagereport");
        this.emitter.startElement("h2", this.attrs);
        this.emitter.characters(IMAGE_REPORT);
        this.emitter.endElement("h2");
        if (instruction != null) {
            this.treeParser.parse(instruction);
        }
        return this;
    }

    @Override
    public void endImageGroup() throws SAXException {
        this.emitter.endElement("tbody");
        this.emitter.endElement("table");
    }

    @Override
    public void image(Image image, boolean showAlt, String aSystemId, int aOneBasedFirstLine, int aOneBasedFirstColumn, int aOneBasedLastLine, int aOneBasedLastColumn) throws SAXException {
        this.systemId = null;
        this.oneBasedFirstLine = aOneBasedFirstLine;
        this.oneBasedFirstColumn = aOneBasedFirstColumn;
        this.oneBasedLastLine = aOneBasedLastLine;
        this.oneBasedLastColumn = aOneBasedLastColumn;
        this.emitter.startElement("tr");
        this.imageCell(image);
        if (showAlt) {
            this.altCell(image.getAlt(), image.getLang(), image.isRtl());
        }
        this.locationCell();
        this.emitter.endElement("tr");
    }

    private void locationCell() throws SAXException {
        this.emitter.startElementWithClass("td", "location");
        this.maybeEmitLocation(false);
        this.emitter.endElement("td");
    }

    private void altCell(String alt, String lang, boolean rtl) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("class", "alt");
        if (rtl && alt != null && !"".equals(alt)) {
            this.attrs.addAttribute("dir", "rtl");
        }
        this.emitter.startElement("td", this.attrs);
        if (alt == null) {
            this.emitter.startElement("i");
            this.emitter.characters(NO_ALT);
            this.emitter.endElement("i");
        } else if ("".equals(alt)) {
            this.emitter.startElement("i");
            this.emitter.characters(EMPTY_STRING_AS_ALT);
            this.emitter.endElement("i");
        } else {
            this.attrs.clear();
            this.attrs.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", lang);
            this.emitter.startElement("span", this.attrs);
            this.emitter.characters(alt);
            this.emitter.endElement("span");
        }
        this.emitter.endElement("td");
    }

    private void imageCell(Image image) throws SAXException {
        this.emitter.startElementWithClass("td", "img");
        String src = image.getSrc();
        if (src == null) {
            this.emitter.startElement("i");
            this.emitter.characters(NOT_RESOLVABLE);
            this.emitter.endElement("i");
        } else {
            int width = image.getWidth();
            int height = image.getHeight();
            if (width < 1 || height < 1) {
                height = -1;
                width = -1;
            } else if (width > height) {
                if (width > 180) {
                    height = (int)Math.ceil((double)height * (180.0 / (double)width));
                    width = 180;
                }
            } else if (height > 180) {
                width = (int)Math.ceil((double)width * (180.0 / (double)height));
                height = 180;
            }
            this.attrs.clear();
            this.attrs.addAttribute("src", src);
            if (width != -1) {
                this.attrs.addAttribute("width", Integer.toString(width));
                this.attrs.addAttribute("height", Integer.toString(height));
            }
            this.emitter.startElement("img", this.attrs);
            this.emitter.endElement("img");
        }
        this.emitter.endElement("td");
    }

    @Override
    public void startImageGroup(char[] heading, DocumentFragment instruction, boolean hasAlt) throws SAXException {
        this.emitter.startElement("h3");
        this.emitter.characters(heading);
        this.emitter.endElement("h3");
        this.treeParser.parse(instruction);
        this.emitter.startElementWithClass("table", "imagereview");
        this.emitter.startElement("colgroup");
        this.emitter.startElementWithClass("col", "img");
        this.emitter.endElement("col");
        if (hasAlt) {
            this.emitter.startElementWithClass("col", "alt");
            this.emitter.endElement("col");
        }
        this.emitter.startElementWithClass("col", "location");
        this.emitter.endElement("col");
        this.emitter.endElement("colgroup");
        this.emitter.startElement("thead");
        this.emitter.startElement("tr");
        this.emitter.startElementWithClass("th", "img");
        this.emitter.characters(IMAGE);
        this.emitter.endElement("th");
        if (hasAlt) {
            this.emitter.startElementWithClass("th", "alt");
            this.emitter.characters(TEXTUAL_ALTERNATIVE);
            this.emitter.endElement("th");
        }
        this.emitter.startElementWithClass("th", "location");
        this.emitter.characters(LOCATION);
        this.emitter.endElement("th");
        this.emitter.endElement("tr");
        this.emitter.endElement("thead");
        this.emitter.startElement("tbody");
    }
}

