# This file is part of the MapProxy project.
# Copyright (C) 2010 Omniscale <http://omniscale.de>
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import print_function
import importlib.metadata


def version_string():
    """
    Return the current version number of MapProxy.
    """
    try:
        return importlib.metadata.version('mapproxy')
    except KeyError:
        return 'unknown_version'


__version__ = version = version_string()

if __name__ == '__main__':
    print(__version__)
