/*
 * Decompiled with CFR 0.152.
 */
package org.fife.util;

public class DynamicIntArray {
    private int[] data;
    private int size;

    public DynamicIntArray() {
        this(10);
    }

    public DynamicIntArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + n);
        }
        this.data = new int[n];
        this.size = 0;
    }

    public DynamicIntArray(int[] nArray) {
        this.size = nArray.length;
        int n = (int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE);
        this.data = new int[n];
        System.arraycopy(nArray, 0, this.data, 0, this.size);
    }

    public void add(int n) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = n;
    }

    public void add(int n, int[] nArray) {
        if (n > this.size) {
            this.throwException2(n);
        }
        int n2 = nArray.length;
        this.ensureCapacity(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.data, n, this.data, n + n2, n3);
        }
        System.arraycopy(this.data, n, nArray, 0, n3);
        this.size += n2;
    }

    public void add(int n, int n2) {
        if (n > this.size) {
            this.throwException2(n);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = n2;
        ++this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return true;
        }
        return false;
    }

    private final void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            int[] nArray = this.data;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.data = new int[n3];
            System.arraycopy(nArray, 0, this.data, 0, this.size);
        }
    }

    public int get(int n) {
        if (n >= this.size) {
            this.throwException(n);
        }
        return this.data[n];
    }

    public int getUnsafe(int n) {
        return this.data[n];
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(int n) {
        int n2;
        if (n >= this.size) {
            this.throwException(n);
        }
        if ((n2 = this.size - n - 1) > 0) {
            System.arraycopy(this.data, n + 1, this.data, n, n2);
        }
        --this.size;
    }

    public void removeRange(int n, int n2) {
        if (n >= this.size || n2 > this.size) {
            this.throwException3(n, n2);
        }
        int n3 = this.size - n2;
        System.arraycopy(this.data, n2, this.data, n, n3);
        this.size -= n2 - n;
    }

    public void set(int n, int n2) {
        if (n >= this.size) {
            this.throwException(n);
        }
        this.data[n] = n2;
    }

    public void setUnsafe(int n, int n2) {
        this.data[n] = n2;
    }

    private final void throwException(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Index " + n + " not in valid range [0-" + (this.size - 1) + "]");
    }

    private final void throwException2(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Index " + n + ", not in range [0-" + this.size + "]");
    }

    private final void throwException3(int n, int n2) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Index range [" + n + ", " + n2 + "] not in valid range [0-" + (this.size - 1) + "]");
    }
}

