/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class ReplicationTimeoutType {
    public static final ReplicationTimeoutType ACK_TIMEOUT = new ReplicationTimeoutType("ACK_TIMEOUT", 1);
    public static final ReplicationTimeoutType CHECKPOINT_DELAY = new ReplicationTimeoutType("CHECKPOINT_DELAY", 2);
    public static final ReplicationTimeoutType CONNECTION_RETRY = new ReplicationTimeoutType("CONNECTION_RETRY", 3);
    public static final ReplicationTimeoutType ELECTION_TIMEOUT = new ReplicationTimeoutType("ELECTION_TIMEOUT", 5);
    public static final ReplicationTimeoutType ELECTION_RETRY = new ReplicationTimeoutType("ELECTION_RETRY", 4);
    public static final ReplicationTimeoutType FULL_ELECTION_TIMEOUT = new ReplicationTimeoutType("FULL_ELECTION_TIMEOUT", 6);
    private String statusName;
    private int id;

    static ReplicationTimeoutType fromInt(int n) {
        switch (n) {
            case 1: {
                return ACK_TIMEOUT;
            }
            case 5: {
                return ELECTION_TIMEOUT;
            }
            case 4: {
                return ELECTION_RETRY;
            }
            case 3: {
                return CONNECTION_RETRY;
            }
        }
        throw new IllegalArgumentException("Unknown timeout type: " + n);
    }

    private ReplicationTimeoutType(String string, int n) {
        this.statusName = string;
        this.id = n;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return "ReplicationTimeoutType." + this.statusName;
    }
}

