/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InvalidKeyTest
extends TestCase {
    private static final String BASEDIR;
    private static final String SEP;
    static /* synthetic */ Class class$org$apache$xml$security$test$signature$InvalidKeyTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$signature$InvalidKeyTest == null ? (class$org$apache$xml$security$test$signature$InvalidKeyTest = InvalidKeyTest.class$("org.apache.xml.security.test.signature.InvalidKeyTest")) : class$org$apache$xml$security$test$signature$InvalidKeyTest);
    }

    public void test() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(BASEDIR + SEP + "data/org/apache/xml/security/samples/input/truststore.jks");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(fileInputStream, "testpw".toCharArray());
        try {
            this.validate(keyStore.getCertificate("bedag-test").getPublicKey());
            throw new Exception("Failure expected on a DSA key");
        }
        catch (Exception exception) {
            this.validate(keyStore.getCertificate("a70-garaio-frontend-u").getPublicKey());
            return;
        }
    }

    public void validate(PublicKey publicKey) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(BASEDIR + SEP + "data/org/apache/xml/security/samples/input/test-assertion.xml");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(fileInputStream);
        NodeList nodeList = document.getFirstChild().getChildNodes();
        Element element = (Element)nodeList.item(nodeList.getLength() - 1);
        XMLSignature xMLSignature = new XMLSignature(element, "");
        xMLSignature.checkSignatureValue((Key)publicKey);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
        BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        SEP = System.getProperty("file.separator");
    }
}

