/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.i2p.crypto.EncType;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;

public class LeaseSetKeys {
    private final SigningPrivateKey _revocationKey;
    private final PrivateKey _decryptionKey;
    private final PrivateKey _decryptionKeyEC;
    private final PrivateKey _decryptionKeyPQ;
    public static final Set<EncType> SET_ELG = Collections.unmodifiableSet(EnumSet.of(EncType.ELGAMAL_2048));
    public static final Set<EncType> SET_EC = Collections.unmodifiableSet(EnumSet.of(EncType.ECIES_X25519));
    public static final Set<EncType> SET_BOTH = Collections.unmodifiableSet(EnumSet.of(EncType.ELGAMAL_2048, EncType.ECIES_X25519));
    private static final Set<EncType> SET_NONE = Collections.emptySet();
    public static final Set<EncType> SET_PQ1 = Collections.unmodifiableSet(EnumSet.of(EncType.MLKEM512_X25519));
    public static final Set<EncType> SET_PQ2 = Collections.unmodifiableSet(EnumSet.of(EncType.MLKEM768_X25519));
    public static final Set<EncType> SET_PQ3 = Collections.unmodifiableSet(EnumSet.of(EncType.MLKEM1024_X25519));
    public static final Set<EncType> SET_EC_PQ1 = Collections.unmodifiableSet(EnumSet.of(EncType.ECIES_X25519, EncType.MLKEM512_X25519));
    public static final Set<EncType> SET_EC_PQ2 = Collections.unmodifiableSet(EnumSet.of(EncType.ECIES_X25519, EncType.MLKEM768_X25519));
    public static final Set<EncType> SET_EC_PQ3 = Collections.unmodifiableSet(EnumSet.of(EncType.ECIES_X25519, EncType.MLKEM1024_X25519));
    public static final Set<EncType> SET_EC_PQ_ALL = Collections.unmodifiableSet(EnumSet.of(EncType.ECIES_X25519, EncType.MLKEM512_X25519, EncType.MLKEM768_X25519, EncType.MLKEM1024_X25519));

    public LeaseSetKeys(Destination dest, SigningPrivateKey revocationKey, PrivateKey decryptionKey) {
        this._revocationKey = revocationKey;
        EncType type = decryptionKey.getType();
        if (type == EncType.ELGAMAL_2048) {
            this._decryptionKey = decryptionKey;
            this._decryptionKeyEC = null;
            this._decryptionKeyPQ = null;
        } else if (type == EncType.ECIES_X25519) {
            this._decryptionKey = null;
            this._decryptionKeyEC = decryptionKey;
            this._decryptionKeyPQ = null;
        } else if (type.isPQ()) {
            this._decryptionKey = null;
            this._decryptionKeyEC = null;
            this._decryptionKeyPQ = decryptionKey;
        } else {
            throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
        }
    }

    public LeaseSetKeys(Destination dest, SigningPrivateKey revocationKey, List<PrivateKey> decryptionKeys) {
        if (decryptionKeys.isEmpty()) {
            throw new IllegalArgumentException("no keys");
        }
        this._revocationKey = revocationKey;
        PrivateKey elg = null;
        PrivateKey ec = null;
        PrivateKey pq = null;
        for (PrivateKey pk : decryptionKeys) {
            EncType type = pk.getType();
            if (type == EncType.ELGAMAL_2048) {
                if (elg != null) {
                    throw new IllegalArgumentException("Multiple keys same type");
                }
                if (pq != null) {
                    throw new IllegalArgumentException("Invalid combination ElG + PQ");
                }
                elg = pk;
                continue;
            }
            if (type == EncType.ECIES_X25519) {
                if (ec != null) {
                    throw new IllegalArgumentException("Multiple keys same type");
                }
                ec = pk;
                continue;
            }
            if (type.isPQ()) {
                if (pq != null) {
                    throw new IllegalArgumentException("Multiple keys same type");
                }
                if (elg != null) {
                    throw new IllegalArgumentException("Invalid combination ElG + PQ");
                }
                pq = pk;
                continue;
            }
            throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
        }
        this._decryptionKey = elg;
        this._decryptionKeyEC = ec;
        this._decryptionKeyPQ = pq;
    }

    public SigningPrivateKey getRevocationKey() {
        return this._revocationKey;
    }

    public PrivateKey getDecryptionKey() {
        return this._decryptionKey;
    }

    public PrivateKey getDecryptionKey(EncType type) {
        if (type == EncType.ELGAMAL_2048) {
            return this._decryptionKey;
        }
        if (type == EncType.ECIES_X25519) {
            return this._decryptionKeyEC;
        }
        if (type.isPQ() && this._decryptionKeyPQ != null && this._decryptionKeyPQ.getType() == type) {
            return this._decryptionKeyPQ;
        }
        return null;
    }

    public PrivateKey getPQDecryptionKey() {
        return this._decryptionKeyPQ;
    }

    public boolean isSupported(EncType type) {
        if (type == EncType.ELGAMAL_2048) {
            return this._decryptionKey != null;
        }
        if (type == EncType.ECIES_X25519) {
            return this._decryptionKeyEC != null;
        }
        if (type.isPQ()) {
            return this._decryptionKeyPQ != null && this._decryptionKeyPQ.getType() == type;
        }
        return false;
    }

    public Set<EncType> getSupportedEncryption() {
        if (this._decryptionKey != null) {
            return this._decryptionKeyEC != null ? SET_BOTH : SET_ELG;
        }
        if (this._decryptionKeyPQ != null) {
            if (this._decryptionKeyEC != null) {
                switch (this._decryptionKeyPQ.getType()) {
                    case MLKEM512_X25519: {
                        return SET_EC_PQ1;
                    }
                    case MLKEM768_X25519: {
                        return SET_EC_PQ2;
                    }
                    case MLKEM1024_X25519: {
                        return SET_EC_PQ3;
                    }
                }
            } else {
                switch (this._decryptionKeyPQ.getType()) {
                    case MLKEM512_X25519: {
                        return SET_PQ1;
                    }
                    case MLKEM768_X25519: {
                        return SET_PQ2;
                    }
                    case MLKEM1024_X25519: {
                        return SET_PQ3;
                    }
                }
            }
        }
        return this._decryptionKeyEC != null ? SET_EC : SET_NONE;
    }
}

