/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd;

import java.io.File;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.aarch64.AARCH64ThreadContext;
import sun.jvm.hotspot.debugger.amd64.AMD64ThreadContext;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.bsd.BsdDebuggerLocal;
import sun.jvm.hotspot.debugger.bsd.aarch64.BsdAARCH64CFrame;
import sun.jvm.hotspot.debugger.bsd.amd64.BsdAMD64CFrame;
import sun.jvm.hotspot.debugger.bsd.ppc64.BsdPPC64CFrame;
import sun.jvm.hotspot.debugger.bsd.x86.BsdX86CFrame;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.ppc64.PPC64ThreadContext;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;

class BsdCDebugger
implements CDebugger {
    private BsdDebugger dbg;

    BsdCDebugger(BsdDebugger dbg) {
        this.dbg = dbg;
    }

    @Override
    public List getThreadList() throws DebuggerException {
        return this.dbg.getThreadList();
    }

    @Override
    public List getLoadObjectList() throws DebuggerException {
        return this.dbg.getLoadObjectList();
    }

    @Override
    public LoadObject loadObjectContainingPC(Address pc) throws DebuggerException {
        if (pc == null) {
            return null;
        }
        List objs = this.getLoadObjectList();
        for (int i = 0; i < objs.size(); ++i) {
            LoadObject ob = (LoadObject)objs.get(i);
            Address base = ob.getBase();
            long size = ob.getSize();
            if (!pc.greaterThanOrEqual(base) || !pc.lessThan(base.addOffsetTo(size))) continue;
            return ob;
        }
        return null;
    }

    @Override
    public CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        String cpu = this.dbg.getCPU();
        if (cpu.equals("x86")) {
            X86ThreadContext context = (X86ThreadContext)thread.getContext();
            Address ebp = context.getRegisterAsAddress(6);
            if (ebp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(14);
            if (pc == null) {
                return null;
            }
            return new BsdX86CFrame(this.dbg, ebp, pc);
        }
        if (cpu.equals("amd64") || cpu.equals("x86_64")) {
            AMD64ThreadContext context = (AMD64ThreadContext)thread.getContext();
            Address rbp = context.getRegisterAsAddress(10);
            if (rbp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(17);
            if (pc == null) {
                return null;
            }
            return new BsdAMD64CFrame(this.dbg, rbp, pc);
        }
        if (cpu.equals("ppc64")) {
            PPC64ThreadContext context = (PPC64ThreadContext)thread.getContext();
            Address sp = context.getRegisterAsAddress(30);
            if (sp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(32);
            if (pc == null) {
                return null;
            }
            return new BsdPPC64CFrame(this.dbg, sp, pc, BsdDebuggerLocal.getAddressSize());
        }
        if (cpu.equals("aarch64")) {
            AARCH64ThreadContext context = (AARCH64ThreadContext)thread.getContext();
            Address fp = context.getRegisterAsAddress(29);
            if (fp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(32);
            if (pc == null) {
                return null;
            }
            return new BsdAARCH64CFrame(this.dbg, fp, pc);
        }
        throw new DebuggerException(cpu + " is not yet supported");
    }

    @Override
    public String getNameOfFile(String fileName) {
        return new File(fileName).getName();
    }

    @Override
    public ProcessControl getProcessControl() throws DebuggerException {
        return null;
    }

    @Override
    public boolean canDemangle() {
        return false;
    }

    @Override
    public String demangle(String sym) {
        throw new UnsupportedOperationException();
    }
}

