/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.windbg.amd64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.windbg.WindbgDebugger;
import sun.jvm.hotspot.debugger.windbg.amd64.WindbgAMD64ThreadContext;

class WindbgAMD64Thread
implements ThreadProxy {
    private WindbgDebugger debugger;
    private long sysId;
    private boolean gotID;
    private long id;

    WindbgAMD64Thread(WindbgDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.sysId = addr.getCIntegerAt(0L, 4L, true);
        this.gotID = false;
    }

    WindbgAMD64Thread(WindbgDebugger debugger, long sysId) {
        this.debugger = debugger;
        this.sysId = sysId;
        this.gotID = false;
    }

    @Override
    public ThreadContext getContext() throws IllegalThreadStateException {
        long[] data = this.debugger.getThreadIntegerRegisterSet(this.getThreadID());
        WindbgAMD64ThreadContext context = new WindbgAMD64ThreadContext(this.debugger);
        for (int i = 0; i < data.length; ++i) {
            context.setRegister(i, data[i]);
        }
        return context;
    }

    @Override
    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    @Override
    public void setContext(ThreadContext thrCtx) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WindbgAMD64Thread)) {
            return false;
        }
        return ((WindbgAMD64Thread)obj).getThreadID() == this.getThreadID();
    }

    public int hashCode() {
        return (int)this.getThreadID();
    }

    public String toString() {
        return Long.toString(this.getThreadID());
    }

    private long getThreadID() {
        if (!this.gotID) {
            this.id = this.debugger.getThreadIdFromSysId(this.sysId);
        }
        return this.id;
    }
}

