/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.GenericArray;

public class MethodArray
extends GenericArray {
    private static long dataFieldOffset;
    protected static Type elemType;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        elemType = db.lookupType("Method*");
        Type type = db.lookupType("Array<Method*>");
        dataFieldOffset = type.getAddressField("_data").getOffset();
    }

    public MethodArray(Address addr) {
        super(addr, dataFieldOffset);
    }

    public Method at(int i) {
        return (Method)Metadata.instantiateWrapperFor(this.getAddressAt(i));
    }

    @Override
    public Type getElemType() {
        return elemType;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MethodArray.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

