/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.x11;

import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.ColorModel;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.x11.X11SurfaceData;

public class X11VolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public X11VolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        boolean bl = this.accelerationEnabled = X11SurfaceData.isAccelerationEnabled() && sunVolatileImage.getTransparency() == 1;
        if (object != null && !this.accelerationEnabled) {
            this.accelerationEnabled = true;
            this.sdCurrent = this.sdAccel = this.initAcceleratedSurface();
            if (this.sdBackup != null) {
                this.sdBackup = null;
            }
        }
    }

    @Override
    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    @Override
    protected SurfaceData initAcceleratedSurface() {
        X11SurfaceData.X11PixmapSurfaceData x11PixmapSurfaceData;
        try {
            X11GraphicsConfig x11GraphicsConfig = (X11GraphicsConfig)this.vImg.getGraphicsConfig();
            ColorModel colorModel = x11GraphicsConfig.getColorModel();
            long l = 0L;
            if (this.context instanceof Long) {
                l = (Long)this.context;
            }
            x11PixmapSurfaceData = X11SurfaceData.createData(x11GraphicsConfig, this.vImg.getWidth(), this.vImg.getHeight(), colorModel, this.vImg, l, 1);
        }
        catch (NullPointerException nullPointerException) {
            x11PixmapSurfaceData = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            x11PixmapSurfaceData = null;
        }
        return x11PixmapSurfaceData;
    }

    @Override
    protected boolean isConfigValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration == this.vImg.getGraphicsConfig();
    }

    @Override
    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        if (this.isConfigValid(graphicsConfiguration) && this.isAccelerationEnabled()) {
            return new ImageCapabilities(true);
        }
        return new ImageCapabilities(false);
    }
}

