/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muc.packet.MUCOwner;
import org.jivesoftware.smackx.muc.provider.MUCParserUtils;

public class MUCOwnerProvider
extends IQProvider<MUCOwner> {
    @Override
    public MUCOwner parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        MUCOwner mucOwner = new MUCOwner();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (parser.getName().equals("item")) {
                    mucOwner.addItem(MUCParserUtils.parseItem(parser));
                    continue;
                }
                if (parser.getName().equals("destroy")) {
                    mucOwner.setDestroy(MUCParserUtils.parseDestroy(parser));
                    continue;
                }
                PacketParserUtils.addExtensionElement(mucOwner, parser, xmlEnvironment);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("query")) continue;
            done = true;
        }
        return mucOwner;
    }
}

