/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.Timeouts;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.internal.Helper;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class MySQLLockingSupport
implements LockingSupport,
LockingSupport.Metadata {
    public static final ConnectionLockTimeoutStrategy MYSQL_CONN_LOCK_TIMEOUT_STRATEGY = new ConnectionLockTimeoutStrategyImpl();
    public static final LockingSupport MYSQL_LOCKING_SUPPORT = new MySQLLockingSupport();
    private final boolean laterThanVersion8;

    public MySQLLockingSupport() {
        this.laterThanVersion8 = true;
    }

    public MySQLLockingSupport(DatabaseVersion version) {
        this.laterThanVersion8 = version.isSameOrAfter(8);
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case -2, 0 -> {
                if (this.laterThanVersion8) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -1 -> LockTimeoutType.NONE;
            default -> LockTimeoutType.NONE;
        };
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public boolean supportsNoWait() {
        return this.laterThanVersion8;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.laterThanVersion8;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.IDENTIFIED;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return MYSQL_CONN_LOCK_TIMEOUT_STRATEGY;
    }

    public static class ConnectionLockTimeoutStrategyImpl
    implements ConnectionLockTimeoutStrategy {
        @Override
        public ConnectionLockTimeoutStrategy.Level getSupportedLevel() {
            return ConnectionLockTimeoutStrategy.Level.EXTENDED;
        }

        @Override
        public Timeout getLockTimeout(Connection connection, SessionFactoryImplementor factory) {
            return Helper.getLockTimeout("SELECT @@SESSION.innodb_lock_wait_timeout", resultSet -> {
                int millis = resultSet.getInt(1);
                return switch (millis) {
                    case 0 -> Timeouts.NO_WAIT;
                    case 100000000 -> Timeouts.WAIT_FOREVER;
                    default -> Timeout.milliseconds((int)millis);
                };
            }, connection, factory);
        }

        @Override
        public void setLockTimeout(Timeout timeout, Connection connection, SessionFactoryImplementor factory) {
            Helper.setLockTimeout(timeout, t -> {
                int milliseconds = timeout.milliseconds();
                if (milliseconds == -2) {
                    throw new HibernateException("Connection lock-timeout does not accept skip-locked");
                }
                if (milliseconds == -1) {
                    return 100000000;
                }
                return milliseconds;
            }, "SET @@SESSION.innodb_lock_wait_timeout = %s", connection, factory);
        }
    }
}

