/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBCallback;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBCallback;
import java.io.IOException;
import java.io.InputStream;
import org.bson.BSONCallback;
import org.bson.BasicBSONDecoder;

public class DefaultDBDecoder
extends BasicBSONDecoder
implements DBDecoder {
    public static DBDecoderFactory FACTORY = new DefaultFactory();

    public DBCallback getDBCallback(DBCollection collection) {
        return new DefaultDBCallback(collection);
    }

    public DBObject decode(byte[] b, DBCollection collection) {
        DBCallback cbk = this.getDBCallback(collection);
        cbk.reset();
        this.decode(b, (BSONCallback)cbk);
        return (DBObject)cbk.get();
    }

    public DBObject decode(InputStream in, DBCollection collection) throws IOException {
        DBCallback cbk = this.getDBCallback(collection);
        cbk.reset();
        this.decode(in, (BSONCallback)cbk);
        return (DBObject)cbk.get();
    }

    public String toString() {
        return "DefaultDBDecoder";
    }

    static class DefaultFactory
    implements DBDecoderFactory {
        DefaultFactory() {
        }

        public DBDecoder create() {
            return new DefaultDBDecoder();
        }

        public String toString() {
            return "DefaultDBDecoder.DefaultFactory";
        }
    }
}

