# Contributing to NeoMutt

Thank you for your interest in contributing to NeoMutt! We appreciate your help in making this project better.

> [!NOTE]
>
> NeoMutt is maintained by a dedicated team of volunteers in their free time. We kindly ask that you take a few minutes to read this document before contributing. Your understanding helps ensure smooth collaboration.

## AI Assistance Notice

If you are using any kind of AI assistance while contributing to NeoMutt, **this must be disclosed in the pull request**, along with the extent to which AI assistance was used (e.g., docs only vs. code generation). If PR responses are being generated by an AI, disclose that as well.

An example disclosure:

> This PR was written primarily by Claude Code.

Or a more detailed disclosure:

> I consulted ChatGPT to understand the codebase but the solution was fully authored manually by myself.

Failure to disclose this is first and foremost rude to the human maintainers on the other end of the pull request, but it also makes it difficult to determine how much scrutiny to apply to the contribution.

In a perfect world, AI assistance would produce equal or higher quality work than any human. That isn't the world we live in today, and in most cases, it's generating subpar results.

When using AI assistance, we expect contributors to understand the code that is produced and be able to answer critical questions about it. It isn't a maintainer's job to review a PR so broken that it requires significant rework to be acceptable.

Please be respectful to maintainers and disclose AI assistance.

## Reporting Bugs

We have a [bug report template](https://github.com/neomutt/neomutt/blob/main/.github/ISSUE_TEMPLATE/bug-report.md) that guides you through providing the necessary information. Please follow it when opening an issue to ensure we have all the details needed to help you.

To help us help you, please provide as many details as possible:

- Provide a minimal working example. Try to replicate your issue with the minimal configuration from your NeoMutt config and/or any other relevant config files.
- Be very careful when writing down the steps to reproduce your problem—sometimes even small details matter.
- Include a list of versions of **all** programs relevant to your report.
- Use Markdown syntax, especially for backtraces and config files.

## Feature Requests

We have a [feature request template](https://github.com/neomutt/neomutt/blob/main/.github/ISSUE_TEMPLATE/feature-request.md) that helps structure your proposal. Please follow it when opening a feature request.

When requesting a feature:

- Describe your problem and its context in detail. Often, the problem can be solved without implementing a new feature.
- Describe your desired solution carefully. Nothing is more frustrating, for both you and the developers, if we misunderstand your problem and implement something that doesn't help you.
- Make sure you don't fall into the trap of the [XY Problem](https://xyproblem.info/).

## Pull Requests

We have a [pull request template](https://github.com/neomutt/neomutt/blob/main/.github/PULL_REQUEST_TEMPLATE.md) that guides you through the submission process. Please fill it out completely when opening a PR.

When submitting a pull request:

- The first line should be a short (50 characters or less) summary of your commit message. If you can't find a short enough one-line summary, split the commit into multiple ones.
- Keep one blank line between the one-line summary and the body.
- Use bullet points in the body of the commit message to separate multiple things you did.
- Keep your commits clear and concise. Avoid combining two features or bug fixes into one commit, as it makes them harder to understand. Don't hesitate to [rewrite](https://git-scm.com/book/en/v2/Git-Tools-Rewriting-History) the Git history of your development branch.
- Wrap the body of the commit message at around 80 characters.
- If your commit addresses a particular pull request (PR), commit, or issue, please reference it. The GitHub documentation ([1](https://docs.github.com/en/get-started/writing-on-github/working-with-advanced-formatting/autolinked-references-and-urls) and [2](https://docs.github.com/en/issues/tracking-your-work-with-issues/using-issues/linking-a-pull-request-to-an-issue)) can help you with that.
- Eliminate any warnings that `gcc` or other tools produce during compilation.
- If your commit addresses only a specific method or file, mention it in your commit message.

Thank you for your contributions!

The NeoMutt Team
