/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.semantics;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractManagedProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.semantics.SemanticTag;
import org.openhab.core.semantics.SemanticTagProvider;
import org.openhab.core.semantics.dto.SemanticTagDTO;
import org.openhab.core.semantics.dto.SemanticTagDTOMapper;
import org.openhab.core.storage.StorageService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(immediate=true, service={SemanticTagProvider.class, ManagedSemanticTagProvider.class})
public class ManagedSemanticTagProvider
extends AbstractManagedProvider<SemanticTag, String, SemanticTagDTO>
implements SemanticTagProvider {
    @Activate
    public ManagedSemanticTagProvider(@Reference StorageService storageService) {
        super(storageService);
    }

    protected String getStorageName() {
        return SemanticTag.class.getName();
    }

    protected String keyToString(String key) {
        return key;
    }

    public Collection<SemanticTag> getAll() {
        return super.getAll().stream().sorted(Comparator.comparing(Identifiable::getUID)).toList();
    }

    protected @Nullable SemanticTag toElement(String uid, SemanticTagDTO persistedTag) {
        return SemanticTagDTOMapper.map(persistedTag);
    }

    protected SemanticTagDTO toPersistableElement(SemanticTag tag) {
        return SemanticTagDTOMapper.map(tag);
    }
}

