/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectDoubleAssociativeContainer;
import com.carrotsearch.hppc.ObjectDoubleHashMap;
import com.carrotsearch.hppc.ObjectDoubleMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.comparators.ObjectDoubleComparator;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectDoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.ObjectDoublePredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.ObjectDoubleProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationObjectDoubleHashMap<KType>
implements ObjectDoubleMap<KType> {
    public final ObjectDoubleHashMap<KType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectDoubleHashMap(ObjectDoubleHashMap<KType> delegate, Comparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectDoubleHashMap(ObjectDoubleHashMap<KType> delegate, ObjectDoubleComparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectDoubleComparator<KType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final double[] values;
            {
                this.keys = SortedIterationObjectDoubleHashMap.this.delegate.keys;
                this.values = SortedIterationObjectDoubleHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectDoubleCursor<KType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectDoublePredicate<? super KType> predicate) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectDoubleProcedure<? super KType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectDoublePredicate<? super KType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public DoubleContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public double get(KType key) {
        return this.delegate.get(key);
    }

    @Override
    public double getOrDefault(KType key, double defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public double put(KType key, double value) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectDoubleAssociativeContainer<? extends KType> container) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectDoubleCursor<? extends KType>> iterable) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public double putOrAdd(KType key, double putValue, double incrementValue) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public double addTo(KType key, double additionValue) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public double remove(KType key) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public double indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public double indexReplace(int index, double newValue) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key, double value) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public double indexRemove(int index) {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectDoubleHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectDoubleCursor<KType>> {
        private final ObjectDoubleCursor<KType> cursor = new ObjectDoubleCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectDoubleCursor<KType> fetch() {
            if (this.index < SortedIterationObjectDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectDoubleHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectDoubleCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectDoubleHashMap<KType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectDoubleHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final SortedIterationObjectDoubleHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectDoubleHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            for (ObjectDoubleCursor c : this.owner) {
                if (Double.doubleToLongBits(value) != Double.doubleToLongBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(double e) {
            throw SortedIterationObjectDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            throw SortedIterationObjectDoubleHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.index < SortedIterationObjectDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectDoubleHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

