/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.openapi.project.ProjectManager;
import com.jetbrains.performancePlugin.ProjectLoadedKt;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public final class CommandsRunner {
    private static CommandsRunner myCommandsRunner;
    private CompletableFuture<?> actionCallback;

    static synchronized CommandsRunner getInstance() {
        if (myCommandsRunner == null) {
            myCommandsRunner = new CommandsRunner();
        }
        return myCommandsRunner;
    }

    public static void doRunScript(@NotNull String text) {
        if (text == null) {
            CommandsRunner.$$$reportNull$$$0(0);
        }
        ProjectLoadedKt.runPerformanceScript(ProjectManager.getInstance().getOpenProjects()[0], text, false);
    }

    public static void setActionCallback(CompletableFuture<?> actionCallback) {
        CommandsRunner.getInstance().actionCallback = actionCallback;
    }

    public static boolean haveCommandsFinished() {
        if (CommandsRunner.getInstance().actionCallback == null) {
            return false;
        }
        return CommandsRunner.getInstance().actionCallback.isDone();
    }

    public static boolean haveCommandsFinishedSuccessfully() {
        return CommandsRunner.haveCommandsFinished();
    }

    public static boolean haveCommandsFailed() {
        return CommandsRunner.getInstance().actionCallback.isCancelled();
    }

    public static int getPid() {
        OperatingSystem os = new SystemInfo().getOperatingSystem();
        OSProcess myProc = os.getProcess(os.getProcessId());
        return myProc.getProcessID();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/CommandsRunner", "doRunScript"));
    }
}

