let _ = Mltop.add_known_module "coq-core.plugins.ltac2"

# 13 "plugins/ltac2/g_ltac2.mlg"
 

open Pp
open Util
open Names
open Pcoq
open Pcoq.Prim
open Attributes
open Constrexpr
open Tac2expr
open Tac2qexpr

let lk_ident_or_anti =
  Pcoq.Lookahead.(lk_ident <+> (lk_kw "$" >> lk_ident >> check_no_space))

(* lookahead for (x:=t), (?x:=t) and (1:=t) *)
let test_lpar_idnum_coloneq =
  let open Pcoq.Lookahead in
  to_entry "test_lpar_idnum_coloneq" begin
    lk_kw "(" >> (lk_ident_or_anti <+> lk_nat) >> lk_kw ":="
  end

(* lookahead for (x:t), (?x:t) *)
let test_lpar_id_colon =
  let open Pcoq.Lookahead in
  to_entry "test_lpar_id_colon" begin
    lk_kw "(" >> lk_ident_or_anti >> lk_kw ":"
  end

(* Hack to recognize "(x := t)" and "($x := t)" *)
let test_lpar_id_coloneq =
  let open Pcoq.Lookahead in
  to_entry "test_lpar_id_coloneq" begin
    lk_kw "(" >> lk_ident_or_anti >> lk_kw ":="
  end

(* Hack to recognize "(x)" *)
let test_lpar_id_rpar =
  let open Pcoq.Lookahead in
  to_entry "test_lpar_id_rpar" begin
    lk_kw "(" >> lk_ident >> lk_kw ")"
  end

let test_ampersand_ident =
  let open Pcoq.Lookahead in
  to_entry "test_ampersand_ident" begin
    lk_kw "&" >> lk_ident >> check_no_space
  end

let test_dollar_ident =
  let open Pcoq.Lookahead in
  to_entry "test_dollar_ident" begin
    lk_kw "$" >> lk_ident >> check_no_space
  end

let test_dollar_ident_colon_ident =
  let open Pcoq.Lookahead in
  to_entry "test_dollar_ident_colon_ident" begin
    lk_kw "$" >> lk_ident >> lk_kw ":" >> lk_ident >> check_no_space
  end

let test_ltac1_env =
  let open Pcoq.Lookahead in
  to_entry "test_ltac1_env" begin
    lk_ident_list >> lk_kw "|-"
  end

let test_qualid_with_or_lpar_or_rbrac =
  let open Pcoq.Lookahead in
  to_entry "test_qualid_with_or_lpar_or_rbrac" begin
    (lk_qualid >> lk_kw "with") <+> lk_kw "(" <+> lk_kw "{"
  end

let test_array_opening =
  let open Pcoq.Lookahead in
  to_entry "test_array_opening" begin
    lk_kw "[" >> lk_kw "|" >> check_no_space
  end

let test_array_closing =
  let open Pcoq.Lookahead in
  to_entry "test_array_closing" begin
    lk_kw "|" >> lk_kw "]" >> check_no_space
  end

let test_leftsquarebracket_equal =
  let open Pcoq.Lookahead in
  to_entry "test_leftsquarebracket_equal" begin
    lk_kw "[" >> lk_kw "=" >> check_no_space
  end

let ltac2_expr = Tac2entries.Pltac.ltac2_expr
let _ltac2_expr = ltac2_expr
let ltac2_type = Entry.make "ltac2_type"
let tac2def_val = Entry.make "tac2def_val"
let tac2def_typ = Entry.make "tac2def_typ"
let tac2def_ext = Entry.make "tac2def_ext"
let tac2def_syn = Entry.make "tac2def_syn"
let tac2def_mut = Entry.make "tac2def_mut"
let tac2mode = Entry.make "ltac2_command"
let ltac2_atom = Entry.make "ltac2_atom"

let tac2expr_in_env = Tac2entries.Pltac.tac2expr_in_env

let inj_wit wit loc x = CAst.make ~loc @@ CTacExt (wit, x)
let inj_open_constr loc c = inj_wit Tac2quote.wit_open_constr loc c
let inj_pattern loc c = inj_wit Tac2quote.wit_pattern loc c
let inj_reference loc c = inj_wit Tac2quote.wit_reference loc c

let pattern_of_qualid qid =
  if Tac2env.is_constructor qid then CAst.make ?loc:qid.CAst.loc @@ CPatRef (RelId qid, [])
  else
    let open Libnames in
    if qualid_is_ident qid then CAst.make ?loc:qid.CAst.loc @@ CPatVar (Name (qualid_basename qid))
    else
      CErrors.user_err ?loc:qid.CAst.loc (Pp.str "Syntax error")

let opt_fun ?loc args ty e =
  let e = match ty with
  | None -> e
  | Some ty -> CAst.make ?loc:e.CAst.loc (CTacCnv (e, ty))
  in
  match args with
  | [] -> e
  | _ :: _ -> CAst.make ?loc (CTacFun (args, e))



let _ = let tac2pat = Pcoq.Entry.make "tac2pat"
        and atomic_tac2pat = Pcoq.Entry.make "atomic_tac2pat"
        and array_literal = Pcoq.Entry.make "array_literal"
        and list_literal = Pcoq.Entry.make "list_literal"
        and branches = Pcoq.Entry.make "branches"
        and branch = Pcoq.Entry.make "branch"
        and rec_flag = Pcoq.Entry.make "rec_flag"
        and mut_flag = Pcoq.Entry.make "mut_flag"
        and ltac2_typevar = Pcoq.Entry.make "ltac2_typevar"
        and type_cast = Pcoq.Entry.make "type_cast"
        and let_clause = Pcoq.Entry.make "let_clause"
        and let_binder = Pcoq.Entry.make "let_binder"
        and binder = Pcoq.Entry.make "binder"
        and input_fun = Pcoq.Entry.make "input_fun"
        and tac2def_body = Pcoq.Entry.make "tac2def_body"
        and tac2typ_knd = Pcoq.Entry.make "tac2typ_knd"
        and tac2alg_constructors = Pcoq.Entry.make "tac2alg_constructors"
        and tac2alg_constructor = Pcoq.Entry.make "tac2alg_constructor"
        and tac2rec_fields = Pcoq.Entry.make "tac2rec_fields"
        and tac2rec_field = Pcoq.Entry.make "tac2rec_field"
        and tac2rec_fieldexprs = Pcoq.Entry.make "tac2rec_fieldexprs"
        and tac2rec_fieldexpr = Pcoq.Entry.make "tac2rec_fieldexpr"
        and tac2rec_fieldpats = Pcoq.Entry.make "tac2rec_fieldpats"
        and tac2rec_fieldpat = Pcoq.Entry.make "tac2rec_fieldpat"
        and tac2typ_prm = Pcoq.Entry.make "tac2typ_prm"
        and tac2typ_def = Pcoq.Entry.make "tac2typ_def"
        and tac2type_body = Pcoq.Entry.make "tac2type_body"
        and syn_node = Pcoq.Entry.make "syn_node"
        and ltac2_scope = Pcoq.Entry.make "ltac2_scope"
        and syn_level = Pcoq.Entry.make "syn_level"
        and globref = Pcoq.Entry.make "globref"
        in
        let () = assert (Pcoq.Entry.is_empty tac2pat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:0")
        tac2pat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(Some ("1"), Some (Gramlib.Gramext.LeftA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm tac2pat)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                  ((Pcoq.Symbol.nterm identref)))
                                  (fun id _ p loc -> 
# 158 "plugins/ltac2/g_ltac2.mlg"
                                              CAst.make ~loc @@ CPatAs (p,id) 
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm tac2pat)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun pl _ p loc -> 
# 156 "plugins/ltac2/g_ltac2.mlg"
          let pl = p :: pl in
          CAst.make ~loc @@ CPatOr pl 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("::")))))
                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                 (fun p2 _ p1 loc -> 
# 154 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_cons), [p1; p2])
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid loc -> 
# 151 "plugins/ltac2/g_ltac2.mlg"
                               pattern_of_qualid qid 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterml tac2pat ("0"))))))
                                 (fun pl qid loc -> 
# 146 "plugins/ltac2/g_ltac2.mlg"
                                                            
        if Tac2env.is_constructor qid then
          CAst.make ~loc @@ CPatRef (RelId qid, pl)
        else
          CErrors.user_err ~loc (Pp.str "Syntax error") 
                                                    )]);
                                (Some ("0"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm tac2pat)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (";"))])) false)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ pats _ loc -> 
# 169 "plugins/ltac2/g_ltac2.mlg"
         
          let nil = CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_nil), []) in
          let cons hd tl = CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_cons), [hd;tl]) in
          List.fold_right cons pats nil
        
                                                      );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                                ((Pcoq.Symbol.nterm tac2rec_fieldpats)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("}")))))
                                (fun _ a _ loc -> 
# 167 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ CPatRecord a 
                                                  );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                ((Pcoq.Symbol.nterm atomic_tac2pat)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ p _ loc -> 
# 166 "plugins/ltac2/g_ltac2.mlg"
                                          p 
                                                  );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm Prim.qualid)))
                                (fun qid loc -> 
# 165 "plugins/ltac2/g_ltac2.mlg"
                               pattern_of_qualid qid 
                                                );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm Prim.string)))
                                (fun s loc -> 
# 164 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc @@ CPatAtm (AtmStr s) 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm Prim.integer)))
                                (fun n loc -> 
# 163 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc @@ CPatAtm (AtmInt n) 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("()")))))
                                (fun _ loc -> 
# 162 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ CPatRef (AbsKn (Tuple 0), []) 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                (fun _ loc -> 
# 161 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ CPatVar Anonymous 
                                              )])]))
        in let () = assert (Pcoq.Entry.is_empty atomic_tac2pat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:1")
        atomic_tac2pat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm tac2pat)))
                                  (fun p loc -> 
# 184 "plugins/ltac2/g_ltac2.mlg"
                         p 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (",")))))
                                                 ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm tac2pat)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                 (fun pl _ p loc -> 
# 182 "plugins/ltac2/g_ltac2.mlg"
          let pl = p :: pl in
          CAst.make ~loc @@ CPatRef (AbsKn (Tuple (List.length pl)), pl) 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Pcoq.Symbol.nterm ltac2_type)))
                                 (fun t _ p loc -> 
# 180 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatCnv (p, t) 
                                                   );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 178 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatRef (AbsKn (Tuple 0), []) 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_expr) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:2")
        ltac2_expr
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(Some ("6"), Some (Gramlib.Gramext.RightA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  (Pcoq.Symbol.self))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                  (Pcoq.Symbol.self))
                                  (fun e2 _ e1 loc -> 
# 189 "plugins/ltac2/g_ltac2.mlg"
                                         CAst.make ~loc @@ CTacSeq (e1, e2) 
                                                      )]);
                                (Some ("5"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("if")))))
                                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("then")))))
                                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("else")))))
                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                 (fun e2 _ e1 _ e _ loc -> 
# 200 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacIft (e, e1, e2) 
                                                           );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("match")))))
                                                                ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                                ((Pcoq.Symbol.nterm branches)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("end")))))
                                (fun _ bl _ e _ loc -> 
# 198 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCse (e, bl) 
                                                       );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("let")))))
                                                                ((Pcoq.Symbol.nterm rec_flag)))
                                                                ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm let_clause)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("in")))))
                                                ((Pcoq.Symbol.nterml ltac2_expr ("6"))))
                                (fun e _ lc isrec _ loc -> 
# 196 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacLet (isrec, lc, e) 
                                                           );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("fun")))))
                                                                ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm input_fun)))))
                                                                ((Pcoq.Symbol.nterm type_cast)))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("=>")))))
                                                ((Pcoq.Symbol.nterml ltac2_expr ("6"))))
                                (fun body _ ty it _ loc -> 
# 192 "plugins/ltac2/g_ltac2.mlg"
          opt_fun ~loc it ty body 
                                                           )]);
                                (Some ("4"), Some (Gramlib.Gramext.LeftA),
                                []);
                                (Some ("3"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 (Pcoq.Symbol.self))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (",")))))
                                                 ((Pcoq.Symbol.list1sep (Pcoq.Symbol.next) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                 (fun el _ e0 loc -> 
# 204 "plugins/ltac2/g_ltac2.mlg"
          let el = e0 :: el in
          CAst.make ~loc @@ CTacApp (CAst.make ~loc @@ CTacCst (AbsKn (Tuple (List.length el))), el) 
                                                     )]);
                                (Some ("2"), Some (Gramlib.Gramext.RightA),
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("::")))))
                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                 (fun e2 _ e1 loc -> 
# 208 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacApp (CAst.make ~loc @@ CTacCst (AbsKn (Other Tac2core.Core.c_cons)), [e1; e2]) 
                                                     )]);
                                (Some ("1"), Some (Gramlib.Gramext.LeftA),
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 (Pcoq.Symbol.self))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (".(")))))
                                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                 (fun r _ _ qid _ e loc -> 
# 216 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacSet (e, RelId qid, r) 
                                                           );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                (Pcoq.Symbol.self))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (".(")))))
                                                                ((Pcoq.Symbol.nterm Prim.qualid)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ qid _ e loc -> 
# 214 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacPrj (e, RelId qid) 
                                                      );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.nterm ltac2_expr)))
                                                ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterml ltac2_expr ("0"))))))
                                (fun el e loc -> 
# 212 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacApp (e, el) 
                                                 )]);
                                (Some ("0"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ltac2_atom)))
                                 (fun a loc -> 
# 231 "plugins/ltac2/g_ltac2.mlg"
                            a 
                                               );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                                ((Pcoq.Symbol.nterm tac2rec_fieldexprs)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("}")))))
                                (fun _ a _ loc -> 
# 230 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacRec (None, a) 
                                                  );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                                ((Pcoq.Symbol.nterm test_qualid_with_or_lpar_or_rbrac)))
                                                                ((Pcoq.Symbol.nterml ltac2_expr ("0"))))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                                ((Pcoq.Symbol.nterm tac2rec_fieldexprs)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("}")))))
                                (fun _ a _ e _ _ loc -> 
# 228 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacRec (Some e, a) 
                                                        );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm list_literal)))
                                (fun a loc -> 
# 226 "plugins/ltac2/g_ltac2.mlg"
                              a 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm array_literal)))
                                (fun a loc -> 
# 225 "plugins/ltac2/g_ltac2.mlg"
                               a 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ _ loc -> 
# 224 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCst (AbsKn (Tuple 0)) 
                                                );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("()")))))
                                (fun _ loc -> 
# 222 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCst (AbsKn (Tuple 0)) 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                (Pcoq.Symbol.self))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                ((Pcoq.Symbol.nterm ltac2_type)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ t _ a _ loc -> 
# 220 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCnv (a, t) 
                                                      );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                (Pcoq.Symbol.self))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ a _ loc -> 
# 218 "plugins/ltac2/g_ltac2.mlg"
                                a 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty array_literal) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:3")
        array_literal
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm test_array_opening)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterml ltac2_expr ("5"))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (";"))])) false)))
                                                                  ((Pcoq.Symbol.nterm test_array_closing)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ _ _ a _ _ _ loc -> 
# 236 "plugins/ltac2/g_ltac2.mlg"
        Tac2quote.array_literal ~loc a 
                                                            )])]))
        in let () = assert (Pcoq.Entry.is_empty list_literal) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:4")
        list_literal
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterml ltac2_expr ("5"))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (";"))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ a _ loc -> 
# 240 "plugins/ltac2/g_ltac2.mlg"
         Tac2quote.of_list ~loc (fun x -> x) a 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty branches) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:5")
        branches
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm branch)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                  (fun bl loc -> 
# 245 "plugins/ltac2/g_ltac2.mlg"
                                     bl 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm branch)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun bl _ loc -> 
# 244 "plugins/ltac2/g_ltac2.mlg"
                                          bl 
                                                  );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 243 "plugins/ltac2/g_ltac2.mlg"
           [] 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty branch) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:6")
        branch
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm atomic_tac2pat)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("=>")))))
                                                  ((Pcoq.Symbol.nterml ltac2_expr ("6"))))
                                  (fun e _ pat loc -> 
# 249 "plugins/ltac2/g_ltac2.mlg"
                                                                (pat, e) 
                                                      )])]))
        in let () = assert (Pcoq.Entry.is_empty rec_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:7")
        rec_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 253 "plugins/ltac2/g_ltac2.mlg"
             false 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("rec"))))))
                                 (fun _ loc -> 
# 252 "plugins/ltac2/g_ltac2.mlg"
                         true 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty mut_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:8")
        mut_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 257 "plugins/ltac2/g_ltac2.mlg"
             false 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("mutable"))))))
                                 (fun _ loc -> 
# 256 "plugins/ltac2/g_ltac2.mlg"
                             true 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_typevar) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:9")
        ltac2_typevar
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("'")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 260 "plugins/ltac2/g_ltac2.mlg"
                                  id 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_atom) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:10")
        ltac2_atom
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("reference"))))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.nterm globref)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ c _ _ _ loc -> 
# 278 "plugins/ltac2/g_ltac2.mlg"
                                                           inj_reference loc c 
                                                        );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("pat"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm Constr.cpattern)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 277 "plugins/ltac2/g_ltac2.mlg"
                                                             inj_pattern loc c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("ident"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm identref)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 276 "plugins/ltac2/g_ltac2.mlg"
                                                        Tac2quote.of_ident c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("preterm"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 275 "plugins/ltac2/g_ltac2.mlg"
                                                                Tac2quote.of_preterm c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("open_constr"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 274 "plugins/ltac2/g_ltac2.mlg"
                                                                    Tac2quote.of_open_constr c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("constr"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 273 "plugins/ltac2/g_ltac2.mlg"
                                                               Tac2quote.of_constr c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("'")))))
                                                 ((Pcoq.Symbol.nterm Constr.constr)))
                                 (fun c _ loc -> 
# 272 "plugins/ltac2/g_ltac2.mlg"
                                    inj_open_constr loc c 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                 ((Pcoq.Symbol.nterm identref)))
                                 (fun id _ loc -> 
# 271 "plugins/ltac2/g_ltac2.mlg"
                                Tac2quote.of_hyp ~loc id 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("@")))))
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun id _ loc -> 
# 270 "plugins/ltac2/g_ltac2.mlg"
                                  Tac2quote.of_ident (CAst.make ~loc id) 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid loc -> 
# 266 "plugins/ltac2/g_ltac2.mlg"
        if Tac2env.is_constructor qid then
          CAst.make ~loc @@ CTacCst (RelId qid)
        else
          CAst.make ~loc @@ CTacRef (RelId qid) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.string)))
                                 (fun s loc -> 
# 264 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc @@ CTacAtm (AtmStr s) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.integer)))
                                 (fun n loc -> 
# 263 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc @@ CTacAtm (AtmInt n) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2expr_in_env) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:11")
        tac2expr_in_env
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun tac loc -> 
# 290 "plugins/ltac2/g_ltac2.mlg"
                              [], tac 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_ltac1_env)))
                                                                 ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm identref))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                 (fun e _ ids _ loc -> 
# 283 "plugins/ltac2/g_ltac2.mlg"
        let check { CAst.v = id; CAst.loc = loc } =
          if Tac2env.is_constructor (Libnames.qualid_of_ident ?loc id) then
            CErrors.user_err ?loc Pp.(str "Invalid bound Ltac2 identifier " ++ Id.print id)
        in
        let () = List.iter check ids in
        (ids, e)
      
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty type_cast) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:12")
        type_cast
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                  ((Pcoq.Symbol.nterm ltac2_type)))
                                  (fun ty _ loc -> 
# 295 "plugins/ltac2/g_ltac2.mlg"
                                  Some ty 
                                                   );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 294 "plugins/ltac2/g_ltac2.mlg"
             None 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty let_clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:13")
        let_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm let_binder)))
                                                                  ((Pcoq.Symbol.nterm type_cast)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun te _ ty binder loc -> 
# 300 "plugins/ltac2/g_ltac2.mlg"
        let (pat, fn) = binder in
        let te = opt_fun ~loc fn ty te in
        (pat, te) 
                                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty let_binder) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:14")
        let_binder
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm input_fun)))))
                                  (fun pats loc -> 
# 307 "plugins/ltac2/g_ltac2.mlg"
        match pats with
        | [{CAst.v=CPatVar _} as pat] -> (pat, [])
        | ({CAst.v=CPatVar (Name id)} as pat) :: args -> (pat, args)
        | [pat] -> (pat, [])
        | _ -> CErrors.user_err ~loc (str "Invalid pattern") 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_type) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:15")
        ltac2_type
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(Some ("5"), Some (Gramlib.Gramext.RightA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm ltac2_type)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                                  ((Pcoq.Symbol.nterm ltac2_type)))
                                  (fun t2 _ t1 loc -> 
# 316 "plugins/ltac2/g_ltac2.mlg"
                                                    CAst.make ~loc @@ CTypArrow (t1, t2) 
                                                      )]);
                                (Some ("2"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ltac2_type)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterml ltac2_type ("1"))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("*"))])) false)))
                                 (fun tl _ t loc -> 
# 319 "plugins/ltac2/g_ltac2.mlg"
        let tl = t :: tl in
        CAst.make ~loc @@ CTypRef (AbsKn (Tuple (List.length tl)), tl) 
                                                    )]);
                                (Some ("1"), Some (Gramlib.Gramext.LeftA),
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 (Pcoq.Symbol.self))
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid t loc -> 
# 322 "plugins/ltac2/g_ltac2.mlg"
                                         CAst.make ~loc @@ CTypRef (RelId qid, [t]) 
                                                   )]);
                                (Some ("0"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid loc -> 
# 332 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ CTypRef (RelId qid, []) 
                                                 );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                (fun _ loc -> 
# 331 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ CTypVar Anonymous 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm ltac2_typevar)))
                                (fun id loc -> 
# 330 "plugins/ltac2/g_ltac2.mlg"
                                CAst.make ~loc @@ CTypVar (Name id) 
                                               );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterml ltac2_type ("5"))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                                ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm Prim.qualid))))
                                (fun qid _ p _ loc -> 
# 325 "plugins/ltac2/g_ltac2.mlg"
          match p, qid with
          | [t], None -> t
          | _, None -> CErrors.user_err ~loc (Pp.str "Syntax error")
          | ts, Some qid -> CAst.make ~loc @@ CTypRef (RelId qid, p)
        
                                                      )])]))
        in let () = assert (Pcoq.Entry.is_empty binder) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:16")
        binder
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun l loc -> 
# 337 "plugins/ltac2/g_ltac2.mlg"
                            CAst.make ~loc (Name l) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                 (fun _ loc -> 
# 336 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc Anonymous 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty input_fun) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:17")
        input_fun
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterml tac2pat ("0"))))
                                  (fun b loc -> 
# 340 "plugins/ltac2/g_ltac2.mlg"
                                   b 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_body) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:18")
        tac2def_body
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm binder)))
                                                                  ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm input_fun))))
                                                                  ((Pcoq.Symbol.nterm type_cast)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun e _ ty it name loc -> 
# 344 "plugins/ltac2/g_ltac2.mlg"
        (name, opt_fun ~loc it ty e) 
                                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_val) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:19")
        tac2def_val
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm mut_flag)))
                                                                  ((Pcoq.Symbol.nterm rec_flag)))
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm tac2def_body)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                                  (fun l isrec mut loc -> 
# 349 "plugins/ltac2/g_ltac2.mlg"
          StrVal (mut, isrec, l) 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_mut) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:20")
        tac2def_mut
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("Set")))))
                                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                                                  ((Pcoq.Symbol.opt (Pcoq.Symbol.rules 
                                                                  [Pcoq.Rules.make 
                                                                  (Pcoq.Rule.next_norec 
                                                                  (Pcoq.Rule.next_norec 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                                  ((Pcoq.Symbol.nterm identref)))
                                                                  (fun id _
                                                                  loc -> 
                                                                  
# 353 "plugins/ltac2/g_ltac2.mlg"
                                                                       id 
                                                                  )]))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun e _ old qid _ loc -> 
# 353 "plugins/ltac2/g_ltac2.mlg"
                                                                                                         StrMut (qid, old, e) 
                                                            )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2typ_knd) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:21")
        tac2typ_knd
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                                  ((Pcoq.Symbol.nterm tac2rec_fields)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("}")))))
                                  (fun _ t _ loc -> 
# 359 "plugins/ltac2/g_ltac2.mlg"
                                         CTydRec t 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm tac2alg_constructors)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ t _ loc -> 
# 358 "plugins/ltac2/g_ltac2.mlg"
                                                CTydAlg t 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("..")))))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ _ _ loc -> 
# 357 "plugins/ltac2/g_ltac2.mlg"
                            CTydOpn 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ltac2_type)))
                                 (fun t loc -> 
# 356 "plugins/ltac2/g_ltac2.mlg"
                            CTydDef (Some t) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2alg_constructors)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:22")
        tac2alg_constructors
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm tac2alg_constructor)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                  (fun cs loc -> 
# 363 "plugins/ltac2/g_ltac2.mlg"
                                                    cs 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm tac2alg_constructor)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun cs _ loc -> 
# 362 "plugins/ltac2/g_ltac2.mlg"
                                                         cs 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2alg_constructor)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:23")
        tac2alg_constructor
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm ltac2_type)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ args _ c loc -> 
# 367 "plugins/ltac2/g_ltac2.mlg"
                                                                      (c, args) 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun c loc -> 
# 366 "plugins/ltac2/g_ltac2.mlg"
                            (c, []) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fields) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:24")
        tac2rec_fields
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 373 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm tac2rec_field)))
                                 (fun f loc -> 
# 372 "plugins/ltac2/g_ltac2.mlg"
                               [f] 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_field)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                 (fun _ f loc -> 
# 371 "plugins/ltac2/g_ltac2.mlg"
                                    [f] 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_field)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                 ((Pcoq.Symbol.nterm tac2rec_fields)))
                                 (fun l _ f loc -> 
# 370 "plugins/ltac2/g_ltac2.mlg"
                                                        f :: l 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_field) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:25")
        tac2rec_field
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm mut_flag)))
                                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                  ((Pcoq.Symbol.nterm ltac2_type)))
                                  (fun t _ id mut loc -> 
# 376 "plugins/ltac2/g_ltac2.mlg"
                                                                  (id, mut, t) 
                                                         )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fieldexprs)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:26")
        tac2rec_fieldexprs
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 382 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm tac2rec_fieldexpr)))
                                 (fun f loc -> 
# 381 "plugins/ltac2/g_ltac2.mlg"
                                  [f] 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_fieldexpr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                 (fun _ f loc -> 
# 380 "plugins/ltac2/g_ltac2.mlg"
                                        [f] 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_fieldexpr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                 ((Pcoq.Symbol.nterm tac2rec_fieldexprs)))
                                 (fun l _ f loc -> 
# 379 "plugins/ltac2/g_ltac2.mlg"
                                                                f :: l 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fieldexpr) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:27")
        tac2rec_fieldexpr
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                                  ((Pcoq.Symbol.opt (Pcoq.Symbol.rules 
                                                  [Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.stop)
                                                                   ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                   ((Pcoq.Symbol.nterml ltac2_expr ("1"))))
                                                                   (fun e _
                                                                   loc -> 
                                                                   
# 385 "plugins/ltac2/g_ltac2.mlg"
                                                                         e 
                                                                   )]))))
                                  (fun e qid loc -> 
# 386 "plugins/ltac2/g_ltac2.mlg"
          let e = match e with
          | Some e -> e
          | None ->
            (* punning: [Foo.bar] becomes [Foo.bar := bar] *)
            let id = Libnames.qualid_basename qid in
            CAst.make ~loc @@ CTacRef (RelId (Libnames.qualid_of_ident ~loc id))
          in
          RelId qid, e 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fieldpats) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:28")
        tac2rec_fieldpats
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 400 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm tac2rec_fieldpat)))
                                 (fun f loc -> 
# 399 "plugins/ltac2/g_ltac2.mlg"
                                 [f] 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_fieldpat)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                 (fun _ f loc -> 
# 398 "plugins/ltac2/g_ltac2.mlg"
                                       [f] 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_fieldpat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                 ((Pcoq.Symbol.nterm tac2rec_fieldpats)))
                                 (fun l _ f loc -> 
# 397 "plugins/ltac2/g_ltac2.mlg"
                                                              f :: l 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fieldpat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:29")
        tac2rec_fieldpat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                                  ((Pcoq.Symbol.opt (Pcoq.Symbol.rules 
                                                  [Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.stop)
                                                                   ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                   ((Pcoq.Symbol.nterml tac2pat ("1"))))
                                                                   (fun e _
                                                                   loc -> 
                                                                   
# 403 "plugins/ltac2/g_ltac2.mlg"
                                                                      e 
                                                                   )]))))
                                  (fun e qid loc -> 
# 404 "plugins/ltac2/g_ltac2.mlg"
          let e = match e with
          | Some e -> e
          | None ->
            (* punning: [Foo.bar] becomes [Foo.bar := bar] *)
            let id = Libnames.qualid_basename qid in
            CAst.make ~loc @@ CPatVar (Name id)
          in
          RelId qid, e 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2typ_prm) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:30")
        tac2typ_prm
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.rules 
                                                                  [Pcoq.Rules.make 
                                                                  (Pcoq.Rule.next_norec 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm ltac2_typevar)))
                                                                  (fun id
                                                                  loc -> 
                                                                  
# 417 "plugins/ltac2/g_ltac2.mlg"
                                                   CAst.make ~loc id 
                                                                  )])) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ ids _ loc -> 
# 417 "plugins/ltac2/g_ltac2.mlg"
                                                                                           ids 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ltac2_typevar)))
                                 (fun id loc -> 
# 416 "plugins/ltac2/g_ltac2.mlg"
                                [CAst.make ~loc id] 
                                                );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 415 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2typ_def) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:31")
        tac2typ_def
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm tac2typ_prm)))
                                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                                  ((Pcoq.Symbol.nterm tac2type_body)))
                                  (fun b id prm loc -> 
# 421 "plugins/ltac2/g_ltac2.mlg"
                                                                    let (r, e) = b in (id, r, (prm, e)) 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2type_body) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:32")
        tac2type_body
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("::=")))))
                                                  ((Pcoq.Symbol.nterm tac2typ_knd)))
                                  (fun e _ loc -> 
# 426 "plugins/ltac2/g_ltac2.mlg"
                                    true, e 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                 ((Pcoq.Symbol.nterm tac2typ_knd)))
                                 (fun e _ loc -> 
# 425 "plugins/ltac2/g_ltac2.mlg"
                                   false, e 
                                                 );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 424 "plugins/ltac2/g_ltac2.mlg"
             false, CTydDef None 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_typ) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:33")
        tac2def_typ
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("Type")))))
                                                                  ((Pcoq.Symbol.nterm rec_flag)))
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm tac2typ_def)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                                  (fun l isrec _ loc -> 
# 431 "plugins/ltac2/g_ltac2.mlg"
          StrTyp (isrec, l) 
                                                        )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_ext) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:34")
        tac2def_ext
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("@")))))
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("external"))))))
                                                                  ((Pcoq.Symbol.nterm identref)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                  ((Pcoq.Symbol.nterml ltac2_type ("5"))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                  ((Pcoq.Symbol.nterm Prim.string)))
                                                  ((Pcoq.Symbol.nterm Prim.string)))
                                  (fun name plugin _ t _ id _ _ loc -> 
# 437 "plugins/ltac2/g_ltac2.mlg"
        let ml = { mltac_plugin = plugin; mltac_tactic = name } in
        StrPrm (id, t, ml) 
                                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty syn_node) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:35")
        syn_node
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id loc -> 
# 443 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc (Some id) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                 (fun _ loc -> 
# 442 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc None 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_scope) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:36")
        ltac2_scope
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm syn_node)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm ltac2_scope)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ tok _ id loc -> 
# 451 "plugins/ltac2/g_ltac2.mlg"
          SexprRec (loc, id, tok) 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm syn_node)))
                                 (fun id loc -> 
# 449 "plugins/ltac2/g_ltac2.mlg"
                           SexprRec (loc, id, []) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.integer)))
                                 (fun n loc -> 
# 448 "plugins/ltac2/g_ltac2.mlg"
                              SexprInt (CAst.make ~loc n) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.string)))
                                 (fun s loc -> 
# 447 "plugins/ltac2/g_ltac2.mlg"
                             SexprStr (CAst.make ~loc s) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty syn_level) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:37")
        syn_level
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                  ((Pcoq.Symbol.nterm Prim.natural)))
                                  (fun n _ loc -> 
# 456 "plugins/ltac2/g_ltac2.mlg"
                                   Some n 
                                                  );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 455 "plugins/ltac2/g_ltac2.mlg"
             None 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_syn) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:38")
        tac2def_syn
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ltac2_scope)))))
                                                                  ((Pcoq.Symbol.nterm syn_level)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun e _ n toks loc -> 
# 462 "plugins/ltac2/g_ltac2.mlg"
          (toks, n, e) 
                                                         )])]))
        in let () = assert (Pcoq.Entry.is_empty globref) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:39")
        globref
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                  (fun qid loc -> 
# 467 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ QReference qid 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun id _ loc -> 
# 466 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc (QHypothesis id) 
                                                  )])]))
        in ()


# 474 "plugins/ltac2/g_ltac2.mlg"
 

open Tac2entries.Pltac



let _ = let anti = Pcoq.Entry.make "anti"
        and ident_or_anti = Pcoq.Entry.make "ident_or_anti"
        and lnatural = Pcoq.Entry.make "lnatural"
        and qhyp = Pcoq.Entry.make "qhyp"
        and simple_binding = Pcoq.Entry.make "simple_binding"
        and bindings = Pcoq.Entry.make "bindings"
        and intropatterns = Pcoq.Entry.make "intropatterns"
        and or_and_intropattern = Pcoq.Entry.make "or_and_intropattern"
        and equality_intropattern = Pcoq.Entry.make "equality_intropattern"
        and naming_intropattern = Pcoq.Entry.make "naming_intropattern"
        and nonsimple_intropattern = Pcoq.Entry.make "nonsimple_intropattern"
        and simple_intropattern = Pcoq.Entry.make "simple_intropattern"
        and simple_intropattern_closed =
          Pcoq.Entry.make "simple_intropattern_closed"
        and nat_or_anti = Pcoq.Entry.make "nat_or_anti"
        and eqn_ipat = Pcoq.Entry.make "eqn_ipat"
        and with_bindings = Pcoq.Entry.make "with_bindings"
        and constr_with_bindings = Pcoq.Entry.make "constr_with_bindings"
        and destruction_arg = Pcoq.Entry.make "destruction_arg"
        and as_or_and_ipat = Pcoq.Entry.make "as_or_and_ipat"
        and occs_nums = Pcoq.Entry.make "occs_nums"
        and occs = Pcoq.Entry.make "occs"
        and hypident = Pcoq.Entry.make "hypident"
        and hypident_occ = Pcoq.Entry.make "hypident_occ"
        and in_clause = Pcoq.Entry.make "in_clause"
        and clause = Pcoq.Entry.make "clause"
        and concl_occ = Pcoq.Entry.make "concl_occ"
        and induction_clause = Pcoq.Entry.make "induction_clause"
        and conversion = Pcoq.Entry.make "conversion"
        and rewriter = Pcoq.Entry.make "rewriter"
        and oriented_rewriter = Pcoq.Entry.make "oriented_rewriter"
        and tactic_then_last = Pcoq.Entry.make "tactic_then_last"
        and for_each_goal = Pcoq.Entry.make "for_each_goal"
        and ltac2_red_flag = Pcoq.Entry.make "ltac2_red_flag"
        and refglobal = Pcoq.Entry.make "refglobal"
        and refglobals = Pcoq.Entry.make "refglobals"
        and delta_flag = Pcoq.Entry.make "delta_flag"
        and strategy_flag = Pcoq.Entry.make "strategy_flag"
        and hintdb = Pcoq.Entry.make "hintdb"
        and match_pattern = Pcoq.Entry.make "match_pattern"
        and match_rule = Pcoq.Entry.make "match_rule"
        and match_list = Pcoq.Entry.make "match_list"
        and gmatch_hyp_pattern = Pcoq.Entry.make "gmatch_hyp_pattern"
        and gmatch_pattern = Pcoq.Entry.make "gmatch_pattern"
        and gmatch_rule = Pcoq.Entry.make "gmatch_rule"
        and goal_match_list = Pcoq.Entry.make "goal_match_list"
        and move_location = Pcoq.Entry.make "move_location"
        and as_name = Pcoq.Entry.make "as_name"
        and pose = Pcoq.Entry.make "pose"
        and as_ipat = Pcoq.Entry.make "as_ipat"
        and by_tactic = Pcoq.Entry.make "by_tactic"
        and assertion = Pcoq.Entry.make "assertion"
        in
        let () = assert (Pcoq.Entry.is_empty anti) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:40")
        anti
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("$")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 486 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty ident_or_anti) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:41")
        ident_or_anti
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("$")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 490 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm identref)))
                                 (fun id loc -> 
# 489 "plugins/ltac2/g_ltac2.mlg"
                           QExpr id 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty lnatural) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:42")
        lnatural
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.natural)))
                                  (fun n loc -> 
# 494 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc n 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty q_ident) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:43")
        q_ident
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                  (fun id loc -> 
# 497 "plugins/ltac2/g_ltac2.mlg"
                                id 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty qhyp) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:44")
        qhyp
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm identref)))
                                  (fun id loc -> 
# 502 "plugins/ltac2/g_ltac2.mlg"
                           QExpr (CAst.make ~loc @@ QNamedHyp id) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm lnatural)))
                                 (fun n loc -> 
# 501 "plugins/ltac2/g_ltac2.mlg"
                          QExpr (CAst.make ~loc @@ QAnonHyp n) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm anti)))
                                 (fun x loc -> 
# 500 "plugins/ltac2/g_ltac2.mlg"
                      x 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty simple_binding) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:45")
        simple_binding
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.nterm qhyp)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                  ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ c _ h _ loc -> 
# 507 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (h, c) 
                                                        )])]))
        in let () = assert (Pcoq.Entry.is_empty bindings) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:46")
        bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm Constr.constr)))))
                                  (fun bl loc -> 
# 514 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QImplicitBindings bl 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_lpar_idnum_coloneq)))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm simple_binding)))))
                                 (fun bl _ loc -> 
# 512 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QExplicitBindings bl 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty q_bindings) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:47")
        q_bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm bindings)))
                                  (fun bl loc -> 
# 518 "plugins/ltac2/g_ltac2.mlg"
                           bl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_with_bindings) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:48")
        q_with_bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm with_bindings)))
                                  (fun bl loc -> 
# 521 "plugins/ltac2/g_ltac2.mlg"
                                bl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty intropatterns) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:49")
        intropatterns
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm nonsimple_intropattern))))
                                  (fun l loc -> 
# 524 "plugins/ltac2/g_ltac2.mlg"
                                              CAst.make ~loc l 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty or_and_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:50")
        or_and_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.nterm simple_intropattern)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm simple_intropattern)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("&"))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ tc _ si _ loc -> 
# 539 "plugins/ltac2/g_ltac2.mlg"
          let rec pairify = function
            | ([]|[_]|[_;_]) as l -> CAst.make ~loc l
            | t::q ->
              let q =
                CAst.make ~loc @@
                  QIntroAction (CAst.make ~loc @@
                    QIntroOrAndPattern (CAst.make ~loc @@
                      QIntroAndPattern (pairify q)))
              in
              CAst.make ~loc [t; q]
          in CAst.make ~loc @@ QIntroAndPattern (pairify (si::tc)) 
                                                          );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm simple_intropattern)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (",")))))
                                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm simple_intropattern)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ tc _ si _ loc -> 
# 535 "plugins/ltac2/g_ltac2.mlg"
               CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc (si::tc)) 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm simple_intropattern)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ si _ loc -> 
# 532 "plugins/ltac2/g_ltac2.mlg"
                                                CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc [si]) 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("()")))))
                                 (fun _ loc -> 
# 531 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc []) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm intropatterns)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ tc _ loc -> 
# 530 "plugins/ltac2/g_ltac2.mlg"
                                                        CAst.make ~loc @@ QIntroOrPattern tc 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty equality_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:51")
        equality_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm test_leftsquarebracket_equal)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("=")))))
                                                                  ((Pcoq.Symbol.nterm intropatterns)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ tc _ _ _ loc -> 
# 554 "plugins/ltac2/g_ltac2.mlg"
                                                                             CAst.make ~loc @@ QIntroInjection tc 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("<-")))))
                                 (fun _ loc -> 
# 553 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroRewrite false 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                 (fun _ loc -> 
# 552 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroRewrite true 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty naming_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:52")
        naming_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                  (fun id loc -> 
# 564 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroIdentifier id 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?")))))
                                 (fun _ loc -> 
# 562 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAnonymous 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?$")))))
                                                 ((Pcoq.Symbol.nterm identref)))
                                 (fun id _ loc -> 
# 560 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroFresh (QAnti id) 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PLEFTQMARK))))
                                                 ((Pcoq.Symbol.nterm identref)))
                                 (fun id _ loc -> 
# 558 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroFresh (QExpr id) 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty nonsimple_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:53")
        nonsimple_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("**")))))
                                  (fun _ loc -> 
# 570 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroForthcoming false 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                 (fun _ loc -> 
# 569 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroForthcoming true 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm simple_intropattern)))
                                 (fun l loc -> 
# 568 "plugins/ltac2/g_ltac2.mlg"
                                     l 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty simple_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:54")
        simple_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm simple_intropattern_closed)))
                                                  ((Pcoq.Symbol.list0 (Pcoq.Symbol.rules 
                                                  [Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.stop)
                                                                   ((Pcoq.Symbol.token (Tok.PKEYWORD ("%")))))
                                                                   ((Pcoq.Symbol.nterml Constr.term ("0"))))
                                                                   (fun c _
                                                                   loc -> 
                                                                   
# 574 "plugins/ltac2/g_ltac2.mlg"
                                                        c 
                                                                   )]))))
                                  (fun l pat loc -> 
# 575 "plugins/ltac2/g_ltac2.mlg"
          let mk c pat =
            CAst.make ~loc @@ QIntroAction
              (CAst.make ~loc @@ QIntroApplyOn (c, pat))
          in
          List.fold_right mk l pat
        
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty simple_intropattern_closed)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:55")
        simple_intropattern_closed
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm naming_intropattern)))
                                  (fun pat loc -> 
# 591 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroNaming pat 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                 (fun _ loc -> 
# 589 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction (CAst.make ~loc @@ QIntroWildcard) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm equality_intropattern)))
                                 (fun pat loc -> 
# 587 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction pat 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm or_and_intropattern)))
                                 (fun pat loc -> 
# 585 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction (CAst.make ~loc @@ QIntroOrAndPattern pat) 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_intropatterns) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:56")
        q_intropatterns
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm intropatterns)))
                                  (fun ipat loc -> 
# 595 "plugins/ltac2/g_ltac2.mlg"
                                  ipat 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty q_intropattern) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:57")
        q_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm simple_intropattern)))
                                  (fun ipat loc -> 
# 598 "plugins/ltac2/g_ltac2.mlg"
                                        ipat 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty nat_or_anti) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:58")
        nat_or_anti
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("$")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 602 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm lnatural)))
                                 (fun n loc -> 
# 601 "plugins/ltac2/g_ltac2.mlg"
                          QExpr n 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty eqn_ipat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:59")
        eqn_ipat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 607 "plugins/ltac2/g_ltac2.mlg"
             None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("eqn"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Pcoq.Symbol.nterm naming_intropattern)))
                                 (fun pat _ _ loc -> 
# 606 "plugins/ltac2/g_ltac2.mlg"
                                                         Some pat 
                                                     )])]))
        in let () = assert (Pcoq.Entry.is_empty with_bindings) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:60")
        with_bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 611 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QNoBindings 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                 ((Pcoq.Symbol.nterm bindings)))
                                 (fun bl _ loc -> 
# 611 "plugins/ltac2/g_ltac2.mlg"
                                   bl 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty constr_with_bindings)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:61")
        constr_with_bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                                  ((Pcoq.Symbol.nterm with_bindings)))
                                  (fun l c loc -> 
# 614 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc @@ (c, l) 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty destruction_arg) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:62")
        destruction_arg
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm constr_with_bindings)))
                                  (fun c loc -> 
# 619 "plugins/ltac2/g_ltac2.mlg"
                                      CAst.make ~loc @@ QElimOnConstr c 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm identref)))
                                 (fun id loc -> 
# 618 "plugins/ltac2/g_ltac2.mlg"
                           CAst.make ~loc @@ QElimOnIdent id 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm lnatural)))
                                 (fun n loc -> 
# 617 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QElimOnAnonHyp n 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty q_destruction_arg) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:63")
        q_destruction_arg
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm destruction_arg)))
                                  (fun arg loc -> 
# 623 "plugins/ltac2/g_ltac2.mlg"
                                   arg 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty as_or_and_ipat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:64")
        as_or_and_ipat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 627 "plugins/ltac2/g_ltac2.mlg"
             None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                 ((Pcoq.Symbol.nterm or_and_intropattern)))
                                 (fun ipat _ loc -> 
# 626 "plugins/ltac2/g_ltac2.mlg"
                                              Some ipat 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty occs_nums) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:65")
        occs_nums
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("-")))))
                                                                  ((Pcoq.Symbol.nterm nat_or_anti)))
                                                  ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm nat_or_anti))))
                                  (fun nl n _ loc -> 
# 633 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QAllOccurrencesBut (n::nl) 
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm nat_or_anti)))))
                                 (fun nl loc -> 
# 631 "plugins/ltac2/g_ltac2.mlg"
                                    CAst.make ~loc @@ QOnlyOccurrences nl 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty occs) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:66")
        occs
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 637 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc QAllOccurrences 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                 ((Pcoq.Symbol.nterm occs_nums)))
                                 (fun occs _ loc -> 
# 637 "plugins/ltac2/g_ltac2.mlg"
                                    occs 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty hypident) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:67")
        hypident
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("value"))))))
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("of"))))))
                                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ id _ _ _ loc -> 
# 645 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHypValueOnly 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("type"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("of"))))))
                                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ id _ _ _ loc -> 
# 643 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHypTypeOnly 
                                                        );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                 (fun id loc -> 
# 641 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHyp 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty hypident_occ) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:68")
        hypident_occ
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm hypident)))
                                                  ((Pcoq.Symbol.nterm occs)))
                                  (fun occs h loc -> 
# 649 "plugins/ltac2/g_ltac2.mlg"
                                   let (id,l) = h in ((occs,id),l) 
                                                     )])]))
        in let () = assert (Pcoq.Entry.is_empty in_clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:69")
        in_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm hypident_occ)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                  (fun hl loc -> 
# 659 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = Some hl; q_concl_occs = CAst.make ~loc QNoOccurrences } 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm hypident_occ)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                 ((Pcoq.Symbol.nterm concl_occ)))
                                 (fun occs _ hl loc -> 
# 657 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = Some hl; q_concl_occs = occs } 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                 ((Pcoq.Symbol.nterm concl_occ)))
                                 (fun occs _ _ loc -> 
# 655 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = None; q_concl_occs = occs } 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                                 ((Pcoq.Symbol.nterm occs)))
                                 (fun occs _ loc -> 
# 653 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = None; q_concl_occs = occs } 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:70")
        clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                  ((Pcoq.Symbol.nterm occs_nums)))
                                  (fun occs _ loc -> 
# 665 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ { q_onhyps = Some []; q_concl_occs = occs } 
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("in")))))
                                                 ((Pcoq.Symbol.nterm in_clause)))
                                 (fun cl _ loc -> 
# 663 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc @@ cl 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty q_clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:71")
        q_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm clause)))
                                  (fun cl loc -> 
# 669 "plugins/ltac2/g_ltac2.mlg"
                         cl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty concl_occ) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:72")
        concl_occ
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 673 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc QNoOccurrences 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                                 ((Pcoq.Symbol.nterm occs)))
                                 (fun occs _ loc -> 
# 672 "plugins/ltac2/g_ltac2.mlg"
                              occs 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty induction_clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:73")
        induction_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm destruction_arg)))
                                                                  ((Pcoq.Symbol.nterm as_or_and_ipat)))
                                                                  ((Pcoq.Symbol.nterm eqn_ipat)))
                                                  ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm clause))))
                                  (fun cl eq pat c loc -> 
# 679 "plugins/ltac2/g_ltac2.mlg"
        CAst.make ~loc @@ {
          indcl_arg = c;
          indcl_eqn = eq;
          indcl_as = pat;
          indcl_in = cl;
        } 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty q_induction_clause)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:74")
        q_induction_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm induction_clause)))
                                  (fun cl loc -> 
# 688 "plugins/ltac2/g_ltac2.mlg"
                                   cl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty conversion) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:75")
        conversion
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                  (fun c2 _ c1 loc -> 
# 694 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QConvertWith (c1, c2) 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Constr.constr)))
                                 (fun c loc -> 
# 692 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QConvert c 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty q_conversion) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:76")
        q_conversion
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm conversion)))
                                  (fun c loc -> 
# 698 "plugins/ltac2/g_ltac2.mlg"
                            c 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty q_orient) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:77")
        q_orient
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 703 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("<-")))))
                                 (fun _ loc -> 
# 702 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc (Some false) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                 (fun _ loc -> 
# 701 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc (Some true) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty rewriter) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:78")
        rewriter
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm constr_with_bindings)))
                                  (fun c loc -> 
# 718 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely (CAst.make 1), c) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm lnatural)))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c n loc -> 
# 716 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely n,c) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm lnatural)))
                                                                 ((Pcoq.Symbol.rules 
                                                                 [Pcoq.Rules.make 
                                                                 (Pcoq.Rule.next_norec 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PLEFTQMARK))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 713 "plugins/ltac2/g_ltac2.mlg"
                                                      () 
                                                                 );
                                                                 Pcoq.Rules.make 
                                                                 (Pcoq.Rule.next_norec 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?")))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 713 "plugins/ltac2/g_ltac2.mlg"
                                () 
                                                                 )])))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c _ n loc -> 
# 714 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QUpTo n,c) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm lnatural)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c _ n loc -> 
# 712 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely n,c) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.rules 
                                                                 [Pcoq.Rules.make 
                                                                 (Pcoq.Rule.next_norec 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PLEFTQMARK))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 709 "plugins/ltac2/g_ltac2.mlg"
                                         () 
                                                                 );
                                                                 Pcoq.Rules.make 
                                                                 (Pcoq.Rule.next_norec 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?")))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 709 "plugins/ltac2/g_ltac2.mlg"
                   () 
                                                                 )])))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c _ loc -> 
# 710 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QRepeatStar,c) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c _ loc -> 
# 708 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QRepeatPlus,c) 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty oriented_rewriter) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:79")
        oriented_rewriter
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm q_orient)))
                                                  ((Pcoq.Symbol.nterm rewriter)))
                                  (fun r b loc -> 
# 723 "plugins/ltac2/g_ltac2.mlg"
        let (m, c) = r in
        CAst.make ~loc @@ {
        rew_orient = b;
        rew_repeat = m;
        rew_equatn = c;
      } 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty q_rewriting) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:80")
        q_rewriting
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm oriented_rewriter)))
                                  (fun r loc -> 
# 732 "plugins/ltac2/g_ltac2.mlg"
                                   r 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty tactic_then_last) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:81")
        tactic_then_last
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 736 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.opt (Pcoq.Symbol.nterml ltac2_expr ("6")))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun lta _ loc -> 
# 735 "plugins/ltac2/g_ltac2.mlg"
                                                                 lta 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty for_each_goal) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:82")
        for_each_goal
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 745 "plugins/ltac2/g_ltac2.mlg"
             ([None], None) 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.nterm for_each_goal)))
                                 (fun tg _ loc -> 
# 744 "plugins/ltac2/g_ltac2.mlg"
                                     let (first,last) = tg in (None :: first, last) 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                 (fun ta loc -> 
# 743 "plugins/ltac2/g_ltac2.mlg"
                             ([Some ta], None) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("..")))))
                                                 ((Pcoq.Symbol.nterm tactic_then_last)))
                                 (fun l _ loc -> 
# 742 "plugins/ltac2/g_ltac2.mlg"
                                        ([], Some (None, l)) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("..")))))
                                                 ((Pcoq.Symbol.nterm tactic_then_last)))
                                 (fun l _ ta loc -> 
# 741 "plugins/ltac2/g_ltac2.mlg"
                                                         ([], Some (Some ta, l)) 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.nterm for_each_goal)))
                                 (fun tg _ ta loc -> 
# 740 "plugins/ltac2/g_ltac2.mlg"
                                                      let (first,last) = tg in (Some ta :: first, last) 
                                                     )])]))
        in let () = assert (Pcoq.Entry.is_empty q_dispatch) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:83")
        q_dispatch
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm for_each_goal)))
                                  (fun d loc -> 
# 749 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc d 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty q_occurrences) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:84")
        q_occurrences
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm occs)))
                                  (fun occs loc -> 
# 752 "plugins/ltac2/g_ltac2.mlg"
                         occs 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_red_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:85")
        ltac2_red_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                  ("head"))))))
                                  (fun _ loc -> 
# 762 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QHead 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("delta"))))))
                                                 ((Pcoq.Symbol.nterm delta_flag)))
                                 (fun d _ loc -> 
# 761 "plugins/ltac2/g_ltac2.mlg"
                                           d 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("zeta"))))))
                                 (fun _ loc -> 
# 760 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QZeta 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("cofix"))))))
                                 (fun _ loc -> 
# 759 "plugins/ltac2/g_ltac2.mlg"
                           CAst.make ~loc @@ QCofix 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("fix"))))))
                                 (fun _ loc -> 
# 758 "plugins/ltac2/g_ltac2.mlg"
                         CAst.make ~loc @@ QFix 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("match"))))))
                                 (fun _ loc -> 
# 757 "plugins/ltac2/g_ltac2.mlg"
                           CAst.make ~loc @@ QMatch 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("iota"))))))
                                 (fun _ loc -> 
# 756 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QIota 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("beta"))))))
                                 (fun _ loc -> 
# 755 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QBeta 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty refglobal) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:86")
        refglobal
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("$")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 768 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid loc -> 
# 767 "plugins/ltac2/g_ltac2.mlg"
                               QExpr (CAst.make ~loc @@ QReference qid) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun id _ loc -> 
# 766 "plugins/ltac2/g_ltac2.mlg"
                                  QExpr (CAst.make ~loc @@ QHypothesis id) 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty q_reference) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:87")
        q_reference
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm refglobal)))
                                  (fun r loc -> 
# 772 "plugins/ltac2/g_ltac2.mlg"
                           r 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty refglobals) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:88")
        refglobals
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm refglobal)))))
                                  (fun gl loc -> 
# 775 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc gl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty delta_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:89")
        delta_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 780 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc @@ QDeltaBut (CAst.make ~loc []) 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm refglobals)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ idl _ loc -> 
# 779 "plugins/ltac2/g_ltac2.mlg"
                                        CAst.make ~loc @@ QConst idl 
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("-")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm refglobals)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ idl _ _ loc -> 
# 778 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ QDeltaBut idl 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty strategy_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:90")
        strategy_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm delta_flag)))
                                  (fun d loc -> 
# 786 "plugins/ltac2/g_ltac2.mlg"
        CAst.make ~loc
          [CAst.make ~loc QBeta; CAst.make ~loc QIota; CAst.make ~loc QZeta; d] 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ltac2_red_flag)))))
                                 (fun s loc -> 
# 784 "plugins/ltac2/g_ltac2.mlg"
                                      CAst.make ~loc s 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty q_strategy_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:91")
        q_strategy_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm strategy_flag)))
                                  (fun flag loc -> 
# 791 "plugins/ltac2/g_ltac2.mlg"
                                  flag 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty hintdb) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:92")
        hintdb
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ident_or_anti)))))
                                  (fun l loc -> 
# 795 "plugins/ltac2/g_ltac2.mlg"
                                     CAst.make ~loc @@ QHintDbs l 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                 (fun _ loc -> 
# 794 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ QHintAll 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty q_hintdb) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:93")
        q_hintdb
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm hintdb)))
                                  (fun db loc -> 
# 799 "plugins/ltac2/g_ltac2.mlg"
                         db 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty match_pattern) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:94")
        match_pattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Constr.cpattern)))
                                  (fun pat loc -> 
# 804 "plugins/ltac2/g_ltac2.mlg"
                                   CAst.make ~loc @@ QConstrMatchPattern pat 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("context"))))))
                                                                 ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm Prim.ident))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm Constr.cpattern)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ pat _ id _ loc -> 
# 803 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QConstrMatchContext (id, pat) 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty match_rule) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:95")
        match_rule
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm match_pattern)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("=>")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun tac _ mp loc -> 
# 808 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ (mp, tac) 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty match_list) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:96")
        match_list
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm match_rule)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                  (fun mrl _ loc -> 
# 813 "plugins/ltac2/g_ltac2.mlg"
                                                 CAst.make ~loc @@ mrl 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm match_rule)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun mrl loc -> 
# 812 "plugins/ltac2/g_ltac2.mlg"
                                            CAst.make ~loc @@ mrl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_constr_matching) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:97")
        q_constr_matching
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm match_list)))
                                  (fun m loc -> 
# 816 "plugins/ltac2/g_ltac2.mlg"
                            m 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty gmatch_hyp_pattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:98")
        gmatch_hyp_pattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Prim.name)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm match_pattern)))
                                  (fun bod _ na loc -> 
# 823 "plugins/ltac2/g_ltac2.mlg"
          let bod, ty = match bod.CAst.v with
              | QConstrMatchPattern { CAst.v = CCast (t, Some DEFAULTcast, ty) } ->
                let t = CAst.make ?loc:t.loc @@ QConstrMatchPattern t in
                let ty = CAst.make ?loc:ty.loc @@ QConstrMatchPattern ty in
                t, ty
              | _ ->
                let ty = CAst.make @@ QConstrMatchPattern (CAst.make @@ CHole None) in
                bod, ty
          in
          (na, Some bod, ty) 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm Prim.name)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm match_pattern)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Pcoq.Symbol.nterm match_pattern)))
                                 (fun pat _ _ bod _ _ na loc -> 
# 821 "plugins/ltac2/g_ltac2.mlg"
          (na, Some bod, pat) 
                                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm Prim.name)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Pcoq.Symbol.nterm match_pattern)))
                                 (fun pat _ na loc -> 
# 819 "plugins/ltac2/g_ltac2.mlg"
                                                      (na, None, pat) 
                                                      )])]))
        in let () = assert (Pcoq.Entry.is_empty gmatch_pattern) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:99")
        gmatch_pattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm gmatch_hyp_pattern)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                                  ((Pcoq.Symbol.nterm match_pattern)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ p _ hl _ loc -> 
# 837 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ {
          q_goal_match_concl = p;
          q_goal_match_hyps = hl;
        } 
                                                         )])]))
        in let () = assert (Pcoq.Entry.is_empty gmatch_rule) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:100")
        gmatch_rule
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm gmatch_pattern)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("=>")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun tac _ mp loc -> 
# 845 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ (mp, tac) 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty goal_match_list) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:101")
        goal_match_list
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm gmatch_rule)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                  (fun mrl _ loc -> 
# 850 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc @@ mrl 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm gmatch_rule)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun mrl loc -> 
# 849 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ mrl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_goal_matching) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:102")
        q_goal_matching
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm goal_match_list)))
                                  (fun m loc -> 
# 853 "plugins/ltac2/g_ltac2.mlg"
                                 m 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty move_location) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:103")
        move_location
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("before"))))))
                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                  (fun id _ loc -> 
# 859 "plugins/ltac2/g_ltac2.mlg"
                                                CAst.make ~loc @@ QMoveBefore id 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("after"))))))
                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                 (fun id _ loc -> 
# 858 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QMoveAfter id 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("bottom"))))))
                                 (fun _ _ loc -> 
# 857 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc @@ QMoveLast 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("top"))))))
                                 (fun _ _ loc -> 
# 856 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ QMoveFirst 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_move_location) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:104")
        q_move_location
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm move_location)))
                                  (fun mv loc -> 
# 863 "plugins/ltac2/g_ltac2.mlg"
                                mv 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty as_name) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:105")
        as_name
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                  (fun id _ loc -> 
# 867 "plugins/ltac2/g_ltac2.mlg"
                                      Some id 
                                                   );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 866 "plugins/ltac2/g_ltac2.mlg"
             None 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty pose) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:106")
        pose
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                                  ((Pcoq.Symbol.nterm as_name)))
                                  (fun na c loc -> 
# 873 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc (na, c) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_lpar_id_coloneq)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ id _ _ loc -> 
# 872 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (Some id, c) 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty q_pose) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:107")
        q_pose
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm pose)))
                                  (fun p loc -> 
# 877 "plugins/ltac2/g_ltac2.mlg"
                      p 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty as_ipat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:108")
        as_ipat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 881 "plugins/ltac2/g_ltac2.mlg"
             None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                 ((Pcoq.Symbol.nterm simple_intropattern)))
                                 (fun ipat _ loc -> 
# 880 "plugins/ltac2/g_ltac2.mlg"
                                              Some ipat 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty by_tactic) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:109")
        by_tactic
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 886 "plugins/ltac2/g_ltac2.mlg"
             None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("by")))))
                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                 (fun tac _ loc -> 
# 885 "plugins/ltac2/g_ltac2.mlg"
                                              Some tac 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty assertion) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:110")
        assertion
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                                                  ((Pcoq.Symbol.nterm as_ipat)))
                                                  ((Pcoq.Symbol.nterm by_tactic)))
                                  (fun tac ipat c loc -> 
# 896 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (QAssertType (ipat, c, tac)) 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_lpar_id_colon)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                                 ((Pcoq.Symbol.nterm by_tactic)))
                                 (fun tac _ c _ id _ _ loc -> 
# 893 "plugins/ltac2/g_ltac2.mlg"
        let ipat = CAst.make ~loc @@ QIntroNaming (CAst.make ~loc @@ QIntroIdentifier id) in
        CAst.make ~loc (QAssertType (Some ipat, c, tac)) 
                                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_lpar_id_coloneq)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ id _ _ loc -> 
# 891 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (QAssertValue (id, c)) 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty q_assert) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:111")
        q_assert
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm assertion)))
                                  (fun a loc -> 
# 900 "plugins/ltac2/g_ltac2.mlg"
                           a 
                                                )])]))
        in ()


# 924 "plugins/ltac2/g_ltac2.mlg"
 

let () =

let open Tok in
let (++) r s = Pcoq.Rule.next r s in
let rules = [
  Pcoq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_dollar_ident ++ Symbol.token (PKEYWORD "$") ++ Symbol.nterm Prim.ident)
    begin fun id _ _ loc ->
      let id = CAst.make ~loc id in
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_var_quotation) (None, id) in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Pcoq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_dollar_ident_colon_ident ++
       Symbol.token (PKEYWORD "$") ++ Symbol.nterm Prim.identref ++
       Symbol.token (PKEYWORD ":") ++ Symbol.nterm Prim.identref)
    begin fun id _ kind _ _ loc ->
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_var_quotation) (Some kind, id) in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Pcoq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_ampersand_ident ++ Symbol.token (PKEYWORD "&") ++ Symbol.nterm Prim.ident)
    begin fun id _ _ loc ->
      let tac = Tac2quote.of_exact_hyp ~loc (CAst.make ~loc id) in
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_constr) tac in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Pcoq.(
    Production.make
      (Rule.stop ++ Symbol.token (PIDENT (Some "ltac2")) ++ Symbol.token (PKEYWORD ":") ++
       Symbol.token (PKEYWORD "(") ++ Symbol.nterm ltac2_expr ++ Symbol.token (PKEYWORD ")"))
    begin fun _ tac _ _ _ loc ->
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_constr) tac in
      CAst.make ~loc (CGenarg arg)
    end
  )
] in

  Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:adhoc1")
    Pcoq.Constr.term (Pcoq.Reuse (Some"0", rules))





# 979 "plugins/ltac2/g_ltac2.mlg"
 

let pr_ltac2entry _ = mt () (* FIXME *)
let pr_ltac2expr _ = mt () (* FIXME *)



let (wit_ltac2_entry, ltac2_entry) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac2" ~name:"ltac2_entry" 
                                     {
                                     Vernacextend.arg_parsing = Vernacextend.Arg_rules (
                                                                [(Pcoq.Production.make
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm tac2def_mut)))
                                                                  (fun e
                                                                  loc -> 
                                                                  
# 991 "plugins/ltac2/g_ltac2.mlg"
                          e 
                                                                  ));
                                                                (Pcoq.Production.make
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2def_ext)))
                                                                 (fun e
                                                                 loc -> 
                                                                 
# 990 "plugins/ltac2/g_ltac2.mlg"
                          e 
                                                                 ));
                                                                (Pcoq.Production.make
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2def_typ)))
                                                                 (fun t
                                                                 loc -> 
                                                                 
# 989 "plugins/ltac2/g_ltac2.mlg"
                          t 
                                                                 ));
                                                                (Pcoq.Production.make
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2def_val)))
                                                                 (fun v
                                                                 loc -> 
                                                                 
# 988 "plugins/ltac2/g_ltac2.mlg"
                          v 
                                                                 ))]);
                                     Vernacextend.arg_printer = fun env sigma -> 
                                     
# 987 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2entry 
                                     ;
                                     }
let _ = (wit_ltac2_entry, ltac2_entry)

let (wit_ltac2def_syn, ltac2def_syn) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac2" ~name:"ltac2def_syn" 
                                       {
                                       Vernacextend.arg_parsing = Vernacextend.Arg_alias (tac2def_syn);
                                       Vernacextend.arg_printer = fun env sigma -> 
                                       
# 995 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2entry 
                                       ;
                                       }
let _ = (wit_ltac2def_syn, ltac2def_syn)

let (wit_ltac2_expr, ltac2_expr) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac2" ~name:"ltac2_expr" 
                                   {
                                   Vernacextend.arg_parsing = Vernacextend.Arg_alias (_ltac2_expr);
                                   Vernacextend.arg_printer = fun env sigma -> 
                                   
# 1000 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2expr 
                                   ;
                                   }
let _ = (wit_ltac2_expr, ltac2_expr)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac2") ~command:"VernacDeclareTactic2Definition"  ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_entry), 
                                     Vernacextend.TyNil)), (let coqpp_body e
                                                           raw_attributes = 
                                                           Vernactypes.vtdefault (fun () -> 
                                                           
# 1005 "plugins/ltac2/g_ltac2.mlg"
                                                                                             
  Tac2entries.register_struct raw_attributes e
  
                                                           ) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.parse 
                                                           
# 1005 "plugins/ltac2/g_ltac2.mlg"
      raw_attributes
                                                            atts)), Some 
         (fun e -> 
# 1005 "plugins/ltac2/g_ltac2.mlg"
                                                      Vernacextend.classify_as_sideeff 
         )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Notation", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2def_syn), 
                                    Vernacextend.TyNil))), (let coqpp_body e
                                                           raw_attributes = 
                                                           (let synterpv = 
                                                           
# 1008 "plugins/ltac2/g_ltac2.mlg"
                                                                                                                             
    let (toks, n, body) = e in
    Tac2entries.register_notation raw_attributes toks n body
  
                                                            in Vernactypes.vtdefault (fun () -> 
                                                           
# 1012 "plugins/ltac2/g_ltac2.mlg"
   
    Tac2entries.register_notation_interpretation synterpv
  
                                                           )) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.parse 
                                                           
# 1008 "plugins/ltac2/g_ltac2.mlg"
      raw_attributes
                                                            atts)), Some 
         (fun e -> 
# 1008 "plugins/ltac2/g_ltac2.mlg"
                                                                  Vernacextend.(VtSideff ([], VtNow)) 
         )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Eval", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                    Vernacextend.TyNil))), (let coqpp_body e
                                                           () = Vernactypes.vtreadproofopt (fun ~pstate -> (
                                                                
# 1015 "plugins/ltac2/g_ltac2.mlg"
                                                                                                
  fun ~pstate -> Tac2entries.perform_eval ~pstate e
  
                                                                ) ~pstate) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.unsupported_attributes atts)), Some 
         (fun e -> 
# 1015 "plugins/ltac2/g_ltac2.mlg"
                                                           Vernacextend.classify_as_query 
         )))]


# 1020 "plugins/ltac2/g_ltac2.mlg"
 

let _ = Pvernac.register_proof_mode "Ltac2" tac2mode

open Vernacextend

let toplevel_selector = G_vernac.toplevel_selector

let pr_ltac2_selector s = Pp.(Goal_select.pr_goal_selector s ++ str ":")

let pr_ltac2_use_default b =
  if b then (* Bug: a space is inserted before "..." *) str ".." else mt ()

let subprf = G_vernac.subprf
let subprf_with_selector = G_vernac.subprf_with_selector



let (wit_ltac2_selector, ltac2_selector) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac2" ~name:"ltac2_selector" 
                                           {
                                           Vernacextend.arg_parsing = 
                                           Vernacextend.Arg_alias (toplevel_selector);
                                           Vernacextend.arg_printer = fun env sigma -> 
                                           
# 1038 "plugins/ltac2/g_ltac2.mlg"
                                                   pr_ltac2_selector 
                                           ;
                                           }
let _ = (wit_ltac2_selector, ltac2_selector)

let (wit_ltac2_use_default, ltac2_use_default) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac2" ~name:"ltac2_use_default" 
                                                 {
                                                 Vernacextend.arg_parsing = 
                                                 Vernacextend.Arg_rules (
                                                 [(Pcoq.Production.make
                                                   (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                   ((Pcoq.Symbol.token (Pcoq.terminal "..."))))
                                                   (fun _ loc -> 
# 1044 "plugins/ltac2/g_ltac2.mlg"
                 true 
                                                                 ));
                                                 (Pcoq.Production.make
                                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Pcoq.terminal "."))))
                                                  (fun _ loc -> 
# 1043 "plugins/ltac2/g_ltac2.mlg"
               false 
                                                                ))]);
                                                 Vernacextend.arg_printer = fun env sigma -> 
                                                 
# 1042 "plugins/ltac2/g_ltac2.mlg"
                                                      pr_ltac2_use_default 
                                                 ;
                                                 }
let _ = (wit_ltac2_use_default, ltac2_use_default)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac2") ~command:"VernacLtac2"  ?entry:(Some ( tac2mode )) 
         [(Vernacextend.TyML (false, Vernacextend.TyNonTerminal (Extend.TUopt (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_ltac2_selector)), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_use_default), 
                                     Vernacextend.TyNil))), (let coqpp_body g
                                                            t with_end_tac
                                                            () = Vernactypes.vtmodifyproof (fun ~pstate -> (
                                                                 
# 1049 "plugins/ltac2/g_ltac2.mlg"
                                 fun ~pstate ->
    Tac2entries.call ~pstate g ~with_end_tac t
  
                                                                 ) ~pstate) in fun g
                                                            t with_end_tac
                                                            ?loc ~atts ()
                                                            -> coqpp_body g t
                                                            with_end_tac
                                                            (Attributes.unsupported_attributes atts)), Some 
         (fun g t with_end_tac -> 
# 1049 "plugins/ltac2/g_ltac2.mlg"
    classify_as_proofstep 
         )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("par", Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_ltac2_use_default), 
                                                                    Vernacextend.TyNil)))), 
         (let coqpp_body t with_end_tac
         () = Vernactypes.vtmodifyproof (fun ~pstate -> (
# 1053 "plugins/ltac2/g_ltac2.mlg"
                                 fun ~pstate ->
    Tac2entries.call_par ~pstate ~with_end_tac t
  
              ) ~pstate) in fun t
         with_end_tac ?loc ~atts () -> coqpp_body t with_end_tac
         (Attributes.unsupported_attributes atts)), Some (fun t with_end_tac
                                                         -> 
# 1053 "plugins/ltac2/g_ltac2.mlg"
    classify_as_proofstep 
                                                         )))]

let _ = let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:112")
        tac2mode
        (Pcoq.Reuse (None, [Pcoq.Production.make
                            (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                            ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm toplevel_selector))))
                                            ((Pcoq.Symbol.nterm subprf_with_selector)))
                            (fun p g loc -> 
# 1062 "plugins/ltac2/g_ltac2.mlg"
                                                                 Vernacexpr.VernacSynPure (p g) 
                                            );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.nterm subprf)))
                           (fun p loc -> 
# 1061 "plugins/ltac2/g_ltac2.mlg"
                        Vernacexpr.VernacSynPure p 
                                         )]))
        in ()


# 1066 "plugins/ltac2/g_ltac2.mlg"
 

open Stdarg



let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac2") ~command:"Ltac2Printers" ~classifier:(fun _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Print", 
                                     Vernacextend.TyTerminal ("Ltac2", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference), 
                                     Vernacextend.TyNil))), (let coqpp_body tac
                                                            () = Vernactypes.vtdefault (fun () -> 
                                                                 
# 1073 "plugins/ltac2/g_ltac2.mlg"
                                          Tac2entries.print_ltac2 tac 
                                                                 ) in fun tac
                                                            ?loc ~atts ()
                                                            -> coqpp_body tac
                                                            (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Print", 
                                    Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Type", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference), 
                                    Vernacextend.TyNil)))), (let coqpp_body tac
                                                            () = Vernactypes.vtdefault (fun () -> 
                                                                 
# 1074 "plugins/ltac2/g_ltac2.mlg"
                                                 Tac2entries.print_ltac2_type tac 
                                                                 ) in fun tac
                                                            ?loc ~atts ()
                                                            -> coqpp_body tac
                                                            (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Locate", 
                                    Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference), 
                                    Vernacextend.TyNil))), (let coqpp_body r
                                                           () = Vernactypes.vtdefault (fun () -> 
                                                                
# 1075 "plugins/ltac2/g_ltac2.mlg"
                                         Tac2entries.print_located_tactic r 
                                                                ) in fun r
                                                           ?loc ~atts ()
                                                           -> coqpp_body r
                                                           (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Print", 
                                    Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Signatures", 
                                    Vernacextend.TyNil))), (let coqpp_body () = 
                                                           Vernactypes.vtdefault (fun () -> 
                                                           
# 1076 "plugins/ltac2/g_ltac2.mlg"
                                        Tac2entries.print_signatures () 
                                                           ) in fun ?loc ~atts ()
                                                           -> coqpp_body (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Check", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                    Vernacextend.TyNil))), (let coqpp_body e
                                                           () = Vernactypes.vtdefault (fun () -> 
                                                                
# 1077 "plugins/ltac2/g_ltac2.mlg"
                                         Tac2entries.typecheck_expr e 
                                                                ) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Globalize", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                    Vernacextend.TyNil))), (let coqpp_body e
                                                           () = Vernactypes.vtdefault (fun () -> 
                                                                
# 1078 "plugins/ltac2/g_ltac2.mlg"
                                             Tac2entries.globalize_expr e 
                                                                ) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.unsupported_attributes atts)), None))]

