/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server.system;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;

public class Classes {
    private static ClassLoadingMXBean classLoadingBean;

    public static native Class[] getAllLoadedClasses();

    public static native byte[] getCachedClassFileBytes(Class var0);

    public static int getLoadedClassCount() {
        return classLoadingBean.getLoadedClassCount();
    }

    public static native long getObjectSize(Object var0);

    public static native boolean setSleepTrackingEnabled(boolean var0);

    public static native boolean setVMObjectAllocEnabled(boolean var0);

    public static native boolean setWaitTrackingEnabled(boolean var0);

    public static native boolean setParkTrackingEnabled(boolean var0);

    public static native boolean setLockContentionMonitoringEnabled(boolean var0);

    public static native void cacheLoadedClasses(Class[] var0, int var1);

    public static native void disableClassLoadHook();

    public static native void enableClassLoadHook();

    public static void initialize() {
        classLoadingBean = ManagementFactory.getClassLoadingMXBean();
    }

    public static native void notifyAboutClassLoaderUnloading();

    public static void redefineClasses(Class[] classes, byte[][] newClassFileBytes) throws RedefineException {
        if (classes.length > newClassFileBytes.length) {
            throw new RedefineException("Inconsistent input data: classes.length = " + classes.length + ", newClassFileBytes.length = " + newClassFileBytes.length);
        }
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] == null) {
                throw new RedefineException("null input data: classes at " + i);
            }
            if (newClassFileBytes[i] != null) continue;
            throw new RedefineException("null input data: newClassFileBytes at " + i + " for class " + classes[i].getName());
        }
        int res = Classes.doRedefineClasses(classes, newClassFileBytes);
        if (res != 0) {
            throw new RedefineException("Redefinition failed with error " + res + "\nCheck JVMTI documentation for this error code.");
        }
    }

    private static native int doRedefineClasses(Class[] var0, byte[][] var1);

    private static RedefineException newRedefineException(String msg, Throwable origCause) {
        msg = "Class redefinition error: " + msg + "\nOriginal exception:\n" + origCause;
        return new RedefineException(msg);
    }

    public static class RedefineException
    extends Exception {
        public RedefineException(String msg) {
            super(msg);
        }
    }
}

