/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Positionable;
import org.graalvm.visualvm.core.ui.DataSourceViewProvider;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;

public abstract class DataSourceView
implements Positionable {
    protected static final String ALERT_PROP = "Alert";
    protected static final String ALERT_STRING_PROP = "Alert String";
    private DataSource dataSource;
    private String name;
    private Image icon;
    private int preferredPosition;
    private boolean isClosable;
    private DataViewComponent component;
    private DataSourceViewProvider controller;
    private Alert alert;
    private String alertText;
    private PropertyChangeSupport propertyChangeSupport;
    private boolean willBeRemovedNotified;

    public DataSourceView(DataSource dataSource, String name, Image icon, int preferredPosition, boolean isClosable) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (icon == null) {
            throw new IllegalArgumentException("Icon cannot be null");
        }
        this.dataSource = dataSource;
        this.name = name;
        this.icon = icon;
        this.preferredPosition = preferredPosition;
        this.isClosable = isClosable;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public final DataSource getDataSource() {
        return this.dataSource;
    }

    public final String getName() {
        return this.name;
    }

    public final Image getImage() {
        return this.icon;
    }

    protected abstract DataViewComponent createComponent();

    @Override
    public final int getPreferredPosition() {
        return this.preferredPosition;
    }

    public final boolean isClosable() {
        return this.isClosable;
    }

    protected void setAlert(Alert newAlert, String newText) {
        Alert oldAlert = this.alert;
        String oldText = newText;
        this.alert = newAlert;
        this.alertText = newText;
        this.propertyChangeSupport.firePropertyChange(ALERT_PROP, (Object)oldAlert, (Object)this.alert);
        this.propertyChangeSupport.firePropertyChange(ALERT_STRING_PROP, oldText, newText);
    }

    protected void willBeAdded() {
    }

    protected void added() {
    }

    protected void willBeRemoved() {
    }

    protected void removed() {
    }

    Alert getAlert() {
        return this.alert;
    }

    void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    DataViewComponent getView() {
        if (this.component == null) {
            this.component = this.createComponent();
            if (this.component == null) {
                throw new NullPointerException("Null view component from " + this);
            }
            this.controller.processCreatedComponent(this, this.component);
        }
        return this.component;
    }

    boolean hasComponent() {
        return this.component != null;
    }

    void viewWillBeAdded() {
        this.willBeAdded();
        this.controller.viewWillBeAdded(this);
    }

    void viewAdded() {
        this.added();
        this.controller.viewAdded(this);
    }

    void viewWillBeRemoved() {
        if (this.willBeRemovedNotified) {
            return;
        }
        this.willBeRemoved();
        this.willBeRemovedNotified = true;
        this.controller.viewWillBeRemoved(this);
    }

    void viewRemoved() {
        this.removed();
        this.controller.viewRemoved(this);
    }

    void setController(DataSourceViewProvider controller) {
        this.controller = controller;
    }

    protected static enum Alert {
        ERROR,
        WARNING,
        OK;

    }
}

