<?php
/**
 * SystemInformationEndpointsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * SystemInformationEndpointsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SystemInformationEndpointsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation getConfig
     *
     * Retrieve runtime configuration
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Config|string|string
     */
    public function getConfig($zap_trace_span = null)
    {
        list($response) = $this->getConfigWithHttpInfo($zap_trace_span);
        return $response;
    }

    /**
     * Operation getConfigWithHttpInfo
     *
     * Retrieve runtime configuration
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Config|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConfigWithHttpInfo($zap_trace_span = null)
    {
        $request = $this->getConfigRequest($zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Config';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getConfig'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getConfigRequest($zap_trace_span = null)
    {

        $resourcePath = '/api/v2/config';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofAllProfiles
     *
     * Retrieve all runtime profiles
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $cpu Collects and returns CPU profiling data for the specified [duration](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#duration). (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofAllProfiles($zap_trace_span = null, $cpu = null)
    {
        list($response) = $this->getDebugPprofAllProfilesWithHttpInfo($zap_trace_span, $cpu);
        return $response;
    }

    /**
     * Operation getDebugPprofAllProfilesWithHttpInfo
     *
     * Retrieve all runtime profiles
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $cpu Collects and returns CPU profiling data for the specified [duration](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#duration). (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofAllProfilesWithHttpInfo($zap_trace_span = null, $cpu = null)
    {
        $request = $this->getDebugPprofAllProfilesRequest($zap_trace_span, $cpu);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofAllProfiles'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $cpu Collects and returns CPU profiling data for the specified [duration](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#duration). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofAllProfilesRequest($zap_trace_span = null, $cpu = null)
    {

        $resourcePath = '/debug/pprof/all';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($cpu !== null) {
            $queryParams['cpu'] = ObjectSerializer::toQueryValue($cpu);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofAllocs
     *
     * Retrieve the memory allocations runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofAllocs($zap_trace_span = null, $debug = null, $seconds = null)
    {
        list($response) = $this->getDebugPprofAllocsWithHttpInfo($zap_trace_span, $debug, $seconds);
        return $response;
    }

    /**
     * Operation getDebugPprofAllocsWithHttpInfo
     *
     * Retrieve the memory allocations runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofAllocsWithHttpInfo($zap_trace_span = null, $debug = null, $seconds = null)
    {
        $request = $this->getDebugPprofAllocsRequest($zap_trace_span, $debug, $seconds);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofAllocs'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofAllocsRequest($zap_trace_span = null, $debug = null, $seconds = null)
    {

        $resourcePath = '/debug/pprof/allocs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($debug !== null) {
            $queryParams['debug'] = ObjectSerializer::toQueryValue($debug);
        }
        // query params
        if ($seconds !== null) {
            $queryParams['seconds'] = ObjectSerializer::toQueryValue($seconds);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'text/plain', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'text/plain', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofBlock
     *
     * Retrieve the block runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofBlock($zap_trace_span = null, $debug = null, $seconds = null)
    {
        list($response) = $this->getDebugPprofBlockWithHttpInfo($zap_trace_span, $debug, $seconds);
        return $response;
    }

    /**
     * Operation getDebugPprofBlockWithHttpInfo
     *
     * Retrieve the block runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofBlockWithHttpInfo($zap_trace_span = null, $debug = null, $seconds = null)
    {
        $request = $this->getDebugPprofBlockRequest($zap_trace_span, $debug, $seconds);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofBlock'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofBlockRequest($zap_trace_span = null, $debug = null, $seconds = null)
    {

        $resourcePath = '/debug/pprof/block';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($debug !== null) {
            $queryParams['debug'] = ObjectSerializer::toQueryValue($debug);
        }
        // query params
        if ($seconds !== null) {
            $queryParams['seconds'] = ObjectSerializer::toQueryValue($seconds);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'text/plain', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'text/plain', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofCmdline
     *
     * Retrieve the command line invocation
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string|string
     */
    public function getDebugPprofCmdline($zap_trace_span = null)
    {
        list($response) = $this->getDebugPprofCmdlineWithHttpInfo($zap_trace_span);
        return $response;
    }

    /**
     * Operation getDebugPprofCmdlineWithHttpInfo
     *
     * Retrieve the command line invocation
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofCmdlineWithHttpInfo($zap_trace_span = null)
    {
        $request = $this->getDebugPprofCmdlineRequest($zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = 'string';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofCmdline'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofCmdlineRequest($zap_trace_span = null)
    {

        $resourcePath = '/debug/pprof/cmdline';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['text/plain', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['text/plain', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofGoroutine
     *
     * Retrieve the goroutines runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as        human-readable text with comments that translate addresses to        function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofGoroutine($zap_trace_span = null, $debug = null, $seconds = null)
    {
        list($response) = $this->getDebugPprofGoroutineWithHttpInfo($zap_trace_span, $debug, $seconds);
        return $response;
    }

    /**
     * Operation getDebugPprofGoroutineWithHttpInfo
     *
     * Retrieve the goroutines runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as        human-readable text with comments that translate addresses to        function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofGoroutineWithHttpInfo($zap_trace_span = null, $debug = null, $seconds = null)
    {
        $request = $this->getDebugPprofGoroutineRequest($zap_trace_span, $debug, $seconds);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofGoroutine'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as        human-readable text with comments that translate addresses to        function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofGoroutineRequest($zap_trace_span = null, $debug = null, $seconds = null)
    {

        $resourcePath = '/debug/pprof/goroutine';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($debug !== null) {
            $queryParams['debug'] = ObjectSerializer::toQueryValue($debug);
        }
        // query params
        if ($seconds !== null) {
            $queryParams['seconds'] = ObjectSerializer::toQueryValue($seconds);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'text/plain', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'text/plain', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofHeap
     *
     * Retrieve the heap runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     * @param  int $gc - &#x60;0&#x60;: (Default) don&#39;t force garbage collection before sampling. - &#x60;1&#x60;: Force garbage collection before sampling. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofHeap($zap_trace_span = null, $debug = null, $seconds = null, $gc = null)
    {
        list($response) = $this->getDebugPprofHeapWithHttpInfo($zap_trace_span, $debug, $seconds, $gc);
        return $response;
    }

    /**
     * Operation getDebugPprofHeapWithHttpInfo
     *
     * Retrieve the heap runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     * @param  int $gc - &#x60;0&#x60;: (Default) don&#39;t force garbage collection before sampling. - &#x60;1&#x60;: Force garbage collection before sampling. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofHeapWithHttpInfo($zap_trace_span = null, $debug = null, $seconds = null, $gc = null)
    {
        $request = $this->getDebugPprofHeapRequest($zap_trace_span, $debug, $seconds, $gc);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofHeap'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     * @param  int $gc - &#x60;0&#x60;: (Default) don&#39;t force garbage collection before sampling. - &#x60;1&#x60;: Force garbage collection before sampling. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofHeapRequest($zap_trace_span = null, $debug = null, $seconds = null, $gc = null)
    {

        $resourcePath = '/debug/pprof/heap';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($debug !== null) {
            $queryParams['debug'] = ObjectSerializer::toQueryValue($debug);
        }
        // query params
        if ($seconds !== null) {
            $queryParams['seconds'] = ObjectSerializer::toQueryValue($seconds);
        }
        // query params
        if ($gc !== null) {
            $queryParams['gc'] = ObjectSerializer::toQueryValue($gc);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'text/plain', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'text/plain', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofMutex
     *
     * Retrieve the mutual exclusion (mutex) runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofMutex($zap_trace_span = null, $debug = null, $seconds = null)
    {
        list($response) = $this->getDebugPprofMutexWithHttpInfo($zap_trace_span, $debug, $seconds);
        return $response;
    }

    /**
     * Operation getDebugPprofMutexWithHttpInfo
     *
     * Retrieve the mutual exclusion (mutex) runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofMutexWithHttpInfo($zap_trace_span = null, $debug = null, $seconds = null)
    {
        $request = $this->getDebugPprofMutexRequest($zap_trace_span, $debug, $seconds);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofMutex'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofMutexRequest($zap_trace_span = null, $debug = null, $seconds = null)
    {

        $resourcePath = '/debug/pprof/mutex';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($debug !== null) {
            $queryParams['debug'] = ObjectSerializer::toQueryValue($debug);
        }
        // query params
        if ($seconds !== null) {
            $queryParams['seconds'] = ObjectSerializer::toQueryValue($seconds);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'text/plain', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'text/plain', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofProfile
     *
     * Retrieve the CPU runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $seconds Number of seconds to collect profile data. Default is &#x60;30&#x60; seconds. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofProfile($zap_trace_span = null, $seconds = null)
    {
        list($response) = $this->getDebugPprofProfileWithHttpInfo($zap_trace_span, $seconds);
        return $response;
    }

    /**
     * Operation getDebugPprofProfileWithHttpInfo
     *
     * Retrieve the CPU runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $seconds Number of seconds to collect profile data. Default is &#x60;30&#x60; seconds. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofProfileWithHttpInfo($zap_trace_span = null, $seconds = null)
    {
        $request = $this->getDebugPprofProfileRequest($zap_trace_span, $seconds);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofProfile'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $seconds Number of seconds to collect profile data. Default is &#x60;30&#x60; seconds. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofProfileRequest($zap_trace_span = null, $seconds = null)
    {

        $resourcePath = '/debug/pprof/profile';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($seconds !== null) {
            $queryParams['seconds'] = ObjectSerializer::toQueryValue($seconds);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofThreadCreate
     *
     * Retrieve the threadcreate runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofThreadCreate($zap_trace_span = null, $debug = null, $seconds = null)
    {
        list($response) = $this->getDebugPprofThreadCreateWithHttpInfo($zap_trace_span, $debug, $seconds);
        return $response;
    }

    /**
     * Operation getDebugPprofThreadCreateWithHttpInfo
     *
     * Retrieve the threadcreate runtime profile
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofThreadCreateWithHttpInfo($zap_trace_span = null, $debug = null, $seconds = null)
    {
        $request = $this->getDebugPprofThreadCreateRequest($zap_trace_span, $debug, $seconds);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofThreadCreate'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $debug - &#x60;0&#x60;: (Default) Return the report as a gzip-compressed protocol buffer. - &#x60;1&#x60;: Return a response body with the report formatted as human-readable text.   The report contains comments that translate addresses to function names and line numbers for debugging.  &#x60;debug&#x3D;1&#x60; is mutually exclusive with the &#x60;seconds&#x60; query parameter. (optional)
     * @param  string $seconds Number of seconds to collect statistics.  &#x60;seconds&#x60; is mutually exclusive with &#x60;debug&#x3D;1&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofThreadCreateRequest($zap_trace_span = null, $debug = null, $seconds = null)
    {

        $resourcePath = '/debug/pprof/threadcreate';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($debug !== null) {
            $queryParams['debug'] = ObjectSerializer::toQueryValue($debug);
        }
        // query params
        if ($seconds !== null) {
            $queryParams['seconds'] = ObjectSerializer::toQueryValue($seconds);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'text/plain', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'text/plain', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDebugPprofTrace
     *
     * Retrieve the runtime execution trace
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $seconds Number of seconds to collect profile data. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|string
     */
    public function getDebugPprofTrace($zap_trace_span = null, $seconds = null)
    {
        list($response) = $this->getDebugPprofTraceWithHttpInfo($zap_trace_span, $seconds);
        return $response;
    }

    /**
     * Operation getDebugPprofTraceWithHttpInfo
     *
     * Retrieve the runtime execution trace
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $seconds Number of seconds to collect profile data. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDebugPprofTraceWithHttpInfo($zap_trace_span = null, $seconds = null)
    {
        $request = $this->getDebugPprofTraceRequest($zap_trace_span, $seconds);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDebugPprofTrace'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $seconds Number of seconds to collect profile data. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDebugPprofTraceRequest($zap_trace_span = null, $seconds = null)
    {

        $resourcePath = '/debug/pprof/trace';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($seconds !== null) {
            $queryParams['seconds'] = ObjectSerializer::toQueryValue($seconds);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getHealth
     *
     * Retrieve the health of the instance
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\HealthCheck|\InfluxDB2\Model\HealthCheck|string
     */
    public function getHealth($zap_trace_span = null)
    {
        list($response) = $this->getHealthWithHttpInfo($zap_trace_span);
        return $response;
    }

    /**
     * Operation getHealthWithHttpInfo
     *
     * Retrieve the health of the instance
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\HealthCheck|\InfluxDB2\Model\HealthCheck|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getHealthWithHttpInfo($zap_trace_span = null)
    {
        $request = $this->getHealthRequest($zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\HealthCheck';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getHealth'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getHealthRequest($zap_trace_span = null)
    {

        $resourcePath = '/health';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getMetrics
     *
     * Retrieve workload performance metrics
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string|string
     */
    public function getMetrics($zap_trace_span = null)
    {
        list($response) = $this->getMetricsWithHttpInfo($zap_trace_span);
        return $response;
    }

    /**
     * Operation getMetricsWithHttpInfo
     *
     * Retrieve workload performance metrics
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getMetricsWithHttpInfo($zap_trace_span = null)
    {
        $request = $this->getMetricsRequest($zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = 'string';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getMetrics'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getMetricsRequest($zap_trace_span = null)
    {

        $resourcePath = '/metrics';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['text/plain', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['text/plain', 'application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getPing
     *
     * Get the status and version of the instance
     *
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function getPing()
    {
        $this->getPingWithHttpInfo();
    }

    /**
     * Operation getPingWithHttpInfo
     *
     * Get the status and version of the instance
     *
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPingWithHttpInfo()
    {
        $request = $this->getPingRequest();

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'getPing'
     *
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getPingRequest()
    {

        $resourcePath = '/ping';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getReady
     *
     * Get the readiness of an instance at startup
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Ready|string
     */
    public function getReady($zap_trace_span = null)
    {
        list($response) = $this->getReadyWithHttpInfo($zap_trace_span);
        return $response;
    }

    /**
     * Operation getReadyWithHttpInfo
     *
     * Get the readiness of an instance at startup
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Ready|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReadyWithHttpInfo($zap_trace_span = null)
    {
        $request = $this->getReadyRequest($zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Ready';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getReady'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getReadyRequest($zap_trace_span = null)
    {

        $resourcePath = '/ready';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getResources
     *
     * List all known resources
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string[]|\InfluxDB2\Model\Error
     */
    public function getResources($zap_trace_span = null)
    {
        list($response) = $this->getResourcesWithHttpInfo($zap_trace_span);
        return $response;
    }

    /**
     * Operation getResourcesWithHttpInfo
     *
     * List all known resources
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string[]|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getResourcesWithHttpInfo($zap_trace_span = null)
    {
        $request = $this->getResourcesRequest($zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = 'string[]';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getResources'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getResourcesRequest($zap_trace_span = null)
    {

        $resourcePath = '/api/v2/resources';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getRoutes
     *
     * List all top level routes
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Routes
     */
    public function getRoutes($zap_trace_span = null)
    {
        list($response) = $this->getRoutesWithHttpInfo($zap_trace_span);
        return $response;
    }

    /**
     * Operation getRoutesWithHttpInfo
     *
     * List all top level routes
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Routes, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRoutesWithHttpInfo($zap_trace_span = null)
    {
        $request = $this->getRoutesRequest($zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Routes';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getRoutes'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getRoutesRequest($zap_trace_span = null)
    {

        $resourcePath = '/api/v2/';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
