/**
 * This file is part of the "libunicode" project
 *   Copyright (c) 2020-2021 Christian Parpart <christian@parpart.family>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once

#include <cstdint>

namespace unicode
{

enum class Plane: uint8_t
{
    Basic_Multilingual_Plane = 0,
    Supplementary_Ideographic_Plane = 1,
    Supplementary_Multilingual_Plane = 2,
    Supplementary_Private_Use_Area_Plane = 3,
    Supplementary_Special_purpose_Plane = 4,
    Tertiary_Ideographic_Plane = 5,
    Unassigned = 6,
};

enum class Age: uint8_t
{
    Unassigned = 0,
    V10_0 = 1,
    V11_0 = 2,
    V12_0 = 3,
    V12_1 = 4,
    V13_0 = 5,
    V14_0 = 6,
    V15_0 = 7,
    V15_1 = 8,
    V16_0 = 9,
    V17_0 = 10,
    V1_1 = 11,
    V2_0 = 12,
    V2_1 = 13,
    V3_0 = 14,
    V3_1 = 15,
    V3_2 = 16,
    V4_0 = 17,
    V4_1 = 18,
    V5_0 = 19,
    V5_1 = 20,
    V5_2 = 21,
    V6_0 = 22,
    V6_1 = 23,
    V6_2 = 24,
    V6_3 = 25,
    V7_0 = 26,
    V8_0 = 27,
    V9_0 = 28,
};

enum class Bidi_Class: uint8_t
{
    Arabic_Letter = 0,
    Arabic_Number = 1,
    Boundary_Neutral = 2,
    Common_Separator = 3,
    European_Number = 4,
    European_Separator = 5,
    European_Terminator = 6,
    First_Strong_Isolate = 7,
    Left_To_Right = 8,
    Left_To_Right_Embedding = 9,
    Left_To_Right_Isolate = 10,
    Left_To_Right_Override = 11,
    Nonspacing_Mark = 12,
    Other_Neutral = 13,
    Paragraph_Separator = 14,
    Pop_Directional_Format = 15,
    Pop_Directional_Isolate = 16,
    Right_To_Left = 17,
    Right_To_Left_Embedding = 18,
    Right_To_Left_Isolate = 19,
    Right_To_Left_Override = 20,
    Segment_Separator = 21,
    White_Space = 22,
};

enum class Bidi_Paired_Bracket_Type: uint8_t
{
    Close = 0,
    None = 1,
    Open = 2,
};

enum class Canonical_Combining_Class: uint8_t
{
    A = 0,
    AL = 1,
    AR = 2,
    ATA = 3,
    ATAR = 4,
    ATB = 5,
    ATBL = 6,
    B = 7,
    BL = 8,
    BR = 9,
    CCC10 = 10,
    CCC103 = 11,
    CCC107 = 12,
    CCC11 = 13,
    CCC118 = 14,
    CCC12 = 15,
    CCC122 = 16,
    CCC129 = 17,
    CCC13 = 18,
    CCC130 = 19,
    CCC132 = 20,
    CCC133 = 21,
    CCC14 = 22,
    CCC15 = 23,
    CCC16 = 24,
    CCC17 = 25,
    CCC18 = 26,
    CCC19 = 27,
    CCC20 = 28,
    CCC21 = 29,
    CCC22 = 30,
    CCC23 = 31,
    CCC24 = 32,
    CCC25 = 33,
    CCC26 = 34,
    CCC27 = 35,
    CCC28 = 36,
    CCC29 = 37,
    CCC30 = 38,
    CCC31 = 39,
    CCC32 = 40,
    CCC33 = 41,
    CCC34 = 42,
    CCC35 = 43,
    CCC36 = 44,
    CCC84 = 45,
    CCC91 = 46,
    DA = 47,
    DB = 48,
    HANR = 49,
    IS = 50,
    KV = 51,
    L = 52,
    NK = 53,
    NR = 54,
    OV = 55,
    R = 56,
    VR = 57,
};

enum class Decomposition_Type: uint8_t
{
    Canonical = 0,
    Circle = 1,
    Compat = 2,
    Final = 3,
    Font = 4,
    Fraction = 5,
    Initial = 6,
    Isolated = 7,
    Medial = 8,
    Narrow = 9,
    Nobreak = 10,
    None = 11,
    Small = 12,
    Square = 13,
    Sub = 14,
    Super = 15,
    Vertical = 16,
    Wide = 17,
};

enum class East_Asian_Width: uint8_t
{
    Ambiguous = 0,
    Fullwidth = 1,
    Halfwidth = 2,
    Narrow = 3,
    Neutral = 4,
    Wide = 5,
};

enum class Grapheme_Cluster_Break: uint8_t
{
    Undefined = 0,
    CR = 1,
    Control = 2,
    E_Base = 3,
    E_Base_GAZ = 4,
    E_Modifier = 5,
    Extend = 6,
    Glue_After_Zwj = 7,
    L = 8,
    LF = 9,
    LV = 10,
    LVT = 11,
    Other = 12,
    Prepend = 13,
    Regional_Indicator = 14,
    SpacingMark = 15,
    T = 16,
    V = 17,
    ZWJ = 18,
};

enum class Hangul_Syllable_Type: uint8_t
{
    LVT_Syllable = 0,
    LV_Syllable = 1,
    Leading_Jamo = 2,
    Not_Applicable = 3,
    Trailing_Jamo = 4,
    Vowel_Jamo = 5,
};

enum class Indic_Conjunct_Break: uint8_t
{
    Consonant = 0,
    Extend = 1,
    Linker = 2,
    None = 3,
};

enum class Indic_Positional_Category: uint8_t
{
    Bottom = 0,
    Bottom_And_Left = 1,
    Bottom_And_Right = 2,
    Left = 3,
    Left_And_Right = 4,
    Not_Applicable = 5,
    Overstruck = 6,
    Right = 7,
    Top = 8,
    Top_And_Bottom = 9,
    Top_And_Bottom_And_Left = 10,
    Top_And_Bottom_And_Right = 11,
    Top_And_Left = 12,
    Top_And_Left_And_Right = 13,
    Top_And_Right = 14,
    Visual_Order_Left = 15,
};

enum class Indic_Syllabic_Category: uint8_t
{
    Avagraha = 0,
    Bindu = 1,
    Brahmi_Joining_Number = 2,
    Cantillation_Mark = 3,
    Consonant = 4,
    Consonant_Dead = 5,
    Consonant_Final = 6,
    Consonant_Head_Letter = 7,
    Consonant_Initial_Postfixed = 8,
    Consonant_Killer = 9,
    Consonant_Medial = 10,
    Consonant_Placeholder = 11,
    Consonant_Preceding_Repha = 12,
    Consonant_Prefixed = 13,
    Consonant_Subjoined = 14,
    Consonant_Succeeding_Repha = 15,
    Consonant_With_Stacker = 16,
    Gemination_Mark = 17,
    Invisible_Stacker = 18,
    Joiner = 19,
    Modifying_Letter = 20,
    Non_Joiner = 21,
    Nukta = 22,
    Number = 23,
    Number_Joiner = 24,
    Other = 25,
    Pure_Killer = 26,
    Register_Shifter = 27,
    Reordering_Killer = 28,
    Syllable_Modifier = 29,
    Tone_Letter = 30,
    Tone_Mark = 31,
    Virama = 32,
    Visarga = 33,
    Vowel = 34,
    Vowel_Dependent = 35,
    Vowel_Independent = 36,
};

enum class Jamo_Short_Name: uint8_t
{
    A = 0,
    AE = 1,
    B = 2,
    BB = 3,
    BS = 4,
    C = 5,
    D = 6,
    DD = 7,
    E = 8,
    EO = 9,
    EU = 10,
    G = 11,
    GG = 12,
    GS = 13,
    H = 14,
    I = 15,
    J = 16,
    JJ = 17,
    K = 18,
    L = 19,
    LB = 20,
    LG = 21,
    LH = 22,
    LM = 23,
    LP = 24,
    LS = 25,
    LT = 26,
    M = 27,
    N = 28,
    NG = 29,
    NH = 30,
    NJ = 31,
    O = 32,
    OE = 33,
    P = 34,
    R = 35,
    S = 36,
    SS = 37,
    T = 38,
    U = 39,
    WA = 40,
    WAE = 41,
    WE = 42,
    WEO = 43,
    WI = 44,
    YA = 45,
    YAE = 46,
    YE = 47,
    YEO = 48,
    YI = 49,
    YO = 50,
    YU = 51,
};

enum class Joining_Group: uint8_t
{
    African_Feh = 0,
    African_Noon = 1,
    African_Qaf = 2,
    Ain = 3,
    Alaph = 4,
    Alef = 5,
    Beh = 6,
    Beth = 7,
    Burushaski_Yeh_Barree = 8,
    Dal = 9,
    Dalath_Rish = 10,
    E = 11,
    Farsi_Yeh = 12,
    Fe = 13,
    Feh = 14,
    Final_Semkath = 15,
    Gaf = 16,
    Gamal = 17,
    Hah = 18,
    Hanifi_Rohingya_Kinna_Ya = 19,
    Hanifi_Rohingya_Pa = 20,
    He = 21,
    Heh = 22,
    Heh_Goal = 23,
    Heth = 24,
    Kaf = 25,
    Kaph = 26,
    Kashmiri_Yeh = 27,
    Khaph = 28,
    Knotted_Heh = 29,
    Lam = 30,
    Lamadh = 31,
    Malayalam_Bha = 32,
    Malayalam_Ja = 33,
    Malayalam_Lla = 34,
    Malayalam_Llla = 35,
    Malayalam_Nga = 36,
    Malayalam_Nna = 37,
    Malayalam_Nnna = 38,
    Malayalam_Nya = 39,
    Malayalam_Ra = 40,
    Malayalam_Ssa = 41,
    Malayalam_Tta = 42,
    Manichaean_Aleph = 43,
    Manichaean_Ayin = 44,
    Manichaean_Beth = 45,
    Manichaean_Daleth = 46,
    Manichaean_Dhamedh = 47,
    Manichaean_Five = 48,
    Manichaean_Gimel = 49,
    Manichaean_Heth = 50,
    Manichaean_Hundred = 51,
    Manichaean_Kaph = 52,
    Manichaean_Lamedh = 53,
    Manichaean_Mem = 54,
    Manichaean_Nun = 55,
    Manichaean_One = 56,
    Manichaean_Pe = 57,
    Manichaean_Qoph = 58,
    Manichaean_Resh = 59,
    Manichaean_Sadhe = 60,
    Manichaean_Samekh = 61,
    Manichaean_Taw = 62,
    Manichaean_Ten = 63,
    Manichaean_Teth = 64,
    Manichaean_Thamedh = 65,
    Manichaean_Twenty = 66,
    Manichaean_Waw = 67,
    Manichaean_Yodh = 68,
    Manichaean_Zayin = 69,
    Meem = 70,
    Mim = 71,
    No_Joining_Group = 72,
    Noon = 73,
    Nun = 74,
    Nya = 75,
    Pe = 76,
    Qaf = 77,
    Qaph = 78,
    Reh = 79,
    Reversed_Pe = 80,
    Rohingya_Yeh = 81,
    Sad = 82,
    Sadhe = 83,
    Seen = 84,
    Semkath = 85,
    Shin = 86,
    Straight_Waw = 87,
    Swash_Kaf = 88,
    Syriac_Waw = 89,
    Tah = 90,
    Taw = 91,
    Teh_Marbuta = 92,
    Teh_Marbuta_Goal = 93,
    Teth = 94,
    Thin_Noon = 95,
    Thin_Yeh = 96,
    Vertical_Tail = 97,
    Waw = 98,
    Yeh = 99,
    Yeh_Barree = 100,
    Yeh_With_Tail = 101,
    Yudh = 102,
    Yudh_He = 103,
    Zain = 104,
    Zhain = 105,
};

enum class Joining_Type: uint8_t
{
    Dual_Joining = 0,
    Join_Causing = 1,
    Left_Joining = 2,
    Non_Joining = 3,
    Right_Joining = 4,
    Transparent = 5,
};

enum class Line_Break: uint8_t
{
    Aksara = 0,
    Aksara_Prebase = 1,
    Aksara_Start = 2,
    Alphabetic = 3,
    Ambiguous = 4,
    Break_After = 5,
    Break_Before = 6,
    Break_Both = 7,
    Break_Symbols = 8,
    Carriage_Return = 9,
    Close_Parenthesis = 10,
    Close_Punctuation = 11,
    Combining_Mark = 12,
    Complex_Context = 13,
    Conditional_Japanese_Starter = 14,
    Contingent_Break = 15,
    E_Base = 16,
    E_Modifier = 17,
    Exclamation = 18,
    Glue = 19,
    H2 = 20,
    H3 = 21,
    Hebrew_Letter = 22,
    Hyphen = 23,
    Ideographic = 24,
    Infix_Numeric = 25,
    Inseparable = 26,
    JL = 27,
    JT = 28,
    JV = 29,
    Line_Feed = 30,
    Mandatory_Break = 31,
    Next_Line = 32,
    Nonstarter = 33,
    Numeric = 34,
    Open_Punctuation = 35,
    Postfix_Numeric = 36,
    Prefix_Numeric = 37,
    Quotation = 38,
    Regional_Indicator = 39,
    Space = 40,
    Surrogate = 41,
    Unambiguous_Hyphen = 42,
    Unknown = 43,
    Virama = 44,
    Virama_Final = 45,
    Word_Joiner = 46,
    ZWJ = 47,
    ZWSpace = 48,
};

enum class NFC_Quick_Check: uint8_t
{
    Maybe = 0,
    No = 1,
    Yes = 2,
};

enum class NFKC_Quick_Check: uint8_t
{
    Maybe = 0,
    No = 1,
    Yes = 2,
};

enum class Numeric_Type: uint8_t
{
    Decimal = 0,
    Digit = 1,
    None = 2,
    Numeric = 3,
};

enum class Sentence_Break: uint8_t
{
    ATerm = 0,
    CR = 1,
    Close = 2,
    Extend = 3,
    Format = 4,
    LF = 5,
    Lower = 6,
    Numeric = 7,
    OLetter = 8,
    Other = 9,
    SContinue = 10,
    STerm = 11,
    Sep = 12,
    Sp = 13,
    Upper = 14,
};

enum class Vertical_Orientation: uint8_t
{
    Rotated = 0,
    Transformed_Rotated = 1,
    Transformed_Upright = 2,
    Upright = 3,
};

enum class Word_Break: uint8_t
{
    ALetter = 0,
    CR = 1,
    Double_Quote = 2,
    E_Base = 3,
    E_Base_GAZ = 4,
    E_Modifier = 5,
    Extend = 6,
    ExtendNumLet = 7,
    Format = 8,
    Glue_After_Zwj = 9,
    Hebrew_Letter = 10,
    Katakana = 11,
    LF = 12,
    MidLetter = 13,
    MidNum = 14,
    MidNumLet = 15,
    Newline = 16,
    Numeric = 17,
    Other = 18,
    Regional_Indicator = 19,
    Single_Quote = 20,
    WSegSpace = 21,
    ZWJ = 22,
};

enum class Core_Property: uint8_t
{
    Alphabetic = 0,
    Case_Ignorable = 1,
    Cased = 2,
    Changes_When_Casefolded = 3,
    Changes_When_Casemapped = 4,
    Changes_When_Lowercased = 5,
    Changes_When_Titlecased = 6,
    Changes_When_Uppercased = 7,
    Default_Ignorable_Code_Point = 8,
    Grapheme_Base = 9,
    Grapheme_Extend = 10,
    Grapheme_Link = 11,
    ID_Continue = 12,
    ID_Start = 13,
    Lowercase = 14,
    Math = 15,
    Uppercase = 16,
    XID_Continue = 17,
    XID_Start = 18,
};

enum class General_Category: uint8_t
{
    Unspecified = 0,
    Close_Punctuation = 1,
    Connector_Punctuation = 2,
    Control = 3,
    Currency_Symbol = 4,
    Dash_Punctuation = 5,
    Decimal_Number = 6,
    Enclosing_Mark = 7,
    Final_Punctuation = 8,
    Format = 9,
    Initial_Punctuation = 10,
    Letter_Number = 11,
    Line_Separator = 12,
    Lowercase_Letter = 13,
    Math_Symbol = 14,
    Modifier_Letter = 15,
    Modifier_Symbol = 16,
    Nonspacing_Mark = 17,
    Open_Punctuation = 18,
    Other_Letter = 19,
    Other_Number = 20,
    Other_Punctuation = 21,
    Other_Symbol = 22,
    Paragraph_Separator = 23,
    Private_Use = 24,
    Space_Separator = 25,
    Spacing_Mark = 26,
    Surrogate = 27,
    Titlecase_Letter = 28,
    Unassigned = 29,
    Uppercase_Letter = 30,
};

enum class Script: uint8_t
{
    Invalid = 0,
    Unknown = 1,
    Common = 2,
    Adlam = 3,
    Ahom = 4,
    Anatolian_Hieroglyphs = 5,
    Arabic = 6,
    Armenian = 7,
    Avestan = 8,
    Balinese = 9,
    Bamum = 10,
    Bassa_Vah = 11,
    Batak = 12,
    Bengali = 13,
    Beria_Erfe = 14,
    Bhaiksuki = 15,
    Bopomofo = 16,
    Brahmi = 17,
    Braille = 18,
    Buginese = 19,
    Buhid = 20,
    Canadian_Aboriginal = 21,
    Carian = 22,
    Caucasian_Albanian = 23,
    Chakma = 24,
    Cham = 25,
    Cherokee = 26,
    Chorasmian = 27,
    Coptic = 28,
    Cuneiform = 29,
    Cypriot = 30,
    Cypro_Minoan = 31,
    Cyrillic = 32,
    Deseret = 33,
    Devanagari = 34,
    Dives_Akuru = 35,
    Dogra = 36,
    Duployan = 37,
    Egyptian_Hieroglyphs = 38,
    Elbasan = 39,
    Elymaic = 40,
    Ethiopic = 41,
    Garay = 42,
    Georgian = 43,
    Glagolitic = 44,
    Gothic = 45,
    Grantha = 46,
    Greek = 47,
    Gujarati = 48,
    Gunjala_Gondi = 49,
    Gurmukhi = 50,
    Gurung_Khema = 51,
    Han = 52,
    Hangul = 53,
    Hanifi_Rohingya = 54,
    Hanunoo = 55,
    Hatran = 56,
    Hebrew = 57,
    Hiragana = 58,
    Imperial_Aramaic = 59,
    Inherited = 60,
    Inscriptional_Pahlavi = 61,
    Inscriptional_Parthian = 62,
    Javanese = 63,
    Kaithi = 64,
    Kannada = 65,
    Katakana = 66,
    Kawi = 67,
    Kayah_Li = 68,
    Kharoshthi = 69,
    Khitan_Small_Script = 70,
    Khmer = 71,
    Khojki = 72,
    Khudawadi = 73,
    Kirat_Rai = 74,
    Lao = 75,
    Latin = 76,
    Lepcha = 77,
    Limbu = 78,
    Linear_A = 79,
    Linear_B = 80,
    Lisu = 81,
    Lycian = 82,
    Lydian = 83,
    Mahajani = 84,
    Makasar = 85,
    Malayalam = 86,
    Mandaic = 87,
    Manichaean = 88,
    Marchen = 89,
    Masaram_Gondi = 90,
    Medefaidrin = 91,
    Meetei_Mayek = 92,
    Mende_Kikakui = 93,
    Meroitic_Cursive = 94,
    Meroitic_Hieroglyphs = 95,
    Miao = 96,
    Modi = 97,
    Mongolian = 98,
    Mro = 99,
    Multani = 100,
    Myanmar = 101,
    Nabataean = 102,
    Nag_Mundari = 103,
    Nandinagari = 104,
    New_Tai_Lue = 105,
    Newa = 106,
    Nko = 107,
    Nushu = 108,
    Nyiakeng_Puachue_Hmong = 109,
    Ogham = 110,
    Ol_Chiki = 111,
    Ol_Onal = 112,
    Old_Hungarian = 113,
    Old_Italic = 114,
    Old_North_Arabian = 115,
    Old_Permic = 116,
    Old_Persian = 117,
    Old_Sogdian = 118,
    Old_South_Arabian = 119,
    Old_Turkic = 120,
    Old_Uyghur = 121,
    Oriya = 122,
    Osage = 123,
    Osmanya = 124,
    Pahawh_Hmong = 125,
    Palmyrene = 126,
    Pau_Cin_Hau = 127,
    Phags_Pa = 128,
    Phoenician = 129,
    Psalter_Pahlavi = 130,
    Rejang = 131,
    Runic = 132,
    Samaritan = 133,
    Saurashtra = 134,
    Sharada = 135,
    Shavian = 136,
    Siddham = 137,
    Sidetic = 138,
    SignWriting = 139,
    Sinhala = 140,
    Sogdian = 141,
    Sora_Sompeng = 142,
    Soyombo = 143,
    Sundanese = 144,
    Sunuwar = 145,
    Syloti_Nagri = 146,
    Syriac = 147,
    Tagalog = 148,
    Tagbanwa = 149,
    Tai_Le = 150,
    Tai_Tham = 151,
    Tai_Viet = 152,
    Tai_Yo = 153,
    Takri = 154,
    Tamil = 155,
    Tangsa = 156,
    Tangut = 157,
    Telugu = 158,
    Thaana = 159,
    Thai = 160,
    Tibetan = 161,
    Tifinagh = 162,
    Tirhuta = 163,
    Todhri = 164,
    Tolong_Siki = 165,
    Toto = 166,
    Tulu_Tigalari = 167,
    Ugaritic = 168,
    Vai = 169,
    Vithkuqi = 170,
    Wancho = 171,
    Warang_Citi = 172,
    Yezidi = 173,
    Yi = 174,
    Zanabazar_Square = 175,
};

enum class Block: uint16_t
{
    Unspecified = 0,
    Adlam = 1,
    Aegean_Numbers = 2,
    Ahom = 3,
    Alchemical_Symbols = 4,
    Alphabetic_Presentation_Forms = 5,
    Anatolian_Hieroglyphs = 6,
    Ancient_Greek_Musical_Notation = 7,
    Ancient_Greek_Numbers = 8,
    Ancient_Symbols = 9,
    Arabic = 10,
    Arabic_Extended_A = 11,
    Arabic_Extended_B = 12,
    Arabic_Extended_C = 13,
    Arabic_Mathematical_Alphabetic_Symbols = 14,
    Arabic_Presentation_Forms_A = 15,
    Arabic_Presentation_Forms_B = 16,
    Arabic_Supplement = 17,
    Armenian = 18,
    Arrows = 19,
    Avestan = 20,
    Balinese = 21,
    Bamum = 22,
    Bamum_Supplement = 23,
    Basic_Latin = 24,
    Bassa_Vah = 25,
    Batak = 26,
    Bengali = 27,
    Beria_Erfe = 28,
    Bhaiksuki = 29,
    Block_Elements = 30,
    Bopomofo = 31,
    Bopomofo_Extended = 32,
    Box_Drawing = 33,
    Brahmi = 34,
    Braille_Patterns = 35,
    Buginese = 36,
    Buhid = 37,
    Byzantine_Musical_Symbols = 38,
    CJK_Compatibility = 39,
    CJK_Compatibility_Forms = 40,
    CJK_Compatibility_Ideographs = 41,
    CJK_Compatibility_Ideographs_Supplement = 42,
    CJK_Radicals_Supplement = 43,
    CJK_Strokes = 44,
    CJK_Symbols_and_Punctuation = 45,
    CJK_Unified_Ideographs = 46,
    CJK_Unified_Ideographs_Extension_A = 47,
    CJK_Unified_Ideographs_Extension_B = 48,
    CJK_Unified_Ideographs_Extension_C = 49,
    CJK_Unified_Ideographs_Extension_D = 50,
    CJK_Unified_Ideographs_Extension_E = 51,
    CJK_Unified_Ideographs_Extension_F = 52,
    CJK_Unified_Ideographs_Extension_G = 53,
    CJK_Unified_Ideographs_Extension_H = 54,
    CJK_Unified_Ideographs_Extension_I = 55,
    CJK_Unified_Ideographs_Extension_J = 56,
    Carian = 57,
    Caucasian_Albanian = 58,
    Chakma = 59,
    Cham = 60,
    Cherokee = 61,
    Cherokee_Supplement = 62,
    Chess_Symbols = 63,
    Chorasmian = 64,
    Combining_Diacritical_Marks = 65,
    Combining_Diacritical_Marks_Extended = 66,
    Combining_Diacritical_Marks_Supplement = 67,
    Combining_Diacritical_Marks_for_Symbols = 68,
    Combining_Half_Marks = 69,
    Common_Indic_Number_Forms = 70,
    Control_Pictures = 71,
    Coptic = 72,
    Coptic_Epact_Numbers = 73,
    Counting_Rod_Numerals = 74,
    Cuneiform = 75,
    Cuneiform_Numbers_and_Punctuation = 76,
    Currency_Symbols = 77,
    Cypriot_Syllabary = 78,
    Cypro_Minoan = 79,
    Cyrillic = 80,
    Cyrillic_Extended_A = 81,
    Cyrillic_Extended_B = 82,
    Cyrillic_Extended_C = 83,
    Cyrillic_Extended_D = 84,
    Cyrillic_Supplement = 85,
    Deseret = 86,
    Devanagari = 87,
    Devanagari_Extended = 88,
    Devanagari_Extended_A = 89,
    Dingbats = 90,
    Dives_Akuru = 91,
    Dogra = 92,
    Domino_Tiles = 93,
    Duployan = 94,
    Early_Dynastic_Cuneiform = 95,
    Egyptian_Hieroglyph_Format_Controls = 96,
    Egyptian_Hieroglyphs = 97,
    Egyptian_Hieroglyphs_Extended_A = 98,
    Elbasan = 99,
    Elymaic = 100,
    Emoticons = 101,
    Enclosed_Alphanumeric_Supplement = 102,
    Enclosed_Alphanumerics = 103,
    Enclosed_CJK_Letters_and_Months = 104,
    Enclosed_Ideographic_Supplement = 105,
    Ethiopic = 106,
    Ethiopic_Extended = 107,
    Ethiopic_Extended_A = 108,
    Ethiopic_Extended_B = 109,
    Ethiopic_Supplement = 110,
    Garay = 111,
    General_Punctuation = 112,
    Geometric_Shapes = 113,
    Geometric_Shapes_Extended = 114,
    Georgian = 115,
    Georgian_Extended = 116,
    Georgian_Supplement = 117,
    Glagolitic = 118,
    Glagolitic_Supplement = 119,
    Gothic = 120,
    Grantha = 121,
    Greek_Extended = 122,
    Greek_and_Coptic = 123,
    Gujarati = 124,
    Gunjala_Gondi = 125,
    Gurmukhi = 126,
    Gurung_Khema = 127,
    Halfwidth_and_Fullwidth_Forms = 128,
    Hangul_Compatibility_Jamo = 129,
    Hangul_Jamo = 130,
    Hangul_Jamo_Extended_A = 131,
    Hangul_Jamo_Extended_B = 132,
    Hangul_Syllables = 133,
    Hanifi_Rohingya = 134,
    Hanunoo = 135,
    Hatran = 136,
    Hebrew = 137,
    High_Private_Use_Surrogates = 138,
    High_Surrogates = 139,
    Hiragana = 140,
    IPA_Extensions = 141,
    Ideographic_Description_Characters = 142,
    Ideographic_Symbols_and_Punctuation = 143,
    Imperial_Aramaic = 144,
    Indic_Siyaq_Numbers = 145,
    Inscriptional_Pahlavi = 146,
    Inscriptional_Parthian = 147,
    Javanese = 148,
    Kaithi = 149,
    Kaktovik_Numerals = 150,
    Kana_Extended_A = 151,
    Kana_Extended_B = 152,
    Kana_Supplement = 153,
    Kanbun = 154,
    Kangxi_Radicals = 155,
    Kannada = 156,
    Katakana = 157,
    Katakana_Phonetic_Extensions = 158,
    Kawi = 159,
    Kayah_Li = 160,
    Kharoshthi = 161,
    Khitan_Small_Script = 162,
    Khmer = 163,
    Khmer_Symbols = 164,
    Khojki = 165,
    Khudawadi = 166,
    Kirat_Rai = 167,
    Lao = 168,
    Latin_Extended_Additional = 169,
    Latin_Extended_A = 170,
    Latin_Extended_B = 171,
    Latin_Extended_C = 172,
    Latin_Extended_D = 173,
    Latin_Extended_E = 174,
    Latin_Extended_F = 175,
    Latin_Extended_G = 176,
    Latin_1_Supplement = 177,
    Lepcha = 178,
    Letterlike_Symbols = 179,
    Limbu = 180,
    Linear_A = 181,
    Linear_B_Ideograms = 182,
    Linear_B_Syllabary = 183,
    Lisu = 184,
    Lisu_Supplement = 185,
    Low_Surrogates = 186,
    Lycian = 187,
    Lydian = 188,
    Mahajani = 189,
    Mahjong_Tiles = 190,
    Makasar = 191,
    Malayalam = 192,
    Mandaic = 193,
    Manichaean = 194,
    Marchen = 195,
    Masaram_Gondi = 196,
    Mathematical_Alphanumeric_Symbols = 197,
    Mathematical_Operators = 198,
    Mayan_Numerals = 199,
    Medefaidrin = 200,
    Meetei_Mayek = 201,
    Meetei_Mayek_Extensions = 202,
    Mende_Kikakui = 203,
    Meroitic_Cursive = 204,
    Meroitic_Hieroglyphs = 205,
    Miao = 206,
    Miscellaneous_Mathematical_Symbols_A = 207,
    Miscellaneous_Mathematical_Symbols_B = 208,
    Miscellaneous_Symbols = 209,
    Miscellaneous_Symbols_Supplement = 210,
    Miscellaneous_Symbols_and_Arrows = 211,
    Miscellaneous_Symbols_and_Pictographs = 212,
    Miscellaneous_Technical = 213,
    Modi = 214,
    Modifier_Tone_Letters = 215,
    Mongolian = 216,
    Mongolian_Supplement = 217,
    Mro = 218,
    Multani = 219,
    Musical_Symbols = 220,
    Myanmar = 221,
    Myanmar_Extended_A = 222,
    Myanmar_Extended_B = 223,
    Myanmar_Extended_C = 224,
    NKo = 225,
    Nabataean = 226,
    Nag_Mundari = 227,
    Nandinagari = 228,
    New_Tai_Lue = 229,
    Newa = 230,
    Number_Forms = 231,
    Nushu = 232,
    Nyiakeng_Puachue_Hmong = 233,
    Ogham = 234,
    Ol_Chiki = 235,
    Ol_Onal = 236,
    Old_Hungarian = 237,
    Old_Italic = 238,
    Old_North_Arabian = 239,
    Old_Permic = 240,
    Old_Persian = 241,
    Old_Sogdian = 242,
    Old_South_Arabian = 243,
    Old_Turkic = 244,
    Old_Uyghur = 245,
    Optical_Character_Recognition = 246,
    Oriya = 247,
    Ornamental_Dingbats = 248,
    Osage = 249,
    Osmanya = 250,
    Ottoman_Siyaq_Numbers = 251,
    Pahawh_Hmong = 252,
    Palmyrene = 253,
    Pau_Cin_Hau = 254,
    Phags_pa = 255,
    Phaistos_Disc = 256,
    Phoenician = 257,
    Phonetic_Extensions = 258,
    Phonetic_Extensions_Supplement = 259,
    Playing_Cards = 260,
    Private_Use_Area = 261,
    Psalter_Pahlavi = 262,
    Rejang = 263,
    Rumi_Numeral_Symbols = 264,
    Runic = 265,
    Samaritan = 266,
    Saurashtra = 267,
    Sharada = 268,
    Sharada_Supplement = 269,
    Shavian = 270,
    Shorthand_Format_Controls = 271,
    Siddham = 272,
    Sidetic = 273,
    Sinhala = 274,
    Sinhala_Archaic_Numbers = 275,
    Small_Form_Variants = 276,
    Small_Kana_Extension = 277,
    Sogdian = 278,
    Sora_Sompeng = 279,
    Soyombo = 280,
    Spacing_Modifier_Letters = 281,
    Specials = 282,
    Sundanese = 283,
    Sundanese_Supplement = 284,
    Sunuwar = 285,
    Superscripts_and_Subscripts = 286,
    Supplemental_Arrows_A = 287,
    Supplemental_Arrows_B = 288,
    Supplemental_Arrows_C = 289,
    Supplemental_Mathematical_Operators = 290,
    Supplemental_Punctuation = 291,
    Supplemental_Symbols_and_Pictographs = 292,
    Supplementary_Private_Use_Area_A = 293,
    Supplementary_Private_Use_Area_B = 294,
    Sutton_SignWriting = 295,
    Syloti_Nagri = 296,
    Symbols_and_Pictographs_Extended_A = 297,
    Symbols_for_Legacy_Computing = 298,
    Symbols_for_Legacy_Computing_Supplement = 299,
    Syriac = 300,
    Syriac_Supplement = 301,
    Tagalog = 302,
    Tagbanwa = 303,
    Tags = 304,
    Tai_Le = 305,
    Tai_Tham = 306,
    Tai_Viet = 307,
    Tai_Xuan_Jing_Symbols = 308,
    Tai_Yo = 309,
    Takri = 310,
    Tamil = 311,
    Tamil_Supplement = 312,
    Tangsa = 313,
    Tangut = 314,
    Tangut_Components = 315,
    Tangut_Components_Supplement = 316,
    Tangut_Supplement = 317,
    Telugu = 318,
    Thaana = 319,
    Thai = 320,
    Tibetan = 321,
    Tifinagh = 322,
    Tirhuta = 323,
    Todhri = 324,
    Tolong_Siki = 325,
    Toto = 326,
    Transport_and_Map_Symbols = 327,
    Tulu_Tigalari = 328,
    Ugaritic = 329,
    Unified_Canadian_Aboriginal_Syllabics = 330,
    Unified_Canadian_Aboriginal_Syllabics_Extended = 331,
    Unified_Canadian_Aboriginal_Syllabics_Extended_A = 332,
    Vai = 333,
    Variation_Selectors = 334,
    Variation_Selectors_Supplement = 335,
    Vedic_Extensions = 336,
    Vertical_Forms = 337,
    Vithkuqi = 338,
    Wancho = 339,
    Warang_Citi = 340,
    Yezidi = 341,
    Yi_Radicals = 342,
    Yi_Syllables = 343,
    Yijing_Hexagram_Symbols = 344,
    Zanabazar_Square = 345,
    Znamenny_Musical_Notation = 346,
};

enum class EastAsianWidth: uint8_t
{
    Ambiguous = 0,
    FullWidth = 1,
    HalfWidth = 2,
    Neutral = 3,
    Narrow = 4,
    Wide = 5,
    Unspecified = 6,
};

} // namespace unicode
