import sys

if sys.platform == "darwin":
    from _typeshed import StrOrBytesPath
    from collections.abc import Sequence
    from socket import AddressFamily, SocketKind
    from typing import Final, TypeVar

    _T = TypeVar("_T")

    version: Final[int]
    SIDL: Final = 1
    SRUN: Final = 2
    SSLEEP: Final = 3
    SSTOP: Final = 4
    SZOMB: Final = 5
    TCPS_CLOSED: Final = 0
    TCPS_CLOSING: Final = 7
    TCPS_CLOSE_WAIT: Final = 5
    TCPS_LISTEN: Final = 1
    TCPS_ESTABLISHED: Final = 4
    TCPS_SYN_SENT: Final = 2
    TCPS_SYN_RECEIVED: Final = 3
    TCPS_FIN_WAIT_1: Final = 6
    TCPS_FIN_WAIT_2: Final = 9
    TCPS_LAST_ACK: Final = 8
    TCPS_TIME_WAIT: Final = 10
    PSUTIL_CONN_NONE: Final = 128

    def proc_cmdline(pid: int, /) -> list[str]: ...
    def proc_cwd(pid: int, /) -> str: ...
    def proc_environ(pid: int, /) -> str: ...
    def proc_exe(pid: int, /) -> str: ...
    def proc_kinfo_oneshot(pid: int, /) -> tuple[int, int, int, int, int, int, int, float, int, str]: ...
    def proc_memory_uss(pid: int, /) -> int: ...
    def proc_name(pid: int, /) -> str: ...
    def proc_net_connections(
        pid: int, af_filter: Sequence[AddressFamily | int | None], type_filter: Sequence[SocketKind | int | None], /
    ) -> list[
        tuple[int, int, int, tuple[str | None, int], tuple[str | None, int] | tuple[()], int]
        | tuple[int, int, int, str, str, int]
    ]: ...
    def proc_num_fds(pid: int, /) -> int: ...
    def proc_open_files(pid: int, /) -> list[tuple[str, int]]: ...
    def proc_pidtaskinfo_oneshot(pid: int, /) -> tuple[float, float, int, int, int, int, int, int]: ...
    def proc_threads(pid: int, /) -> list[tuple[int, float, float]]: ...
    def boot_time() -> float: ...
    def cpu_count_cores() -> int | None: ...
    def cpu_count_logical() -> int | None: ...
    def cpu_freq() -> tuple[int, int, int]: ...
    def cpu_stats() -> tuple[int, int, int, int, int]: ...
    def cpu_times() -> tuple[float, float, float, float]: ...
    def disk_io_counters() -> dict[str, tuple[int, int, int, int, int, int]]: ...
    def disk_partitions() -> list[tuple[str, str, str, str]]: ...
    def disk_usage_used(mount_point: StrOrBytesPath, default: _T, /) -> int | _T: ...
    def net_io_counters() -> dict[str, tuple[int, int, int, int, int, int, int, int]]: ...
    def per_cpu_times() -> list[tuple[float, float, float, float]]: ...
    def pids() -> list[int]: ...
    def sensors_battery() -> tuple[int, int, int]: ...
    def swap_mem() -> tuple[int, int, int, int, int]: ...
    def users() -> list[tuple[str, str, str, float, int]]: ...
    def virtual_mem() -> tuple[int, int, int, int, int, int]: ...
    def check_pid_range(pid: int, /) -> None: ...
    def set_debug(value: bool, /) -> None: ...
