/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class CacheVersion
implements Comparable<CacheVersion> {
    public static final String COMPONENT_SEPARATOR = ".";
    private final int[] components;

    public static CacheVersion parse(String version) {
        String[] parts = StringUtils.split((String)version, (String)COMPONENT_SEPARATOR);
        int[] components = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            components[i] = Integer.parseInt(parts[i]);
        }
        return new CacheVersion(components);
    }

    public static CacheVersion empty() {
        return new CacheVersion(ArrayUtils.EMPTY_INT_ARRAY);
    }

    public static CacheVersion of(int component) {
        return new CacheVersion(new int[]{component});
    }

    public static CacheVersion of(int ... components) {
        return new CacheVersion(ArrayUtils.clone((int[])components));
    }

    private CacheVersion(int[] components) {
        this.components = components;
    }

    public CacheVersion append(int additionalComponent) {
        int[] appendedComponents = new int[this.components.length + 1];
        System.arraycopy(this.components, 0, appendedComponents, 0, this.components.length);
        appendedComponents[this.components.length] = additionalComponent;
        return new CacheVersion(appendedComponents);
    }

    public String toString() {
        return Ints.join((String)COMPONENT_SEPARATOR, (int[])this.components);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheVersion that = (CacheVersion)o;
        return Arrays.equals(this.components, that.components);
    }

    public int hashCode() {
        return Arrays.hashCode(this.components);
    }

    @Override
    public int compareTo(CacheVersion that) {
        int minLength = Math.min(this.components.length, that.components.length);
        for (int i = 0; i < minLength; ++i) {
            int result = Integer.compare(this.components[i], that.components[i]);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(this.components.length, that.components.length);
    }
}

