/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.Map;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedResolvedGraphDependency;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class DependencyResultSerializer {
    private static final byte SUCCESSFUL = 0;
    private static final byte SUCCESSFUL_NOTHING_SELECTED = 1;
    private static final byte FAILED = 2;
    private final ComponentSelectionReasonSerializer componentSelectionReasonSerializer;
    private final Serializer<ComponentSelector> componentSelectorSerializer;

    public DependencyResultSerializer(ComponentSelectionReasonSerializer componentSelectionReasonSerializer, Serializer<ComponentSelector> componentSelectorSerializer) {
        this.componentSelectionReasonSerializer = componentSelectionReasonSerializer;
        this.componentSelectorSerializer = componentSelectorSerializer;
    }

    public ResolvedGraphDependency read(Decoder decoder, Map<ComponentSelector, ModuleVersionResolveException> failures) throws Exception {
        ComponentSelector requested = (ComponentSelector)this.componentSelectorSerializer.read(decoder);
        boolean constraint = decoder.readBoolean();
        long fromVariant = decoder.readSmallLong();
        byte resultByte = decoder.readByte();
        if (resultByte == 0) {
            long selectedId = decoder.readSmallLong();
            long selectedVariantId = decoder.readSmallLong();
            return new DetachedResolvedGraphDependency(requested, selectedId, null, null, constraint, fromVariant, selectedVariantId);
        }
        if (resultByte == 1) {
            long selectedId = decoder.readSmallLong();
            return new DetachedResolvedGraphDependency(requested, selectedId, null, null, constraint, fromVariant, null);
        }
        if (resultByte == 2) {
            ComponentSelectionReason reason = this.componentSelectionReasonSerializer.read(decoder);
            ModuleVersionResolveException failure = failures.get(requested);
            return new DetachedResolvedGraphDependency(requested, null, reason, failure, constraint, fromVariant, null);
        }
        throw new IllegalArgumentException("Unknown result type: " + resultByte);
    }

    public void write(Encoder encoder, DependencyGraphEdge value) throws Exception {
        this.componentSelectorSerializer.write(encoder, (Object)value.getRequested());
        encoder.writeBoolean(value.isConstraint());
        encoder.writeSmallLong(value.getFromVariant());
        if (value.getFailure() == null) {
            if (value.getSelectedVariant() != null) {
                encoder.writeByte((byte)0);
                encoder.writeSmallLong(value.getSelected().longValue());
                encoder.writeSmallLong(value.getSelectedVariant().longValue());
            } else {
                encoder.writeByte((byte)1);
                encoder.writeSmallLong(value.getSelected().longValue());
            }
        } else {
            encoder.writeByte((byte)2);
            this.componentSelectionReasonSerializer.write(encoder, value.getReason());
        }
    }
}

