/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.common;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class SubImageInputStream
extends ImageInputStreamImpl {
    ImageInputStream stream;
    long startingPos;
    int startingLength;
    int length;

    public SubImageInputStream(ImageInputStream imageInputStream, int n) throws IOException {
        this.stream = imageInputStream;
        this.startingPos = imageInputStream.getStreamPosition();
        this.startingLength = this.length = n;
    }

    @Override
    public int read() throws IOException {
        if (this.length == 0) {
            return -1;
        }
        --this.length;
        return this.stream.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.length == 0) {
            return -1;
        }
        n2 = Math.min(n2, this.length);
        int n3 = this.stream.read(byArray, n, n2);
        this.length -= n3;
        return n3;
    }

    @Override
    public long length() {
        return this.startingLength;
    }

    @Override
    public void seek(long l) throws IOException {
        this.stream.seek(l - this.startingPos);
        this.streamPos = l;
    }

    @Override
    protected void finalize() throws Throwable {
    }
}

