/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import sun.text.bidi.BidiBase;

public final class Bidi {
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    private BidiBase bidiBase;

    public Bidi(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        this.bidiBase = new BidiBase(string.toCharArray(), 0, null, 0, string.length(), n);
    }

    public Bidi(AttributedCharacterIterator attributedCharacterIterator) {
        if (attributedCharacterIterator == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        this.bidiBase = new BidiBase(0, 0);
        this.bidiBase.setPara(attributedCharacterIterator);
    }

    public Bidi(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        if (cArray == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("bad length: " + n3);
        }
        if (n < 0 || n3 > cArray.length - n) {
            throw new IllegalArgumentException("bad range: " + n + " length: " + n3 + " for text of length: " + cArray.length);
        }
        if (byArray != null && (n2 < 0 || n3 > byArray.length - n2)) {
            throw new IllegalArgumentException("bad range: " + n2 + " length: " + n3 + " for embeddings of length: " + cArray.length);
        }
        this.bidiBase = new BidiBase(cArray, n, byArray, n2, n3, n4);
    }

    public Bidi createLineBidi(int n, int n2) {
        AttributedString attributedString = new AttributedString("");
        Bidi bidi = new Bidi(attributedString.getIterator());
        return this.bidiBase.setLine(this, this.bidiBase, bidi, bidi.bidiBase, n, n2);
    }

    public boolean isMixed() {
        return this.bidiBase.isMixed();
    }

    public boolean isLeftToRight() {
        return this.bidiBase.isLeftToRight();
    }

    public boolean isRightToLeft() {
        return this.bidiBase.isRightToLeft();
    }

    public int getLength() {
        return this.bidiBase.getLength();
    }

    public boolean baseIsLeftToRight() {
        return this.bidiBase.baseIsLeftToRight();
    }

    public int getBaseLevel() {
        return this.bidiBase.getParaLevel();
    }

    public int getLevelAt(int n) {
        return this.bidiBase.getLevelAt(n);
    }

    public int getRunCount() {
        return this.bidiBase.countRuns();
    }

    public int getRunLevel(int n) {
        return this.bidiBase.getRunLevel(n);
    }

    public int getRunStart(int n) {
        return this.bidiBase.getRunStart(n);
    }

    public int getRunLimit(int n) {
        return this.bidiBase.getRunLimit(n);
    }

    public static boolean requiresBidi(char[] cArray, int n, int n2) {
        return BidiBase.requiresBidi(cArray, n, n2);
    }

    public static void reorderVisually(byte[] byArray, int n, Object[] objectArray, int n2, int n3) {
        BidiBase.reorderVisually(byArray, n, objectArray, n2, n3);
    }

    public String toString() {
        return this.bidiBase.toString();
    }
}

