/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class FutureTask<V>
implements RunnableFuture<V> {
    private volatile int state;
    private static final int NEW = 0;
    private static final int COMPLETING = 1;
    private static final int NORMAL = 2;
    private static final int EXCEPTIONAL = 3;
    private static final int CANCELLED = 4;
    private static final int INTERRUPTING = 5;
    private static final int INTERRUPTED = 6;
    private Callable<V> callable;
    private Object outcome;
    private volatile Thread runner;
    private volatile WaitNode waiters;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;
    private static final long runnerOffset;
    private static final long waitersOffset;

    private V report(int n) throws ExecutionException {
        Object object = this.outcome;
        if (n == 2) {
            return (V)object;
        }
        if (n >= 4) {
            throw new CancellationException();
        }
        throw new ExecutionException((Throwable)object);
    }

    public FutureTask(Callable<V> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.callable = callable;
        this.state = 0;
    }

    public FutureTask(Runnable runnable, V v) {
        this.callable = Executors.callable(runnable, v);
        this.state = 0;
    }

    @Override
    public boolean isCancelled() {
        return this.state >= 4;
    }

    @Override
    public boolean isDone() {
        return this.state != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        block8: {
            if (this.state != 0 || !UNSAFE.compareAndSwapInt(this, stateOffset, 0, bl ? 5 : 4)) {
                return false;
            }
            try {
                if (!bl) break block8;
                try {
                    Thread thread = this.runner;
                    if (thread != null) {
                        thread.interrupt();
                    }
                }
                finally {
                    UNSAFE.putOrderedInt(this, stateOffset, 6);
                }
            }
            finally {
                this.finishCompletion();
            }
        }
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        int n = this.state;
        if (n <= 1) {
            n = this.awaitDone(false, 0L);
        }
        return this.report(n);
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        int n = this.state;
        if (n <= 1 && (n = this.awaitDone(true, timeUnit.toNanos(l))) <= 1) {
            throw new TimeoutException();
        }
        return this.report(n);
    }

    protected void done() {
    }

    protected void set(V v) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = v;
            UNSAFE.putOrderedInt(this, stateOffset, 2);
            this.finishCompletion();
        }
    }

    protected void setException(Throwable throwable) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = throwable;
            UNSAFE.putOrderedInt(this, stateOffset, 3);
            this.finishCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            if (this.state != 0 || !UNSAFE.compareAndSwapObject(this, runnerOffset, null, Thread.currentThread())) {
                return;
            }
            try {
                boolean bl;
                V v;
                Callable<V> callable = this.callable;
                if (callable == null || this.state != 0) break block8;
                try {
                    v = callable.call();
                    bl = true;
                }
                catch (Throwable throwable) {
                    v = null;
                    bl = false;
                    this.setException(throwable);
                }
                if (bl) {
                    this.set(v);
                }
            }
            finally {
                this.runner = null;
                int n = this.state;
                if (n >= 5) {
                    this.handlePossibleCancellationInterrupt(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runAndReset() {
        if (this.state != 0 || !UNSAFE.compareAndSwapObject(this, runnerOffset, null, Thread.currentThread())) {
            return false;
        }
        boolean bl = false;
        int n = this.state;
        try {
            Callable<V> callable = this.callable;
            if (callable != null && n == 0) {
                try {
                    callable.call();
                    bl = true;
                }
                catch (Throwable throwable) {
                    this.setException(throwable);
                }
            }
        }
        finally {
            this.runner = null;
            n = this.state;
            if (n >= 5) {
                this.handlePossibleCancellationInterrupt(n);
            }
        }
        return bl && n == 0;
    }

    private void handlePossibleCancellationInterrupt(int n) {
        if (n == 5) {
            while (this.state == 5) {
                Thread.yield();
            }
        }
    }

    private void finishCompletion() {
        WaitNode waitNode;
        block0: while ((waitNode = this.waiters) != null) {
            if (!UNSAFE.compareAndSwapObject(this, waitersOffset, waitNode, null)) continue;
            while (true) {
                WaitNode waitNode2;
                Thread thread;
                if ((thread = waitNode.thread) != null) {
                    waitNode.thread = null;
                    LockSupport.unpark(thread);
                }
                if ((waitNode2 = waitNode.next) == null) break block0;
                waitNode.next = null;
                waitNode = waitNode2;
            }
        }
        this.done();
        this.callable = null;
    }

    private int awaitDone(boolean bl, long l) throws InterruptedException {
        long l2 = bl ? System.nanoTime() + l : 0L;
        WaitNode waitNode = null;
        boolean bl2 = false;
        while (true) {
            if (Thread.interrupted()) {
                this.removeWaiter(waitNode);
                throw new InterruptedException();
            }
            int n = this.state;
            if (n > 1) {
                if (waitNode != null) {
                    waitNode.thread = null;
                }
                return n;
            }
            if (n == 1) {
                Thread.yield();
                continue;
            }
            if (waitNode == null) {
                waitNode = new WaitNode();
                continue;
            }
            if (!bl2) {
                waitNode.next = this.waiters;
                bl2 = UNSAFE.compareAndSwapObject(this, waitersOffset, waitNode.next, waitNode);
                continue;
            }
            if (bl) {
                l = l2 - System.nanoTime();
                if (l <= 0L) {
                    this.removeWaiter(waitNode);
                    return this.state;
                }
                LockSupport.parkNanos(this, l);
                continue;
            }
            LockSupport.park(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(WaitNode var1_1) {
        if (var1_1 != null) {
            var1_1.thread = null;
            block0: while (true) {
                var2_2 = null;
                var3_3 = this.waiters;
                while (var3_3 != null) {
                    var4_4 = var3_3.next;
                    if (var3_3.thread != null) {
                        var2_2 = var3_3;
                    } else if (var2_2 != null) {
                        var2_2.next = var4_4;
                        if (var2_2.thread == null) {
                            continue block0;
                        }
                    } else {
                        if (FutureTask.UNSAFE.compareAndSwapObject(this, FutureTask.waitersOffset, var3_3, var4_4)) ** break;
                        continue block0;
                    }
                    var3_3 = var4_4;
                }
                break;
            }
        }
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<FutureTask> clazz = FutureTask.class;
            stateOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("state"));
            runnerOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("runner"));
            waitersOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("waiters"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class WaitNode {
        volatile Thread thread = Thread.currentThread();
        volatile WaitNode next;

        WaitNode() {
        }
    }
}

