/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XSetWindowAttributes
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 60 : 112;
    }

    @Override
    public int getDataSize() {
        return XSetWindowAttributes.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XSetWindowAttributes(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XSetWindowAttributes() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XSetWindowAttributes.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_background_pixmap() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_background_pixmap(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_background_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_background_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    public long get_border_pixmap() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16));
    }

    public void set_border_pixmap(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16), l);
    }

    public long get_border_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24));
    }

    public void set_border_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24), l);
    }

    public int get_bit_gravity() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 32));
    }

    public void set_bit_gravity(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 32), n);
    }

    public int get_win_gravity() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 36));
    }

    public void set_win_gravity(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 36), n);
    }

    public int get_backing_store() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 40));
    }

    public void set_backing_store(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 40), n);
    }

    public long get_backing_planes() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 48));
    }

    public void set_backing_planes(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 48), l);
    }

    public long get_backing_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 56));
    }

    public void set_backing_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 56), l);
    }

    public boolean get_save_under() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 64));
    }

    public void set_save_under(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 64), bl);
    }

    public long get_event_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 72));
    }

    public void set_event_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 72), l);
    }

    public long get_do_not_propagate_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 80));
    }

    public void set_do_not_propagate_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 80), l);
    }

    public boolean get_override_redirect() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 88));
    }

    public void set_override_redirect(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 88), bl);
    }

    public long get_colormap() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 96));
    }

    public void set_colormap(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 96), l);
    }

    public long get_cursor() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 104));
    }

    public void set_cursor(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 104), l);
    }

    @Override
    String getName() {
        return "XSetWindowAttributes";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(600);
        stringBuilder.append("background_pixmap = ").append(this.get_background_pixmap()).append(", ");
        stringBuilder.append("background_pixel = ").append(this.get_background_pixel()).append(", ");
        stringBuilder.append("border_pixmap = ").append(this.get_border_pixmap()).append(", ");
        stringBuilder.append("border_pixel = ").append(this.get_border_pixel()).append(", ");
        stringBuilder.append("bit_gravity = ").append(this.get_bit_gravity()).append(", ");
        stringBuilder.append("win_gravity = ").append(this.get_win_gravity()).append(", ");
        stringBuilder.append("backing_store = ").append(this.get_backing_store()).append(", ");
        stringBuilder.append("backing_planes = ").append(this.get_backing_planes()).append(", ");
        stringBuilder.append("backing_pixel = ").append(this.get_backing_pixel()).append(", ");
        stringBuilder.append("save_under = ").append(this.get_save_under()).append(", ");
        stringBuilder.append("event_mask = ").append(this.get_event_mask()).append(", ");
        stringBuilder.append("do_not_propagate_mask = ").append(this.get_do_not_propagate_mask()).append(", ");
        stringBuilder.append("override_redirect = ").append(this.get_override_redirect()).append(", ");
        stringBuilder.append("colormap = ").append(this.get_colormap()).append(", ");
        stringBuilder.append("cursor = ").append(this.get_cursor()).append(", ");
        return stringBuilder.toString();
    }
}

