/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sun.font.CompositeFont;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.FontStrikeDisposer;
import sun.font.PhysicalStrike;
import sun.font.StrikeMetrics;

public final class CompositeStrike
extends FontStrike {
    static final int SLOTMASK = 0xFFFFFF;
    private CompositeFont compFont;
    private PhysicalStrike[] strikes;
    int numGlyphs = 0;

    CompositeStrike(CompositeFont compositeFont, FontStrikeDesc fontStrikeDesc) {
        this.compFont = compositeFont;
        this.desc = fontStrikeDesc;
        this.disposer = new FontStrikeDisposer(this.compFont, fontStrikeDesc);
        if (fontStrikeDesc.style != this.compFont.style) {
            this.algoStyle = true;
            if ((fontStrikeDesc.style & 1) == 1 && (this.compFont.style & 1) == 0) {
                this.boldness = 1.33f;
            }
            if ((fontStrikeDesc.style & 2) == 2 && (this.compFont.style & 2) == 0) {
                this.italic = 0.7f;
            }
        }
        this.strikes = new PhysicalStrike[this.compFont.numSlots];
    }

    PhysicalStrike getStrikeForGlyph(int n) {
        return this.getStrikeForSlot(n >>> 24);
    }

    PhysicalStrike getStrikeForSlot(int n) {
        PhysicalStrike physicalStrike;
        if (n >= this.strikes.length) {
            n = 0;
        }
        if ((physicalStrike = this.strikes[n]) == null) {
            this.strikes[n] = physicalStrike = (PhysicalStrike)this.compFont.getSlotFont(n).getStrike(this.desc);
        }
        return physicalStrike;
    }

    @Override
    public int getNumGlyphs() {
        return this.compFont.getNumGlyphs();
    }

    @Override
    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            StrikeMetrics strikeMetrics = new StrikeMetrics();
            for (int i = 0; i < this.compFont.numMetricsSlots; ++i) {
                strikeMetrics.merge(this.getStrikeForSlot(i).getFontMetrics());
            }
            this.strikeMetrics = strikeMetrics;
        }
        return this.strikeMetrics;
    }

    @Override
    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        PhysicalStrike physicalStrike = this.getStrikeForSlot(0);
        int n2 = physicalStrike.getSlot0GlyphImagePtrs(nArray, lArray, n);
        if (n2 == n) {
            return;
        }
        for (int i = n2; i < n; ++i) {
            physicalStrike = this.getStrikeForGlyph(nArray[i]);
            lArray[i] = physicalStrike.getGlyphImagePtr(nArray[i] & 0xFFFFFF);
        }
    }

    @Override
    long getGlyphImagePtr(int n) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n);
        return physicalStrike.getGlyphImagePtr(n & 0xFFFFFF);
    }

    @Override
    void getGlyphImageBounds(int n, Point2D.Float float_, Rectangle rectangle) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n);
        physicalStrike.getGlyphImageBounds(n & 0xFFFFFF, float_, rectangle);
    }

    @Override
    Point2D.Float getGlyphMetrics(int n) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n);
        return physicalStrike.getGlyphMetrics(n & 0xFFFFFF);
    }

    @Override
    Point2D.Float getCharMetrics(char c) {
        return this.getGlyphMetrics(this.compFont.getMapper().charToGlyph(c));
    }

    @Override
    float getGlyphAdvance(int n) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n);
        return physicalStrike.getGlyphAdvance(n & 0xFFFFFF);
    }

    @Override
    float getCodePointAdvance(int n) {
        return this.getGlyphAdvance(this.compFont.getMapper().charToGlyph(n));
    }

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(int n) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n);
        return physicalStrike.getGlyphOutlineBounds(n & 0xFFFFFF);
    }

    @Override
    GeneralPath getGlyphOutline(int n, float f, float f2) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n);
        GeneralPath generalPath = physicalStrike.getGlyphOutline(n & 0xFFFFFF, f, f2);
        if (generalPath == null) {
            return new GeneralPath();
        }
        return generalPath;
    }

    @Override
    GeneralPath getGlyphVectorOutline(int[] nArray, float f, float f2) {
        GeneralPath generalPath = null;
        int n = 0;
        while (n < nArray.length) {
            int n2 = n;
            int n3 = nArray[n] >>> 24;
            while (n < nArray.length && nArray[n + 1] >>> 24 == n3) {
                ++n;
            }
            int n4 = n - n2 + 1;
            int[] nArray2 = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray2[i] = nArray[i] & 0xFFFFFF;
            }
            GeneralPath generalPath2 = this.getStrikeForSlot(n3).getGlyphVectorOutline(nArray2, f, f2);
            if (generalPath == null) {
                generalPath = generalPath2;
                continue;
            }
            if (generalPath2 == null) continue;
            generalPath.append(generalPath2, false);
        }
        if (generalPath == null) {
            return new GeneralPath();
        }
        return generalPath;
    }
}

