type token =
  | STRING of (string)
  | IDENT of (string)
  | BOOL of (bool)
  | EOF
  | LBRACKET
  | RBRACKET
  | LPAR
  | RPAR
  | LBRACE
  | RBRACE
  | COLON
  | INT of (int)
  | RELOP of (OpamTypes.relop)
  | LOGOP of (OpamTypes.logop)
  | PFXOP of (OpamTypes.pfxop)
  | ENVOP of (string)

val main :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> string -> OpamTypes.file
val value :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> OpamTypes.value
