#!/usr/bin/env python
# coding: utf-8
#
# Copyright 2012 Facebook
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

"""Data used by the tornado.locale module."""

from __future__ import absolute_import, division, print_function, with_statement

LOCALE_NAMES = {
    "af_ZA": {"name_en": u"Afrikaans", "name": u"Afrikaans"},
    "am_ET": {"name_en": u"Amharic", "name": u"አማርኛ"},
    "ar_AR": {"name_en": u"Arabic", "name": u"العربية"},
    "bg_BG": {"name_en": u"Bulgarian", "name": u"Български"},
    "bn_IN": {"name_en": u"Bengali", "name": u"বাংলা"},
    "bs_BA": {"name_en": u"Bosnian", "name": u"Bosanski"},
    "ca_ES": {"name_en": u"Catalan", "name": u"Català"},
    "cs_CZ": {"name_en": u"Czech", "name": u"Čeština"},
    "cy_GB": {"name_en": u"Welsh", "name": u"Cymraeg"},
    "da_DK": {"name_en": u"Danish", "name": u"Dansk"},
    "de_DE": {"name_en": u"German", "name": u"Deutsch"},
    "el_GR": {"name_en": u"Greek", "name": u"Ελληνικά"},
    "en_GB": {"name_en": u"English (UK)", "name": u"English (UK)"},
    "en_US": {"name_en": u"English (US)", "name": u"English (US)"},
    "es_ES": {"name_en": u"Spanish (Spain)", "name": u"Español (España)"},
    "es_LA": {"name_en": u"Spanish", "name": u"Español"},
    "et_EE": {"name_en": u"Estonian", "name": u"Eesti"},
    "eu_ES": {"name_en": u"Basque", "name": u"Euskara"},
    "fa_IR": {"name_en": u"Persian", "name": u"فارسی"},
    "fi_FI": {"name_en": u"Finnish", "name": u"Suomi"},
    "fr_CA": {"name_en": u"French (Canada)", "name": u"Français (Canada)"},
    "fr_FR": {"name_en": u"French", "name": u"Français"},
    "ga_IE": {"name_en": u"Irish", "name": u"Gaeilge"},
    "gl_ES": {"name_en": u"Galician", "name": u"Galego"},
    "he_IL": {"name_en": u"Hebrew", "name": u"עברית"},
    "hi_IN": {"name_en": u"Hindi", "name": u"हिन्दी"},
    "hr_HR": {"name_en": u"Croatian", "name": u"Hrvatski"},
    "hu_HU": {"name_en": u"Hungarian", "name": u"Magyar"},
    "id_ID": {"name_en": u"Indonesian", "name": u"Bahasa Indonesia"},
    "is_IS": {"name_en": u"Icelandic", "name": u"Íslenska"},
    "it_IT": {"name_en": u"Italian", "name": u"Italiano"},
    "ja_JP": {"name_en": u"Japanese", "name": u"日本語"},
    "ko_KR": {"name_en": u"Korean", "name": u"한국어"},
    "lt_LT": {"name_en": u"Lithuanian", "name": u"Lietuvių"},
    "lv_LV": {"name_en": u"Latvian", "name": u"Latviešu"},
    "mk_MK": {"name_en": u"Macedonian", "name": u"Македонски"},
    "ml_IN": {"name_en": u"Malayalam", "name": u"മലയാളം"},
    "ms_MY": {"name_en": u"Malay", "name": u"Bahasa Melayu"},
    "nb_NO": {"name_en": u"Norwegian (bokmal)", "name": u"Norsk (bokmål)"},
    "nl_NL": {"name_en": u"Dutch", "name": u"Nederlands"},
    "nn_NO": {"name_en": u"Norwegian (nynorsk)", "name": u"Norsk (nynorsk)"},
    "pa_IN": {"name_en": u"Punjabi", "name": u"ਪੰਜਾਬੀ"},
    "pl_PL": {"name_en": u"Polish", "name": u"Polski"},
    "pt_BR": {"name_en": u"Portuguese (Brazil)", "name": u"Português (Brasil)"},
    "pt_PT": {"name_en": u"Portuguese (Portugal)", "name": u"Português (Portugal)"},
    "ro_RO": {"name_en": u"Romanian", "name": u"Română"},
    "ru_RU": {"name_en": u"Russian", "name": u"Русский"},
    "sk_SK": {"name_en": u"Slovak", "name": u"Slovenčina"},
    "sl_SI": {"name_en": u"Slovenian", "name": u"Slovenščina"},
    "sq_AL": {"name_en": u"Albanian", "name": u"Shqip"},
    "sr_RS": {"name_en": u"Serbian", "name": u"Српски"},
    "sv_SE": {"name_en": u"Swedish", "name": u"Svenska"},
    "sw_KE": {"name_en": u"Swahili", "name": u"Kiswahili"},
    "ta_IN": {"name_en": u"Tamil", "name": u"தமிழ்"},
    "te_IN": {"name_en": u"Telugu", "name": u"తెలుగు"},
    "th_TH": {"name_en": u"Thai", "name": u"ภาษาไทย"},
    "tl_PH": {"name_en": u"Filipino", "name": u"Filipino"},
    "tr_TR": {"name_en": u"Turkish", "name": u"Türkçe"},
    "uk_UA": {"name_en": u"Ukraini ", "name": u"Українська"},
    "vi_VN": {"name_en": u"Vietnamese", "name": u"Tiếng Việt"},
    "zh_CN": {"name_en": u"Chinese (Simplified)", "name": u"中文(简体)"},
    "zh_TW": {"name_en": u"Chinese (Traditional)", "name": u"中文(繁體)"},
}
