(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/cipher#cipher::t
    (make-struct-type
     'std/crypto#cipher::t
     '#f
     '2
     'cipher
     '()
     ':init!
     '(type ctx)))
  (define std/crypto/cipher#cipher?
    (make-struct-predicate std/crypto/cipher#cipher::t))
  (define std/crypto/cipher#make-cipher
    (lambda _$args155277_
      (apply make-struct-instance std/crypto/cipher#cipher::t _$args155277_)))
  (define std/crypto/cipher#cipher-type
    (make-struct-field-accessor std/crypto/cipher#cipher::t '0))
  (define std/crypto/cipher#cipher-ctx
    (make-struct-field-accessor std/crypto/cipher#cipher::t '1))
  (define std/crypto/cipher#cipher-type-set!
    (make-struct-field-mutator std/crypto/cipher#cipher::t '0))
  (define std/crypto/cipher#cipher-ctx-set!
    (make-struct-field-mutator std/crypto/cipher#cipher::t '1))
  (define std/crypto/cipher#cipher:::init!
    (lambda (_self155272_ _type155273_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _type155273_)
          '#!void
          (error '"Invalid cipher" _type155273_))
      (let ((_ctx155275_ (std/crypto/libcrypto#EVP_CIPHER_CTX_create)))
        (if _ctx155275_ '#!void (error '"Failed to allocate cipher context"))
        (if (##fx< '2 (##vector-length _self155272_))
            (begin
              (##vector-set! _self155272_ '1 _type155273_)
              (##vector-set! _self155272_ '2 _ctx155275_))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self155272_)))))
  (bind-method!
   std/crypto/cipher#cipher::t
   ':init!
   std/crypto/cipher#cipher:::init!
   '#f)
  (define std/crypto/cipher#cipher-name
    (lambda (_cipher155148_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _cipher155148_)
          (std/crypto/libcrypto#EVP_CIPHER_name _cipher155148_)
          (std/crypto/libcrypto#EVP_CIPHER_name
           (##structure-ref
            _cipher155148_
            '1
            std/crypto/cipher#cipher::t
            '#f)))))
  (define std/crypto/cipher#cipher-block-size
    (lambda (_cipher155146_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _cipher155146_)
          (std/crypto/libcrypto#EVP_CIPHER_block_size _cipher155146_)
          (std/crypto/libcrypto#EVP_CIPHER_block_size
           (##structure-ref
            _cipher155146_
            '1
            std/crypto/cipher#cipher::t
            '#f)))))
  (define std/crypto/cipher#cipher-key-length
    (lambda (_cipher155144_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _cipher155144_)
          (std/crypto/libcrypto#EVP_CIPHER_key_length _cipher155144_)
          (std/crypto/libcrypto#EVP_CIPHER_key_length
           (##structure-ref
            _cipher155144_
            '1
            std/crypto/cipher#cipher::t
            '#f)))))
  (define std/crypto/cipher#cipher-iv-length
    (lambda (_cipher155142_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _cipher155142_)
          (std/crypto/libcrypto#EVP_CIPHER_iv_length _cipher155142_)
          (std/crypto/libcrypto#EVP_CIPHER_iv_length
           (##structure-ref
            _cipher155142_
            '1
            std/crypto/cipher#cipher::t
            '#f)))))
  (define std/crypto/cipher#cipher-copy
    (lambda (_cipher155132_)
      (let* ((_ctx155134_ (std/crypto/cipher#cipher-context _cipher155132_))
             (_copy155136_
              (let ((__obj155367 (make-object std/crypto/cipher#cipher::t '2)))
                (std/crypto/cipher#cipher:::init!
                 __obj155367
                 (##structure-ref
                  _cipher155132_
                  '1
                  std/crypto/cipher#cipher::t
                  '#f))
                __obj155367)))
        (let ((_res155139_
               (std/crypto/libcrypto#EVP_CIPHER_CTX_copy
                (##structure-ref
                 _copy155136_
                 '2
                 std/crypto/cipher#cipher::t
                 '#f)
                _ctx155134_)))
          (if (##fxzero? _res155139_)
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        _copy155136_)))
  (define std/crypto/cipher#cipher-context
    (lambda (_cipher155127_)
      (let ((_$e155129_
             (##structure-ref
              _cipher155127_
              '2
              std/crypto/cipher#cipher::t
              '#f)))
        (if _$e155129_
            _$e155129_
            (error '"Cipher has been finalized" _cipher155127_)))))
  (define std/crypto/cipher#cipher-check-key+iv-length
    (lambda (_cipher155123_ _key155124_ _iv155125_)
      (if (= (std/crypto/cipher#cipher-key-length
              (##structure-ref
               _cipher155123_
               '1
               std/crypto/cipher#cipher::t
               '#f))
             (u8vector-length _key155124_))
          '#!void
          (error '"Bad cipher key; key length mismatch"))
      (if (= (std/crypto/cipher#cipher-iv-length
              (##structure-ref
               _cipher155123_
               '1
               std/crypto/cipher#cipher::t
               '#f))
             (u8vector-length _iv155125_))
          '#!void
          (error '"Bad cipher iv; iv length mismatch"))))
  (define std/crypto/cipher#cipher-init!
    (lambda (_cipher155115_ _key155116_ _iv155117_ _EVP-init155118_)
      (std/crypto/cipher#cipher-check-key+iv-length
       _cipher155115_
       _key155116_
       _iv155117_)
      (let ((_res155120_
             (_EVP-init155118_
              (std/crypto/cipher#cipher-context _cipher155115_)
              (##structure-ref
               _cipher155115_
               '1
               std/crypto/cipher#cipher::t
               '#f)
              _key155116_
              _iv155117_)))
        (if (##fxzero? _res155120_)
            (apply std/crypto/etc#raise-libcrypto-error '())
            '#!void))))
  (define std/crypto/cipher#cipher-update!
    (lambda (_ctx155105_
             _out155106_
             _out-start155107_
             _in155108_
             _start155109_
             _end155110_
             _EVP-update155111_)
      (let ((_r155113_
             (_EVP-update155111_
              _ctx155105_
              _out155106_
              _out-start155107_
              _in155108_
              _start155109_
              _end155110_)))
        (if (not (##fxnegative? _r155113_))
            _r155113_
            (std/crypto/etc#raise-libcrypto-error _ctx155105_)))))
  (define std/crypto/cipher#cipher-final!
    (lambda (_ctx155098_ _out155099_ _out-start155100_ _EVP-final155101_)
      (let ((_r155103_
             (_EVP-final155101_ _ctx155098_ _out155099_ _out-start155100_)))
        (if (not (##fxnegative? _r155103_))
            _r155103_
            (std/crypto/etc#raise-libcrypto-error _ctx155098_)))))
  (define std/crypto/cipher#encrypt-init!
    (lambda (_cipher155094_ _key155095_ _iv155096_)
      (std/crypto/cipher#cipher-init!
       _cipher155094_
       _key155095_
       _iv155096_
       std/crypto/libcrypto#EVP_EncryptInit)))
  (define std/crypto/cipher#encrypt-update!
    (lambda (_cipher155087_
             _out155088_
             _out-start155089_
             _in155090_
             _start155091_
             _end155092_)
      (std/crypto/cipher#cipher-update!
       (std/crypto/cipher#cipher-context _cipher155087_)
       _out155088_
       _out-start155089_
       _in155090_
       _start155091_
       _end155092_
       std/crypto/libcrypto#EVP_EncryptUpdate)))
  (define std/crypto/cipher#encrypt-final!__%
    (lambda (_cipher155069_ _out155070_ _out-start155071_)
      (let ((_olen155073_
             (std/crypto/cipher#cipher-final!
              (std/crypto/cipher#cipher-context _cipher155069_)
              _out155070_
              _out-start155071_
              std/crypto/libcrypto#EVP_EncryptFinal)))
        (##structure-set!
         _cipher155069_
         '#f
         '2
         std/crypto/cipher#cipher::t
         '#f)
        _olen155073_)))
  (define std/crypto/cipher#encrypt-final!__0
    (lambda (_cipher155078_ _out155079_)
      (let ((_out-start155081_ '0))
        (std/crypto/cipher#encrypt-final!__%
         _cipher155078_
         _out155079_
         _out-start155081_))))
  (define std/crypto/cipher#encrypt-final!
    (lambda _g155413_
      (let ((_g155412_ (length _g155413_)))
        (cond ((##fx= _g155412_ 2)
               (apply std/crypto/cipher#encrypt-final!__0 _g155413_))
              ((##fx= _g155412_ 3)
               (apply std/crypto/cipher#encrypt-final!__% _g155413_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/cipher#encrypt-final!
                _g155413_))))))
  (define std/crypto/cipher#decrypt-init!
    (lambda (_cipher155064_ _key155065_ _iv155066_)
      (std/crypto/cipher#cipher-init!
       _cipher155064_
       _key155065_
       _iv155066_
       std/crypto/libcrypto#EVP_DecryptInit)))
  (define std/crypto/cipher#decrypt-update!
    (lambda (_cipher155057_
             _out155058_
             _out-start155059_
             _in155060_
             _start155061_
             _end155062_)
      (std/crypto/cipher#cipher-update!
       (std/crypto/cipher#cipher-context _cipher155057_)
       _out155058_
       _out-start155059_
       _in155060_
       _start155061_
       _end155062_
       std/crypto/libcrypto#EVP_DecryptUpdate)))
  (define std/crypto/cipher#decrypt-final!__%
    (lambda (_cipher155039_ _out155040_ _out-start155041_)
      (let ((_olen155043_
             (std/crypto/cipher#cipher-final!
              (std/crypto/cipher#cipher-context _cipher155039_)
              _out155040_
              _out-start155041_
              std/crypto/libcrypto#EVP_DecryptFinal)))
        (##structure-set!
         _cipher155039_
         '#f
         '2
         std/crypto/cipher#cipher::t
         '#f)
        _olen155043_)))
  (define std/crypto/cipher#decrypt-final!__0
    (lambda (_cipher155048_ _out155049_)
      (let ((_out-start155051_ '0))
        (std/crypto/cipher#decrypt-final!__%
         _cipher155048_
         _out155049_
         _out-start155051_))))
  (define std/crypto/cipher#decrypt-final!
    (lambda _g155415_
      (let ((_g155414_ (length _g155415_)))
        (cond ((##fx= _g155414_ 2)
               (apply std/crypto/cipher#decrypt-final!__0 _g155415_))
              ((##fx= _g155414_ 3)
               (apply std/crypto/cipher#decrypt-final!__% _g155415_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/cipher#decrypt-final!
                _g155415_))))))
  (define std/crypto/cipher#encrypt
    (lambda (_cipher155033_ _key155034_ _iv155035_ _in155036_)
      (if (string? _in155036_)
          (std/crypto/cipher#encrypt-u8vector__0
           _cipher155033_
           _key155034_
           _iv155035_
           (std/text/utf8#string->utf8__0 _in155036_))
          (if (u8vector? _in155036_)
              (std/crypto/cipher#encrypt-u8vector__0
               _cipher155033_
               _key155034_
               _iv155035_
               _in155036_)
              (if (input-port? _in155036_)
                  (std/crypto/cipher#encrypt-port
                   _cipher155033_
                   _key155034_
                   _iv155035_
                   _in155036_)
                  (error '"Bad input source" _in155036_))))))
  (define std/crypto/cipher#encrypt-u8vector__%
    (lambda (_cipher154979_
             _key154980_
             _iv154981_
             _in154982_
             _start154983_
             _end154984_)
      (let* ((_len154986_ (##fx- _end154984_ _start154983_))
             (_buflen154989_
              (##fx+ _len154986_
                     (##fx* '2
                            (std/crypto/cipher#cipher-block-size
                             _cipher154979_))))
             (_buf154992_ (make-u8vector _buflen154989_)))
        (std/crypto/cipher#encrypt-init! _cipher154979_ _key154980_ _iv154981_)
        (let* ((_ulen154996_
                (std/crypto/cipher#encrypt-update!
                 _cipher154979_
                 _buf154992_
                 '0
                 _in154982_
                 _start154983_
                 _end154984_))
               (_flen154999_
                (std/crypto/cipher#encrypt-final!__%
                 _cipher154979_
                 _buf154992_
                 _ulen154996_))
               (_olen155002_ (##fx+ _ulen154996_ _flen154999_)))
          (if (##fx< _olen155002_ _buflen154989_)
              (u8vector-shrink! _buf154992_ _olen155002_)
              '#!void)
          _buf154992_))))
  (define std/crypto/cipher#encrypt-u8vector__0
    (lambda (_cipher155009_ _key155010_ _iv155011_ _in155012_)
      (let* ((_start155014_ '0) (_end155016_ (u8vector-length _in155012_)))
        (std/crypto/cipher#encrypt-u8vector__%
         _cipher155009_
         _key155010_
         _iv155011_
         _in155012_
         _start155014_
         _end155016_))))
  (define std/crypto/cipher#encrypt-u8vector__1
    (lambda (_cipher155018_ _key155019_ _iv155020_ _in155021_ _start155022_)
      (let ((_end155024_ (u8vector-length _in155021_)))
        (std/crypto/cipher#encrypt-u8vector__%
         _cipher155018_
         _key155019_
         _iv155020_
         _in155021_
         _start155022_
         _end155024_))))
  (define std/crypto/cipher#encrypt-u8vector
    (lambda _g155417_
      (let ((_g155416_ (length _g155417_)))
        (cond ((##fx= _g155416_ 4)
               (apply std/crypto/cipher#encrypt-u8vector__0 _g155417_))
              ((##fx= _g155416_ 5)
               (apply std/crypto/cipher#encrypt-u8vector__1 _g155417_))
              ((##fx= _g155416_ 6)
               (apply std/crypto/cipher#encrypt-u8vector__% _g155417_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/cipher#encrypt-u8vector
                _g155417_))))))
  (define std/crypto/cipher#encrypt-u8vector!
    (lambda (_cipher154963_
             _key154964_
             _iv154965_
             _bytes154966_
             _start154967_
             _end154968_
             _buf154969_)
      (std/crypto/cipher#encrypt-init! _cipher154963_ _key154964_ _iv154965_)
      (let* ((_ulen154971_
              (std/crypto/cipher#encrypt-update!
               _cipher154963_
               _buf154969_
               '0
               _bytes154966_
               _start154967_
               _end154968_))
             (_flen154973_
              (std/crypto/cipher#encrypt-final!__%
               _cipher154963_
               _buf154969_
               _ulen154971_))
             (_olen154975_ (##fx+ _ulen154971_ _flen154973_)))
        _olen154975_)))
  (define std/crypto/cipher#encrypt-port
    (lambda (_cipher154927_ _key154928_ _iv154929_ _inp154930_)
      (let* ((_bufsz154932_ '1024)
             (_buf154935_
              (make-u8vector
               (##fx+ _bufsz154932_
                      (std/crypto/cipher#cipher-block-size _cipher154927_))))
             (_outp154938_ (open-output-u8vector)))
        (letrec ((_grow-buffer-if-needed154942_
                  (lambda (_ilen154957_)
                    (let ((_max-olen154960_
                           (##fx+ _ilen154957_
                                  (std/crypto/cipher#cipher-block-size
                                   _cipher154927_))))
                      (if (##fx> _max-olen154960_
                                 (u8vector-length _buf154935_))
                          (set! _buf154935_ (make-u8vector _max-olen154960_))
                          '#!void)))))
          (std/crypto/cipher#encrypt-init!
           _cipher154927_
           _key154928_
           _iv154929_)
          (std/crypto/etc#call-with-binary-input
           (lambda (_bytes154945_ _start154947_ _end154949_)
             (_grow-buffer-if-needed154942_ (- _end154949_ _start154947_))
             (let ((_olen154952_
                    (std/crypto/cipher#encrypt-update!
                     _cipher154927_
                     _buf154935_
                     '0
                     _bytes154945_
                     _start154947_
                     _end154949_)))
               (write-subu8vector _buf154935_ '0 _olen154952_ _outp154938_)))
           _inp154930_)
          (let ((_olen154955_
                 (std/crypto/cipher#encrypt-final!__0
                  _cipher154927_
                  _buf154935_)))
            (write-subu8vector _buf154935_ '0 _olen154955_ _outp154938_)
            (get-output-u8vector _outp154938_))))))
  (define std/crypto/cipher#decrypt
    (lambda (_cipher154922_ _key154923_ _iv154924_ _in154925_)
      (if (u8vector? _in154925_)
          (std/crypto/cipher#decrypt-u8vector__0
           _cipher154922_
           _key154923_
           _iv154924_
           _in154925_)
          (if (input-port? _in154925_)
              (std/crypto/cipher#decrypt-port
               _cipher154922_
               _key154923_
               _iv154924_
               _in154925_)
              (error '"Bad input source" _in154925_)))))
  (define std/crypto/cipher#decrypt-u8vector__%
    (lambda (_cipher154868_
             _key154869_
             _iv154870_
             _in154871_
             _start154872_
             _end154873_)
      (let* ((_len154875_ (##fx- _end154873_ _start154872_))
             (_buflen154878_
              (##fx+ _len154875_
                     (##fx* '2
                            (std/crypto/cipher#cipher-block-size
                             _cipher154868_))))
             (_buf154881_ (make-u8vector _buflen154878_)))
        (std/crypto/cipher#decrypt-init! _cipher154868_ _key154869_ _iv154870_)
        (let* ((_ulen154885_
                (std/crypto/cipher#decrypt-update!
                 _cipher154868_
                 _buf154881_
                 '0
                 _in154871_
                 _start154872_
                 _end154873_))
               (_flen154888_
                (std/crypto/cipher#decrypt-final!__%
                 _cipher154868_
                 _buf154881_
                 _ulen154885_))
               (_olen154891_ (##fx+ _ulen154885_ _flen154888_)))
          (if (##fx< _olen154891_ _buflen154878_)
              (u8vector-shrink! _buf154881_ _olen154891_)
              '#!void)
          _buf154881_))))
  (define std/crypto/cipher#decrypt-u8vector__0
    (lambda (_cipher154898_ _key154899_ _iv154900_ _in154901_)
      (let* ((_start154903_ '0) (_end154905_ (u8vector-length _in154901_)))
        (std/crypto/cipher#decrypt-u8vector__%
         _cipher154898_
         _key154899_
         _iv154900_
         _in154901_
         _start154903_
         _end154905_))))
  (define std/crypto/cipher#decrypt-u8vector__1
    (lambda (_cipher154907_ _key154908_ _iv154909_ _in154910_ _start154911_)
      (let ((_end154913_ (u8vector-length _in154910_)))
        (std/crypto/cipher#decrypt-u8vector__%
         _cipher154907_
         _key154908_
         _iv154909_
         _in154910_
         _start154911_
         _end154913_))))
  (define std/crypto/cipher#decrypt-u8vector
    (lambda _g155419_
      (let ((_g155418_ (length _g155419_)))
        (cond ((##fx= _g155418_ 4)
               (apply std/crypto/cipher#decrypt-u8vector__0 _g155419_))
              ((##fx= _g155418_ 5)
               (apply std/crypto/cipher#decrypt-u8vector__1 _g155419_))
              ((##fx= _g155418_ 6)
               (apply std/crypto/cipher#decrypt-u8vector__% _g155419_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/cipher#decrypt-u8vector
                _g155419_))))))
  (define std/crypto/cipher#decrypt-u8vector!
    (lambda (_cipher154852_
             _key154853_
             _iv154854_
             _bytes154855_
             _start154856_
             _end154857_
             _buf154858_)
      (std/crypto/cipher#decrypt-init! _cipher154852_ _key154853_ _iv154854_)
      (let* ((_ulen154860_
              (std/crypto/cipher#decrypt-update!
               _cipher154852_
               _buf154858_
               '0
               _bytes154855_
               _start154856_
               _end154857_))
             (_flen154862_
              (std/crypto/cipher#decrypt-final!__%
               _cipher154852_
               _buf154858_
               _ulen154860_))
             (_olen154864_ (##fx+ _ulen154860_ _flen154862_)))
        _olen154864_)))
  (define std/crypto/cipher#decrypt-port
    (lambda (_cipher154816_ _key154817_ _iv154818_ _inp154819_)
      (let* ((_bufsz154821_ '1024)
             (_buf154824_
              (make-u8vector
               (##fx+ _bufsz154821_
                      (std/crypto/cipher#cipher-block-size _cipher154816_))))
             (_outp154827_ (open-output-u8vector)))
        (letrec ((_grow-buffer-if-needed154831_
                  (lambda (_ilen154846_)
                    (let ((_max-olen154849_
                           (##fx+ _ilen154846_
                                  (std/crypto/cipher#cipher-block-size
                                   _cipher154816_))))
                      (if (##fx> _max-olen154849_
                                 (u8vector-length _buf154824_))
                          (set! _buf154824_ (make-u8vector _max-olen154849_))
                          '#!void)))))
          (std/crypto/cipher#decrypt-init!
           _cipher154816_
           _key154817_
           _iv154818_)
          (std/crypto/etc#call-with-binary-input
           (lambda (_bytes154834_ _start154836_ _end154838_)
             (_grow-buffer-if-needed154831_ (- _end154838_ _start154836_))
             (let ((_olen154841_
                    (std/crypto/cipher#decrypt-update!
                     _cipher154816_
                     _buf154824_
                     '0
                     _bytes154834_
                     _start154836_
                     _end154838_)))
               (write-subu8vector _buf154824_ '0 _olen154841_ _outp154827_)))
           _inp154819_)
          (let ((_olen154844_
                 (std/crypto/cipher#decrypt-final!__0
                  _cipher154816_
                  _buf154824_)))
            (write-subu8vector _buf154824_ '0 _olen154844_ _outp154827_)
            (get-output-u8vector _outp154827_))))))
  (define std/crypto/cipher#cipher::aes-128-ecb
    (std/crypto/libcrypto#EVP_aes_128_ecb))
  (define std/crypto/cipher#make-aes-128-ecb-cipher
    (lambda ()
      (let ((__obj155368 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155368
         std/crypto/cipher#cipher::aes-128-ecb)
        __obj155368)))
  (define std/crypto/cipher#aes-128-ecb-cipher?
    (lambda (_obj154813_)
      (if (##structure-instance-of? _obj154813_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154813_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-cbc
    (std/crypto/libcrypto#EVP_aes_128_cbc))
  (define std/crypto/cipher#make-aes-128-cbc-cipher
    (lambda ()
      (let ((__obj155369 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155369
         std/crypto/cipher#cipher::aes-128-cbc)
        __obj155369)))
  (define std/crypto/cipher#aes-128-cbc-cipher?
    (lambda (_obj154810_)
      (if (##structure-instance-of? _obj154810_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154810_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-cfb
    (std/crypto/libcrypto#EVP_aes_128_cfb))
  (define std/crypto/cipher#make-aes-128-cfb-cipher
    (lambda ()
      (let ((__obj155370 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155370
         std/crypto/cipher#cipher::aes-128-cfb)
        __obj155370)))
  (define std/crypto/cipher#aes-128-cfb-cipher?
    (lambda (_obj154807_)
      (if (##structure-instance-of? _obj154807_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154807_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-ofb
    (std/crypto/libcrypto#EVP_aes_128_ofb))
  (define std/crypto/cipher#make-aes-128-ofb-cipher
    (lambda ()
      (let ((__obj155371 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155371
         std/crypto/cipher#cipher::aes-128-ofb)
        __obj155371)))
  (define std/crypto/cipher#aes-128-ofb-cipher?
    (lambda (_obj154804_)
      (if (##structure-instance-of? _obj154804_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154804_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-ctr
    (std/crypto/libcrypto#EVP_aes_128_ctr))
  (define std/crypto/cipher#make-aes-128-ctr-cipher
    (lambda ()
      (let ((__obj155372 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155372
         std/crypto/cipher#cipher::aes-128-ctr)
        __obj155372)))
  (define std/crypto/cipher#aes-128-ctr-cipher?
    (lambda (_obj154801_)
      (if (##structure-instance-of? _obj154801_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154801_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-ctr))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-ccm
    (std/crypto/libcrypto#EVP_aes_128_ccm))
  (define std/crypto/cipher#make-aes-128-ccm-cipher
    (lambda ()
      (let ((__obj155373 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155373
         std/crypto/cipher#cipher::aes-128-ccm)
        __obj155373)))
  (define std/crypto/cipher#aes-128-ccm-cipher?
    (lambda (_obj154798_)
      (if (##structure-instance-of? _obj154798_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154798_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-ccm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-gcm
    (std/crypto/libcrypto#EVP_aes_128_gcm))
  (define std/crypto/cipher#make-aes-128-gcm-cipher
    (lambda ()
      (let ((__obj155374 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155374
         std/crypto/cipher#cipher::aes-128-gcm)
        __obj155374)))
  (define std/crypto/cipher#aes-128-gcm-cipher?
    (lambda (_obj154795_)
      (if (##structure-instance-of? _obj154795_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154795_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-gcm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-xts
    (std/crypto/libcrypto#EVP_aes_128_xts))
  (define std/crypto/cipher#make-aes-128-xts-cipher
    (lambda ()
      (let ((__obj155375 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155375
         std/crypto/cipher#cipher::aes-128-xts)
        __obj155375)))
  (define std/crypto/cipher#aes-128-xts-cipher?
    (lambda (_obj154791_)
      (if (##structure-instance-of? _obj154791_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154791_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-xts))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-ecb
    (std/crypto/libcrypto#EVP_aes_192_ecb))
  (define std/crypto/cipher#make-aes-192-ecb-cipher
    (lambda ()
      (let ((__obj155376 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155376
         std/crypto/cipher#cipher::aes-192-ecb)
        __obj155376)))
  (define std/crypto/cipher#aes-192-ecb-cipher?
    (lambda (_obj154788_)
      (if (##structure-instance-of? _obj154788_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154788_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-cbc
    (std/crypto/libcrypto#EVP_aes_192_cbc))
  (define std/crypto/cipher#make-aes-192-cbc-cipher
    (lambda ()
      (let ((__obj155377 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155377
         std/crypto/cipher#cipher::aes-192-cbc)
        __obj155377)))
  (define std/crypto/cipher#aes-192-cbc-cipher?
    (lambda (_obj154785_)
      (if (##structure-instance-of? _obj154785_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154785_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-cfb
    (std/crypto/libcrypto#EVP_aes_192_cfb))
  (define std/crypto/cipher#make-aes-192-cfb-cipher
    (lambda ()
      (let ((__obj155378 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155378
         std/crypto/cipher#cipher::aes-192-cfb)
        __obj155378)))
  (define std/crypto/cipher#aes-192-cfb-cipher?
    (lambda (_obj154782_)
      (if (##structure-instance-of? _obj154782_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154782_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-ofb
    (std/crypto/libcrypto#EVP_aes_192_ofb))
  (define std/crypto/cipher#make-aes-192-ofb-cipher
    (lambda ()
      (let ((__obj155379 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155379
         std/crypto/cipher#cipher::aes-192-ofb)
        __obj155379)))
  (define std/crypto/cipher#aes-192-ofb-cipher?
    (lambda (_obj154779_)
      (if (##structure-instance-of? _obj154779_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154779_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-ctr
    (std/crypto/libcrypto#EVP_aes_192_ctr))
  (define std/crypto/cipher#make-aes-192-ctr-cipher
    (lambda ()
      (let ((__obj155380 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155380
         std/crypto/cipher#cipher::aes-192-ctr)
        __obj155380)))
  (define std/crypto/cipher#aes-192-ctr-cipher?
    (lambda (_obj154776_)
      (if (##structure-instance-of? _obj154776_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154776_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-ctr))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-ccm
    (std/crypto/libcrypto#EVP_aes_192_ccm))
  (define std/crypto/cipher#make-aes-192-ccm-cipher
    (lambda ()
      (let ((__obj155381 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155381
         std/crypto/cipher#cipher::aes-192-ccm)
        __obj155381)))
  (define std/crypto/cipher#aes-192-ccm-cipher?
    (lambda (_obj154773_)
      (if (##structure-instance-of? _obj154773_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154773_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-ccm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-gcm
    (std/crypto/libcrypto#EVP_aes_192_gcm))
  (define std/crypto/cipher#make-aes-192-gcm-cipher
    (lambda ()
      (let ((__obj155382 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155382
         std/crypto/cipher#cipher::aes-192-gcm)
        __obj155382)))
  (define std/crypto/cipher#aes-192-gcm-cipher?
    (lambda (_obj154769_)
      (if (##structure-instance-of? _obj154769_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154769_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-gcm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-ecb
    (std/crypto/libcrypto#EVP_aes_256_ecb))
  (define std/crypto/cipher#make-aes-256-ecb-cipher
    (lambda ()
      (let ((__obj155383 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155383
         std/crypto/cipher#cipher::aes-256-ecb)
        __obj155383)))
  (define std/crypto/cipher#aes-256-ecb-cipher?
    (lambda (_obj154766_)
      (if (##structure-instance-of? _obj154766_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154766_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-cbc
    (std/crypto/libcrypto#EVP_aes_256_cbc))
  (define std/crypto/cipher#make-aes-256-cbc-cipher
    (lambda ()
      (let ((__obj155384 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155384
         std/crypto/cipher#cipher::aes-256-cbc)
        __obj155384)))
  (define std/crypto/cipher#aes-256-cbc-cipher?
    (lambda (_obj154763_)
      (if (##structure-instance-of? _obj154763_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154763_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-cfb
    (std/crypto/libcrypto#EVP_aes_256_cfb))
  (define std/crypto/cipher#make-aes-256-cfb-cipher
    (lambda ()
      (let ((__obj155385 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155385
         std/crypto/cipher#cipher::aes-256-cfb)
        __obj155385)))
  (define std/crypto/cipher#aes-256-cfb-cipher?
    (lambda (_obj154760_)
      (if (##structure-instance-of? _obj154760_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154760_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-ofb
    (std/crypto/libcrypto#EVP_aes_256_ofb))
  (define std/crypto/cipher#make-aes-256-ofb-cipher
    (lambda ()
      (let ((__obj155386 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155386
         std/crypto/cipher#cipher::aes-256-ofb)
        __obj155386)))
  (define std/crypto/cipher#aes-256-ofb-cipher?
    (lambda (_obj154757_)
      (if (##structure-instance-of? _obj154757_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154757_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-ctr
    (std/crypto/libcrypto#EVP_aes_256_ctr))
  (define std/crypto/cipher#make-aes-256-ctr-cipher
    (lambda ()
      (let ((__obj155387 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155387
         std/crypto/cipher#cipher::aes-256-ctr)
        __obj155387)))
  (define std/crypto/cipher#aes-256-ctr-cipher?
    (lambda (_obj154754_)
      (if (##structure-instance-of? _obj154754_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154754_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-ctr))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-ccm
    (std/crypto/libcrypto#EVP_aes_256_ccm))
  (define std/crypto/cipher#make-aes-256-ccm-cipher
    (lambda ()
      (let ((__obj155388 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155388
         std/crypto/cipher#cipher::aes-256-ccm)
        __obj155388)))
  (define std/crypto/cipher#aes-256-ccm-cipher?
    (lambda (_obj154751_)
      (if (##structure-instance-of? _obj154751_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154751_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-ccm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-gcm
    (std/crypto/libcrypto#EVP_aes_256_gcm))
  (define std/crypto/cipher#make-aes-256-gcm-cipher
    (lambda ()
      (let ((__obj155389 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155389
         std/crypto/cipher#cipher::aes-256-gcm)
        __obj155389)))
  (define std/crypto/cipher#aes-256-gcm-cipher?
    (lambda (_obj154748_)
      (if (##structure-instance-of? _obj154748_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154748_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-gcm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-xts
    (std/crypto/libcrypto#EVP_aes_256_xts))
  (define std/crypto/cipher#make-aes-256-xts-cipher
    (lambda ()
      (let ((__obj155390 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155390
         std/crypto/cipher#cipher::aes-256-xts)
        __obj155390)))
  (define std/crypto/cipher#aes-256-xts-cipher?
    (lambda (_obj154744_)
      (if (##structure-instance-of? _obj154744_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154744_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-xts))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-128-ecb
    (std/crypto/libcrypto#EVP_camellia_128_ecb))
  (define std/crypto/cipher#make-camellia-128-ecb-cipher
    (lambda ()
      (let ((__obj155391 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155391
         std/crypto/cipher#cipher::camellia-128-ecb)
        __obj155391)))
  (define std/crypto/cipher#camellia-128-ecb-cipher?
    (lambda (_obj154741_)
      (if (##structure-instance-of? _obj154741_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154741_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-128-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-128-cbc
    (std/crypto/libcrypto#EVP_camellia_128_cbc))
  (define std/crypto/cipher#make-camellia-128-cbc-cipher
    (lambda ()
      (let ((__obj155392 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155392
         std/crypto/cipher#cipher::camellia-128-cbc)
        __obj155392)))
  (define std/crypto/cipher#camellia-128-cbc-cipher?
    (lambda (_obj154738_)
      (if (##structure-instance-of? _obj154738_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154738_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-128-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-128-cfb
    (std/crypto/libcrypto#EVP_camellia_128_cfb))
  (define std/crypto/cipher#make-camellia-128-cfb-cipher
    (lambda ()
      (let ((__obj155393 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155393
         std/crypto/cipher#cipher::camellia-128-cfb)
        __obj155393)))
  (define std/crypto/cipher#camellia-128-cfb-cipher?
    (lambda (_obj154735_)
      (if (##structure-instance-of? _obj154735_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154735_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-128-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-128-ofb
    (std/crypto/libcrypto#EVP_camellia_128_ofb))
  (define std/crypto/cipher#make-camellia-128-ofb-cipher
    (lambda ()
      (let ((__obj155394 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155394
         std/crypto/cipher#cipher::camellia-128-ofb)
        __obj155394)))
  (define std/crypto/cipher#camellia-128-ofb-cipher?
    (lambda (_obj154731_)
      (if (##structure-instance-of? _obj154731_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154731_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-128-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-192-ecb
    (std/crypto/libcrypto#EVP_camellia_192_ecb))
  (define std/crypto/cipher#make-camellia-192-ecb-cipher
    (lambda ()
      (let ((__obj155395 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155395
         std/crypto/cipher#cipher::camellia-192-ecb)
        __obj155395)))
  (define std/crypto/cipher#camellia-192-ecb-cipher?
    (lambda (_obj154728_)
      (if (##structure-instance-of? _obj154728_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154728_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-192-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-192-cbc
    (std/crypto/libcrypto#EVP_camellia_192_cbc))
  (define std/crypto/cipher#make-camellia-192-cbc-cipher
    (lambda ()
      (let ((__obj155396 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155396
         std/crypto/cipher#cipher::camellia-192-cbc)
        __obj155396)))
  (define std/crypto/cipher#camellia-192-cbc-cipher?
    (lambda (_obj154725_)
      (if (##structure-instance-of? _obj154725_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154725_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-192-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-192-cfb
    (std/crypto/libcrypto#EVP_camellia_192_cfb))
  (define std/crypto/cipher#make-camellia-192-cfb-cipher
    (lambda ()
      (let ((__obj155397 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155397
         std/crypto/cipher#cipher::camellia-192-cfb)
        __obj155397)))
  (define std/crypto/cipher#camellia-192-cfb-cipher?
    (lambda (_obj154722_)
      (if (##structure-instance-of? _obj154722_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154722_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-192-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-192-ofb
    (std/crypto/libcrypto#EVP_camellia_192_ofb))
  (define std/crypto/cipher#make-camellia-192-ofb-cipher
    (lambda ()
      (let ((__obj155398 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155398
         std/crypto/cipher#cipher::camellia-192-ofb)
        __obj155398)))
  (define std/crypto/cipher#camellia-192-ofb-cipher?
    (lambda (_obj154718_)
      (if (##structure-instance-of? _obj154718_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154718_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-192-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-256-ecb
    (std/crypto/libcrypto#EVP_camellia_256_ecb))
  (define std/crypto/cipher#make-camellia-256-ecb-cipher
    (lambda ()
      (let ((__obj155399 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155399
         std/crypto/cipher#cipher::camellia-256-ecb)
        __obj155399)))
  (define std/crypto/cipher#camellia-256-ecb-cipher?
    (lambda (_obj154715_)
      (if (##structure-instance-of? _obj154715_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154715_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-256-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-256-cbc
    (std/crypto/libcrypto#EVP_camellia_256_cbc))
  (define std/crypto/cipher#make-camellia-256-cbc-cipher
    (lambda ()
      (let ((__obj155400 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155400
         std/crypto/cipher#cipher::camellia-256-cbc)
        __obj155400)))
  (define std/crypto/cipher#camellia-256-cbc-cipher?
    (lambda (_obj154712_)
      (if (##structure-instance-of? _obj154712_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154712_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-256-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-256-cfb
    (std/crypto/libcrypto#EVP_camellia_256_cfb))
  (define std/crypto/cipher#make-camellia-256-cfb-cipher
    (lambda ()
      (let ((__obj155401 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155401
         std/crypto/cipher#cipher::camellia-256-cfb)
        __obj155401)))
  (define std/crypto/cipher#camellia-256-cfb-cipher?
    (lambda (_obj154709_)
      (if (##structure-instance-of? _obj154709_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154709_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-256-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-256-ofb
    (std/crypto/libcrypto#EVP_camellia_256_ofb))
  (define std/crypto/cipher#make-camellia-256-ofb-cipher
    (lambda ()
      (let ((__obj155402 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155402
         std/crypto/cipher#cipher::camellia-256-ofb)
        __obj155402)))
  (define std/crypto/cipher#camellia-256-ofb-cipher?
    (lambda (_obj154705_)
      (if (##structure-instance-of? _obj154705_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154705_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-256-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::cast5-ecb
    (std/crypto/libcrypto#EVP_cast5_ecb))
  (define std/crypto/cipher#make-cast5-ecb-cipher
    (lambda ()
      (let ((__obj155403 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155403
         std/crypto/cipher#cipher::cast5-ecb)
        __obj155403)))
  (define std/crypto/cipher#cast5-ecb-cipher?
    (lambda (_obj154702_)
      (if (##structure-instance-of? _obj154702_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154702_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::cast5-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::cast5-cbc
    (std/crypto/libcrypto#EVP_cast5_cbc))
  (define std/crypto/cipher#make-cast5-cbc-cipher
    (lambda ()
      (let ((__obj155404 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155404
         std/crypto/cipher#cipher::cast5-cbc)
        __obj155404)))
  (define std/crypto/cipher#cast5-cbc-cipher?
    (lambda (_obj154699_)
      (if (##structure-instance-of? _obj154699_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154699_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::cast5-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::cast5-cfb
    (std/crypto/libcrypto#EVP_cast5_cfb))
  (define std/crypto/cipher#make-cast5-cfb-cipher
    (lambda ()
      (let ((__obj155405 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155405
         std/crypto/cipher#cipher::cast5-cfb)
        __obj155405)))
  (define std/crypto/cipher#cast5-cfb-cipher?
    (lambda (_obj154696_)
      (if (##structure-instance-of? _obj154696_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154696_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::cast5-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::cast5-ofb
    (std/crypto/libcrypto#EVP_cast5_ofb))
  (define std/crypto/cipher#make-cast5-ofb-cipher
    (lambda ()
      (let ((__obj155406 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155406
         std/crypto/cipher#cipher::cast5-ofb)
        __obj155406)))
  (define std/crypto/cipher#cast5-ofb-cipher?
    (lambda (_obj154692_)
      (if (##structure-instance-of? _obj154692_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154692_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::cast5-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::bf-ecb (std/crypto/libcrypto#EVP_bf_ecb))
  (define std/crypto/cipher#make-bf-ecb-cipher
    (lambda ()
      (let ((__obj155407 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155407
         std/crypto/cipher#cipher::bf-ecb)
        __obj155407)))
  (define std/crypto/cipher#bf-ecb-cipher?
    (lambda (_obj154689_)
      (if (##structure-instance-of? _obj154689_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154689_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::bf-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::bf-cbc (std/crypto/libcrypto#EVP_bf_cbc))
  (define std/crypto/cipher#make-bf-cbc-cipher
    (lambda ()
      (let ((__obj155408 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155408
         std/crypto/cipher#cipher::bf-cbc)
        __obj155408)))
  (define std/crypto/cipher#bf-cbc-cipher?
    (lambda (_obj154686_)
      (if (##structure-instance-of? _obj154686_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154686_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::bf-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::bf-cfb (std/crypto/libcrypto#EVP_bf_cfb))
  (define std/crypto/cipher#make-bf-cfb-cipher
    (lambda ()
      (let ((__obj155409 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155409
         std/crypto/cipher#cipher::bf-cfb)
        __obj155409)))
  (define std/crypto/cipher#bf-cfb-cipher?
    (lambda (_obj154683_)
      (if (##structure-instance-of? _obj154683_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154683_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::bf-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::bf-ofb (std/crypto/libcrypto#EVP_bf_ofb))
  (define std/crypto/cipher#make-bf-ofb-cipher
    (lambda ()
      (let ((__obj155410 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155410
         std/crypto/cipher#cipher::bf-ofb)
        __obj155410)))
  (define std/crypto/cipher#bf-ofb-cipher?
    (lambda (_obj154679_)
      (if (##structure-instance-of? _obj154679_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154679_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::bf-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::rc4 (std/crypto/libcrypto#EVP_rc4))
  (define std/crypto/cipher#make-rc4-cipher
    (lambda ()
      (let ((__obj155411 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj155411
         std/crypto/cipher#cipher::rc4)
        __obj155411)))
  (define std/crypto/cipher#rc4-cipher?
    (lambda (_obj154675_)
      (if (##structure-instance-of? _obj154675_ 'std/crypto#cipher::t)
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref
                 _obj154675_
                 '1
                 std/crypto/cipher#cipher::t
                 '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::rc4))
          '#f))))
