(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/dh#with-null-check
    (lambda (_makef155999_)
      (let ((_$e156001_ (_makef155999_)))
        (if _$e156001_
            _$e156001_
            (error '"error allocating key; NULL POINTER")))))
  (define std/crypto/dh#DH-get-1024-160
    (lambda ()
      (std/crypto/dh#with-null-check std/crypto/libcrypto#DH_get_1024_160)))
  (define std/crypto/dh#DH-get-2048-224
    (lambda ()
      (std/crypto/dh#with-null-check std/crypto/libcrypto#DH_get_2048_224)))
  (define std/crypto/dh#DH-get-2048-256
    (lambda ()
      (std/crypto/dh#with-null-check std/crypto/libcrypto#DH_get_2048_256)))
  (define std/crypto/dh#DH-generate-key
    (lambda (_dh155991_)
      (let ((_res155993_ (std/crypto/libcrypto#DH_generate_key _dh155991_)))
        (if (##fxzero? _res155993_)
            (apply std/crypto/etc#raise-libcrypto-error '())
            '#!void))))
  (define std/crypto/dh#DH-compute-key
    (lambda (_dh155981_ _bn155982_)
      (let* ((_len155984_ (std/crypto/libcrypto#DH_size _dh155981_))
             (_secret155986_ (make-u8vector _len155984_))
             (_count155988_
              (std/crypto/libcrypto#DH_compute_key
               _secret155986_
               _bn155982_
               _dh155981_)))
        (if (##fx< _count155988_ _len155984_)
            (u8vector-shrink! _secret155986_ _count155988_)
            '#!void)
        _secret155986_))))
