(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/web/fastcgi#fastcgi-request::t
    (make-struct-type
     'std/web/fastcgi#fastcgi-request::t
     '#f
     '6
     'fastcgi-request
     '()
     '#f
     '(port id keepalive role params stdin)))
  (define std/web/fastcgi#fastcgi-request?
    (make-struct-predicate std/web/fastcgi#fastcgi-request::t))
  (define std/web/fastcgi#make-fastcgi-request
    (lambda _$args208224_
      (apply make-struct-instance
             std/web/fastcgi#fastcgi-request::t
             _$args208224_)))
  (define std/web/fastcgi#fastcgi-request-port
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '0))
  (define std/web/fastcgi#fastcgi-request-id
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '1))
  (define std/web/fastcgi#fastcgi-request-keepalive
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '2))
  (define std/web/fastcgi#fastcgi-request-role
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '3))
  (define std/web/fastcgi#fastcgi-request-params
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '4))
  (define std/web/fastcgi#fastcgi-request-stdin
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '5))
  (define std/web/fastcgi#fastcgi-request-port-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '0))
  (define std/web/fastcgi#fastcgi-request-id-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '1))
  (define std/web/fastcgi#fastcgi-request-keepalive-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '2))
  (define std/web/fastcgi#fastcgi-request-role-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '3))
  (define std/web/fastcgi#fastcgi-request-params-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '4))
  (define std/web/fastcgi#fastcgi-request-stdin-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '5))
  (define std/web/fastcgi#start-fastcgi-server!
    (lambda (_address208221_ _respond208222_)
      (std/logger#start-logger!__0)
      (gerbil/gambit/threads#spawn
       std/web/fastcgi#fastcgi-server
       (open-tcp-server (std/net/address#inet-address->string _address208221_))
       _respond208222_)))
  (define std/web/fastcgi#fastcgi-server
    (lambda (_sock208206_ _respond208207_)
      (let _lp208209_ ()
        (with-exception-catcher
         (lambda (_g208211208213_)
           (if '#t
               (let ((_e208216_ _g208211208213_))
                 (std/logger#log-error
                  '"error accepting connection"
                  _e208216_))
               (raise _g208211208213_)))
         (lambda ()
           (let ((_client208219_ (read _sock208206_)))
             (gerbil/gambit/threads#spawn
              std/web/fastcgi#fastcgi-connection
              _client208219_
              _respond208207_))))
        (_lp208209_))))
  (define std/web/fastcgi#fastcgi-connection
    (lambda (_port208188_ _respond208189_)
      (letrec ((_loop208191_
                (lambda ()
                  (let ((_req208204_
                         (std/web/fastcgi#fastcgi-accept _port208188_)))
                    (if (eof-object? _req208204_)
                        '#!void
                        (if (eq? (##structure-ref
                                  _req208204_
                                  '4
                                  std/web/fastcgi#fastcgi-request::t
                                  '#f)
                                 'FCGI-RESPONDER)
                            (begin
                              (_respond208189_ _req208204_)
                              (std/web/fastcgi#fastcgi-request-end__0
                               _req208204_)
                              (if (##structure-ref
                                   _req208204_
                                   '3
                                   std/web/fastcgi#fastcgi-request::t
                                   '#f)
                                  (_loop208191_)
                                  '#!void))
                            (begin
                              (std/web/fastcgi#fastcgi-request-end__%
                               _req208204_
                               '1
                               std/web/fastcgi#FCGI-UNKNOWN-ROLE)
                              (if (##structure-ref
                                   _req208204_
                                   '3
                                   std/web/fastcgi#fastcgi-request::t
                                   '#f)
                                  (_loop208191_)
                                  '#!void))))))))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g208192208195_)
              (if '#t
                  (let ((_e208198_ _g208192208195_))
                    (std/logger#log-error '"error responding" _e208198_))
                  (raise _g208192208195_)))
            (lambda () (_loop208191_))))
         (lambda ()
           (with-exception-catcher
            void
            (lambda () (close-port _port208188_))))))))
  (define std/web/fastcgi#fastcgi-accept
    (lambda (_port207965_)
      (letrec ((_begin-request207967_
                (lambda (_port208079_)
                  (let* ((_g208080208090_
                          (std/web/fastcgi#fcgi-read-record _port208079_))
                         (_E208083208094_
                          (lambda ()
                            (error '"No clause matching" _g208080208090_))))
                    (let ((_K208085208170_
                           (lambda (_body208108_ _reqid208109_ _type208110_)
                             (if (eq? _type208110_
                                      std/web/fastcgi#FCGI-BEGIN-REQUEST)
                                 (let ((_g208248_
                                        (std/web/fastcgi#fcgi-begin-request-e
                                         _body208108_)))
                                   (begin
                                     (let ((_g208249_
                                            (if (##values? _g208248_)
                                                (##vector-length _g208248_)
                                                1)))
                                       (if (not (##fx= _g208249_ 2))
                                           (error "Context expects 2 values"
                                                  _g208249_)))
                                     (let ((_role208112_
                                            (##vector-ref _g208248_ 0))
                                           (_flags208113_
                                            (##vector-ref _g208248_ 1)))
                                       (let ((_keepalive208115_
                                              (not (zero? (fxand _flags208113_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         std/web/fastcgi#FCGI-KEEP-CONN)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                         (_receive-request-data207968_
                                          _port208079_
                                          _reqid208109_
                                          _keepalive208115_
                                          _role208112_)))))
                                 (if (eq? _type208110_
                                          std/web/fastcgi#FCGI-GET-VALUES)
                                     (let* ((_keys208118_
                                             (std/web/fastcgi#fcgi-get-values-e
                                              _body208108_))
                                            (_resp208165_
                                             (let ((_iterable208145_
                                                    _keys208118_)
                                                   (_iter-do208147_
                                                    (lambda (_val208120_
                                                             _r208122_)
                                                      (let* ((_val208123208128_
                                                              _val208120_)
                                                             (_E208125208132_
                                                              (lambda ()
                                                                (error '"No clause matching"
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                               _val208123208128_)))
                     (_K208126208140_
                      (lambda (_key208135_)
                        (let ((_$e208137_ _key208135_))
                          (if (eq? 'FCGI_MAX_CONNS _$e208137_)
                              (cons (cons _key208135_ '"1") _r208122_)
                              (if (eq? 'FCGI_MAX_REQS _$e208137_)
                                  (cons (cons _key208135_ '"1") _r208122_)
                                  (if (eq? 'FCGI_MPXS_CONNS _$e208137_)
                                      (cons (cons _key208135_ '"0") _r208122_)
                                      _r208122_))))))
                     (_key208143_ _val208123208128_))
                (_K208126208140_ _key208143_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (_r208149_ '()))
                                               (if (pair? _iterable208145_)
                                                   (foldl1 _iter-do208147_
                                                           _r208149_
                                                           _iterable208145_)
                                                   (if (null? _iterable208145_)
                                                       _r208149_
                                                       (let ((_it208151_
                                                              (std/iter#iter
                                                               _iterable208145_)))
                                                         (let _lp208154_ ((_rval208157_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                   _r208149_))
                   (let ((_val208160_ (std/iter#iter-next! _it208151_)))
                     (if (eq? std/iter#iter-end _val208160_)
                         (begin (std/iter#iter-fini! _it208151_) _rval208157_)
                         (let ((_xval208162_
                                (_iter-do208147_ _val208160_ _rval208157_)))
                           (_lp208154_ _xval208162_))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                            (_data208167_
                                             (std/web/fastcgi#fcgi-get-values-result-data
                                              _resp208165_)))
                                       (std/web/fastcgi#fcgi-write-record__0
                                        _port208079_
                                        std/web/fastcgi#FCGI-GET-VALUES-RESULT
                                        _reqid208109_
                                        _data208167_)
                                       (_begin-request207967_ _port208079_))
                                     (if (eq? _reqid208109_ '0)
                                         (begin
                                           (std/web/fastcgi#fcgi-write-record__0
                                            _port208079_
                                            std/web/fastcgi#FCGI-UNKNOWN-TYPE
                                            _reqid208109_
                                            (std/web/fastcgi#fcgi-unknown-type-data
                                             _type208110_))
                                           (_begin-request207967_
                                            _port208079_))
                                         (begin
                                           (std/logger#warning
                                            '"fastcgi-accept: unexpected message type ~a"
                                            _type208110_)
                                           (_begin-request207967_
                                            _port208079_)))))))
                          (_K208084208100_ (lambda (_eof208098_) _eof208098_)))
                      (let ((_try-match208082208105_
                             (lambda ()
                               (if (eof-object? _g208080208090_)
                                   (let ((_eof208103_ _g208080208090_))
                                     (_K208084208100_ _eof208103_))
                                   (_E208083208094_)))))
                        (if (##fx= (if (##values? _g208080208090_)
                                       (##vector-length _g208080208090_)
                                       '1)
                                   '3)
                            (let* ((_e208086208173_
                                    (##vector-ref _g208080208090_ '0))
                                   (_e208087208178_
                                    (##vector-ref _g208080208090_ '1))
                                   (_e208088208183_
                                    (##vector-ref _g208080208090_ '2)))
                              (let ((_type208176_ _e208086208173_)
                                    (_reqid208181_ _e208087208178_)
                                    (_body208186_ _e208088208183_))
                                (_K208085208170_
                                 _body208186_
                                 _reqid208181_
                                 _type208176_)))
                            (_try-match208082208105_)))))))
               (_receive-request-data207968_
                (lambda (_port207970_
                         _id207971_
                         _keepalive207972_
                         _role207973_)
                  (letrec* ((_params207975_ (make-table 'test: eq?)))
                    (let _lp207977_ ((_end-params207979_ '#f)
                                     (_end-stdin207980_ '#f)
                                     (_stdin207981_ '()))
                      (if (and _end-params207979_ _end-stdin207980_)
                          (##structure
                           std/web/fastcgi#fastcgi-request::t
                           _port207970_
                           _id207971_
                           _keepalive207972_
                           _role207973_
                           _params207975_
                           (append-u8vectors (reverse _stdin207981_)))
                          (let* ((_g207982207992_
                                  (std/web/fastcgi#fcgi-read-record
                                   _port207970_))
                                 (_E207985207996_
                                  (lambda ()
                                    (error '"No clause matching"
                                           _g207982207992_))))
                            (let ((_K207987208061_
                                   (lambda (_body208007_
                                            _reqid208008_
                                            _type208009_)
                                     (if (eq? _reqid208008_ _id207971_)
                                         (if (eq? _type208009_
                                                  std/web/fastcgi#FCGI-PARAMS)
                                             (if (zero? (u8vector-length
                                                         _body208007_))
                                                 (_lp207977_
                                                  '#t
                                                  _end-stdin207980_
                                                  _stdin207981_)
                                                 (let ((_alist208011_
                                                        (std/web/fastcgi#fcgi-params-e
                                                         _body208007_)))
                                                   (let ((_iterable208044_
                                                          _alist208011_)
                                                         (_iter-do208046_
                                                          (lambda (_val208013_)
                                                            (let* ((_val208015208022_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _val208013_)
                           (_E208017208026_
                            (lambda ()
                              (error '"No clause matching" _val208015208022_)))
                           (_K208018208032_
                            (lambda (_value208029_ _key208030_)
                              (table-set!
                               _params207975_
                               _key208030_
                               _value208029_))))
                      (if (##pair? _val208015208022_)
                          (let ((_hd208019208035_ (##car _val208015208022_))
                                (_tl208020208037_ (##cdr _val208015208022_)))
                            (let* ((_key208040_ _hd208019208035_)
                                   (_value208042_ _tl208020208037_))
                              (_K208018208032_ _value208042_ _key208040_)))
                          (_E208017208026_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (if (pair? _iterable208044_)
                                                         (for-each
                                                          _iter-do208046_
                                                          _iterable208044_)
                                                         (let ((_$e208049_
                                                                (null? _iterable208044_)))
                                                           (if _$e208049_
                                                               _$e208049_
                                                               (let ((_it208052_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              (std/iter#iter _iterable208044_)))
                         (let _lp208055_ ()
                           (let ((_val208059_
                                  (std/iter#iter-next! _it208052_)))
                             (if (eq? std/iter#iter-end _val208059_)
                                 '#!void
                                 (begin
                                   (_iter-do208046_ _val208059_)
                                   (_lp208055_)))))
                         (std/iter#iter-fini! _it208052_)
                         '#!void)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (_lp207977_
                                                    '#f
                                                    _end-stdin207980_
                                                    _stdin207981_)))
                                             (if (eq? _type208009_
                                                      std/web/fastcgi#FCGI-STDIN)
                                                 (if (zero? (u8vector-length
                                                             _body208007_))
                                                     (_lp207977_
                                                      _end-params207979_
                                                      '#t
                                                      _stdin207981_)
                                                     (_lp207977_
                                                      _end-params207979_
                                                      '#f
                                                      (cons _body208007_
                                                            _stdin207981_)))
                                                 (if (eq? _type208009_
                                                          std/web/fastcgi#FCGI-ABORT-REQUEST)
                                                     (std/error#raise-io-error
                                                      'fastcgi-accept
                                                      '"Connection aborted")
                                                     (begin
                                                       (std/logger#warning
                                                        '"fastcgi-accept: unexpected message type ~a"
                                                        _type208009_)
                                                       (_lp207977_
                                                        _end-params207979_
                                                        _end-stdin207980_
                                                        _stdin207981_)))))
                                         (begin
                                           (std/logger#warning
                                            '"fastcgi-accept: unexpected message request ~a"
                                            _reqid208008_)
                                           (_lp207977_
                                            _end-params207979_
                                            _end-stdin207980_
                                            _stdin207981_)))))
                                  (_K207986208001_
                                   (lambda ()
                                     (std/error#raise-io-error
                                      'fastcgi-accept
                                      '"Premature port end"
                                      _port207970_))))
                              (let ((_try-match207984208004_
                                     (lambda ()
                                       (if (eof-object? _g207982207992_)
                                           (_K207986208001_)
                                           (_E207985207996_)))))
                                (if (##fx= (if (##values? _g207982207992_)
                                               (##vector-length
                                                _g207982207992_)
                                               '1)
                                           '3)
                                    (let* ((_e207988208064_
                                            (##vector-ref _g207982207992_ '0))
                                           (_e207989208069_
                                            (##vector-ref _g207982207992_ '1))
                                           (_e207990208074_
                                            (##vector-ref _g207982207992_ '2)))
                                      (let ((_type208067_ _e207988208064_)
                                            (_reqid208072_ _e207989208069_)
                                            (_body208077_ _e207990208074_))
                                        (_K207987208061_
                                         _body208077_
                                         _reqid208072_
                                         _type208067_)))
                                    (_try-match207984208004_)))))))))))
        (_begin-request207967_ _port207965_))))
  (define std/web/fastcgi#fastcgi-write-stdout
    (lambda (_req207933_ _data207934_)
      (let* ((_req207935207942_ _req207933_)
             (_E207937207946_
              (lambda () (error '"No clause matching" _req207935207942_)))
             (_K207938207952_
              (lambda (_reqid207949_ _port207950_)
                (if _port207950_
                    (std/web/fastcgi#fcgi-write-data
                     _port207950_
                     std/web/fastcgi#FCGI-STDOUT
                     _reqid207949_
                     _data207934_)
                    (error '"request ended; no port" _req207933_)))))
        (if (##structure-instance-of?
             _req207935207942_
             'std/web/fastcgi#fastcgi-request::t)
            (let* ((_e207939207955_ (##vector-ref _req207935207942_ '1))
                   (_port207958_ _e207939207955_)
                   (_e207940207960_ (##vector-ref _req207935207942_ '2))
                   (_reqid207963_ _e207940207960_))
              (_K207938207952_ _reqid207963_ _port207958_))
            (_E207937207946_)))))
  (define std/web/fastcgi#fastcgi-write-stderr
    (lambda (_req207901_ _data207902_)
      (let* ((_req207903207910_ _req207901_)
             (_E207905207914_
              (lambda () (error '"No clause matching" _req207903207910_)))
             (_K207906207920_
              (lambda (_reqid207917_ _port207918_)
                (if _port207918_
                    (std/web/fastcgi#fcgi-write-data
                     _port207918_
                     std/web/fastcgi#FCGI-STDERR
                     _reqid207917_
                     _data207902_)
                    (error '"request ended; no port" _req207901_)))))
        (if (##structure-instance-of?
             _req207903207910_
             'std/web/fastcgi#fastcgi-request::t)
            (let* ((_e207907207923_ (##vector-ref _req207903207910_ '1))
                   (_port207926_ _e207907207923_)
                   (_e207908207928_ (##vector-ref _req207903207910_ '2))
                   (_reqid207931_ _e207908207928_))
              (_K207906207920_ _reqid207931_ _port207926_))
            (_E207905207914_)))))
  (define std/web/fastcgi#fastcgi-request-end__%
    (lambda (_req207850_ _app-status207851_ _proto-status207852_)
      (let* ((_req207853207860_ _req207850_)
             (_E207855207864_
              (lambda () (error '"No clause matching" _req207853207860_)))
             (_K207856207870_
              (lambda (_reqid207867_ _port207868_)
                (if _port207868_
                    (begin
                      (std/web/fastcgi#fcgi-write-record__0
                       _port207868_
                       std/web/fastcgi#FCGI-STDOUT
                       _reqid207867_
                       '#u8())
                      (std/web/fastcgi#fcgi-write-record__0
                       _port207868_
                       std/web/fastcgi#FCGI-STDERR
                       _reqid207867_
                       '#u8())
                      (std/web/fastcgi#fcgi-write-record__0
                       _port207868_
                       std/web/fastcgi#FCGI-END-REQUEST
                       _reqid207867_
                       (std/web/fastcgi#fcgi-end-request-data
                        _app-status207851_
                        _proto-status207852_))
                      (##structure-set!
                       _req207850_
                       '#f
                       '1
                       std/web/fastcgi#fastcgi-request::t
                       '#f))
                    '#!void))))
        (if (##structure-instance-of?
             _req207853207860_
             'std/web/fastcgi#fastcgi-request::t)
            (let* ((_e207857207873_ (##vector-ref _req207853207860_ '1))
                   (_port207876_ _e207857207873_)
                   (_e207858207878_ (##vector-ref _req207853207860_ '2))
                   (_reqid207881_ _e207858207878_))
              (_K207856207870_ _reqid207881_ _port207876_))
            (_E207855207864_)))))
  (define std/web/fastcgi#fastcgi-request-end__0
    (lambda (_req207886_)
      (let* ((_app-status207888_ '0)
             (_proto-status207890_ std/web/fastcgi#FCGI-REQUEST-COMPLETE))
        (std/web/fastcgi#fastcgi-request-end__%
         _req207886_
         _app-status207888_
         _proto-status207890_))))
  (define std/web/fastcgi#fastcgi-request-end__1
    (lambda (_req207892_ _app-status207893_)
      (let ((_proto-status207895_ std/web/fastcgi#FCGI-REQUEST-COMPLETE))
        (std/web/fastcgi#fastcgi-request-end__%
         _req207892_
         _app-status207893_
         _proto-status207895_))))
  (define std/web/fastcgi#fastcgi-request-end
    (lambda _g208251_
      (let ((_g208250_ (length _g208251_)))
        (cond ((##fx= _g208250_ 1)
               (apply std/web/fastcgi#fastcgi-request-end__0 _g208251_))
              ((##fx= _g208250_ 2)
               (apply std/web/fastcgi#fastcgi-request-end__1 _g208251_))
              ((##fx= _g208250_ 3)
               (apply std/web/fastcgi#fastcgi-request-end__% _g208251_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/web/fastcgi#fastcgi-request-end
                _g208251_))))))
  (define std/web/fastcgi#FCGI-BEGIN-REQUEST '1)
  (define std/web/fastcgi#FCGI-ABORT-REQUEST '2)
  (define std/web/fastcgi#FCGI-END-REQUEST '3)
  (define std/web/fastcgi#FCGI-PARAMS '4)
  (define std/web/fastcgi#FCGI-STDIN '5)
  (define std/web/fastcgi#FCGI-STDOUT '6)
  (define std/web/fastcgi#FCGI-STDERR '7)
  (define std/web/fastcgi#FCGI-DATA '8)
  (define std/web/fastcgi#FCGI-GET-VALUES '9)
  (define std/web/fastcgi#FCGI-GET-VALUES-RESULT '10)
  (define std/web/fastcgi#FCGI-UNKNOWN-TYPE '11)
  (define std/web/fastcgi#FCGI-RESPONDER '1)
  (define std/web/fastcgi#FCGI-AUTHORIZER '2)
  (define std/web/fastcgi#FCGI-FILTER '3)
  (define std/web/fastcgi#FCGI-KEEP-CONN '1)
  (define std/web/fastcgi#FCGI-REQUEST-COMPLETE '0)
  (define std/web/fastcgi#FCGI-CANT-MPX-CONN '1)
  (define std/web/fastcgi#FCGI-OVERLOADED '2)
  (define std/web/fastcgi#FCGI-UNKNOWN-ROLE '3)
  (define std/web/fastcgi#fcgi-read-record
    (lambda (_port207819_)
      (call-with-current-continuation
       (lambda (_return207821_)
         (let* ((_head207823_ (make-u8vector '8))
                (_rd207825_ (read-subu8vector _head207823_ '0 '8 _port207819_))
                (_g208252_
                 (if (zero? _rd207825_) (_return207821_ (eof-object)) '#!void))
                (_g208253_
                 (if (fx< _rd207825_ '8)
                     (std/error#raise-io-error
                      'fcgi-read-record
                      '"incomplete record")
                     '#!void))
                (_ver207829_ (u8vector-ref _head207823_ '0))
                (_g208254_
                 (if (= _ver207829_ '1)
                     '#!void
                     (std/error#raise-io-error
                      'fcgi-read-record
                      '"version mismatch"
                      _ver207829_)))
                (_type207832_ (u8vector-ref _head207823_ '1))
                (_rid207834_
                 (fxior (fxarithmetic-shift (u8vector-ref _head207823_ '2) '8)
                        (u8vector-ref _head207823_ '3)))
                (_clen207836_
                 (fxior (fxarithmetic-shift (u8vector-ref _head207823_ '4) '8)
                        (u8vector-ref _head207823_ '5)))
                (_plen207838_ (u8vector-ref _head207823_ '6))
                (_dlen207840_ (fx+ _clen207836_ _plen207838_))
                (_data207842_ (make-u8vector _dlen207840_))
                (_rd207844_
                 (if (fxpositive? _dlen207840_)
                     (read-subu8vector
                      _data207842_
                      '0
                      _dlen207840_
                      _port207819_)
                     _rd207825_))
                (_g208255_
                 (if (fx< _rd207844_ _dlen207840_)
                     (std/error#raise-io-error
                      'fcgi-read-record
                      '"incomplete record")
                     '#!void))
                (_g208256_
                 (if (fxpositive? _plen207838_)
                     (u8vector-shrink! _data207842_ _clen207836_)
                     '#!void)))
           (values _type207832_ _rid207834_ _data207842_))))))
  (define std/web/fastcgi#fcgi-read-key-value-pairs
    (lambda (_port207776_)
      (letrec ((_read-length207778_
                (lambda (_port207803_)
                  (let ((_nb0207805_ (read-u8 _port207803_)))
                    (if (eof-object? _nb0207805_)
                        _nb0207805_
                        (if (zero? (fxarithmetic-shift _nb0207805_ '-7))
                            _nb0207805_
                            (let* ((_nb3207807_ (fxand _nb0207805_ '127))
                                   (_nb2207809_ (read-u8 _port207803_))
                                   (_g208257_
                                    (if (eof-object? _nb2207809_)
                                        (std/error#raise-io-error
                                         'fcgi-read-key-value-pairs
                                         '"premature port end")
                                        '#!void))
                                   (_nb1207812_ (read-u8 _port207803_))
                                   (_g208258_
                                    (if (eof-object? _nb1207812_)
                                        (std/error#raise-io-error
                                         'fcgi-read-key-value-pairs
                                         '"premature port end")
                                        '#!void))
                                   (_nb0207815_ (read-u8 _port207803_))
                                   (_g208259_
                                    (if (eof-object? _nb0207815_)
                                        (std/error#raise-io-error
                                         'fcgi-read-key-value-pairs
                                         '"premature port end")
                                        '#!void)))
                              (fxior (fxarithmetic-shift _nb3207807_ '24)
                                     (fxarithmetic-shift _nb2207809_ '16)
                                     (fxarithmetic-shift _nb1207812_ '8)
                                     _nb0207815_))))))))
        (let _lp207780_ ((_klen207782_ (_read-length207778_ _port207776_))
                         (_r207783_ '()))
          (if (eof-object? _klen207782_)
              (reverse _r207783_)
              (let* ((_vlen207785_ (_read-length207778_ _port207776_))
                     (_g208260_
                      (if (eof-object? _vlen207785_)
                          (std/error#raise-io-error
                           'fcgi-read-key-value-pairs
                           '"premature port end")
                          '#!void))
                     (_kdata207788_ (make-u8vector _klen207782_))
                     (_rd207790_
                      (read-subu8vector
                       _kdata207788_
                       '0
                       _klen207782_
                       _port207776_))
                     (_g208261_
                      (if (fx< _rd207790_ _klen207782_)
                          (std/error#raise-io-error
                           'fcgi-read-key-value-pairs
                           '"premature port end")
                          '#!void))
                     (_vdata207793_ (make-u8vector _vlen207785_))
                     (_rd207795_
                      (read-subu8vector
                       _vdata207793_
                       '0
                       _vlen207785_
                       _port207776_))
                     (_g208262_
                      (if (fx< _rd207795_ _vlen207785_)
                          (std/error#raise-io-error
                           'fcgi-read-key-value-pairs
                           '"premature port end")
                          '#!void))
                     (_key207798_
                      (string->symbol
                       (std/text/utf8#utf8->string__0 _kdata207788_)))
                     (_value207800_
                      (std/text/utf8#utf8->string__0 _vdata207793_)))
                (_lp207780_
                 (_read-length207778_ _port207776_)
                 (cons (cons _key207798_ _value207800_) _r207783_))))))))
  (define std/web/fastcgi#fcgi-write-record__%
    (lambda (_port207732_
             _type207733_
             _reqid207734_
             _data207735_
             _start207736_
             _end207737_)
      (let* ((_head207739_ (make-u8vector '8))
             (_end207744_
              (let ((_$e207741_ _end207737_))
                (if _$e207741_ _$e207741_ (u8vector-length _data207735_))))
             (_clen207746_ (fx- _end207744_ _start207736_)))
        (u8vector-set! _head207739_ '0 '1)
        (u8vector-set! _head207739_ '1 _type207733_)
        (u8vector-set!
         _head207739_
         '2
         (fxand (fxarithmetic-shift _reqid207734_ '-8) '255))
        (u8vector-set! _head207739_ '3 (fxand _reqid207734_ '255))
        (u8vector-set!
         _head207739_
         '4
         (fxand (fxarithmetic-shift _clen207746_ '-8) '255))
        (u8vector-set! _head207739_ '5 (fxand _clen207746_ '255))
        (write-subu8vector _head207739_ '0 '8 _port207732_)
        (write-subu8vector _data207735_ _start207736_ _end207744_ _port207732_)
        (force-output _port207732_))))
  (define std/web/fastcgi#fcgi-write-record__0
    (lambda (_port207752_ _type207753_ _reqid207754_ _data207755_)
      (let* ((_start207757_ '0) (_end207759_ '#f))
        (std/web/fastcgi#fcgi-write-record__%
         _port207752_
         _type207753_
         _reqid207754_
         _data207755_
         _start207757_
         _end207759_))))
  (define std/web/fastcgi#fcgi-write-record__1
    (lambda (_port207761_
             _type207762_
             _reqid207763_
             _data207764_
             _start207765_)
      (let ((_end207767_ '#f))
        (std/web/fastcgi#fcgi-write-record__%
         _port207761_
         _type207762_
         _reqid207763_
         _data207764_
         _start207765_
         _end207767_))))
  (define std/web/fastcgi#fcgi-write-record
    (lambda _g208264_
      (let ((_g208263_ (length _g208264_)))
        (cond ((##fx= _g208263_ 4)
               (apply std/web/fastcgi#fcgi-write-record__0 _g208264_))
              ((##fx= _g208263_ 5)
               (apply std/web/fastcgi#fcgi-write-record__1 _g208264_))
              ((##fx= _g208263_ 6)
               (apply std/web/fastcgi#fcgi-write-record__% _g208264_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/web/fastcgi#fcgi-write-record
                _g208264_))))))
  (define std/web/fastcgi#fcgi-write-data
    (lambda (_port207715_ _type207716_ _reqid207717_ _data207718_)
      (let* ((_data207720_
              (if (string? _data207718_)
                  (std/text/utf8#string->utf8__0 _data207718_)
                  _data207718_))
             (_len207722_ (u8vector-length _data207720_)))
        (let _lp207725_ ((_start207727_ '0))
          (if (fx> (fx- _len207722_ _start207727_) '65535)
              (let ((_end207729_ (fx+ _start207727_ '65535)))
                (std/web/fastcgi#fcgi-write-record__%
                 _port207715_
                 _type207716_
                 _reqid207717_
                 _data207720_
                 _start207727_
                 _end207729_)
                (_lp207725_ _end207729_))
              (std/web/fastcgi#fcgi-write-record__%
               _port207715_
               _type207716_
               _reqid207717_
               _data207720_
               _start207727_
               _len207722_))))))
  (define std/web/fastcgi#fcgi-write-key-value-pairs
    (lambda (_port207645_ _alst207646_)
      (letrec ((_write-length207648_
                (lambda (_port207707_ _len207708_)
                  (if (fx< _len207708_ '128)
                      (write-u8 _len207708_ _port207707_)
                      (let ((_nb3207710_
                             (fxior (fxand (fxarithmetic-shift
                                            _len207708_
                                            '-24)
                                           '127)
                                    '128))
                            (_nb2207711_
                             (fxand (fxarithmetic-shift _len207708_ '-16)
                                    '255))
                            (_nb1207712_
                             (fxand (fxarithmetic-shift _len207708_ '-8) '255))
                            (_nb0207713_ (fxand _len207708_ '255)))
                        (write-u8 _nb3207710_ _port207707_)
                        (write-u8 _nb2207711_ _port207707_)
                        (write-u8 _nb1207712_ _port207707_)
                        (write-u8 _nb0207713_ _port207707_))))))
        (let ((_iterable207690_ _alst207646_)
              (_iter-do207692_
               (lambda (_val207650_)
                 (let* ((_val207652207659_ _val207650_)
                        (_E207654207663_
                         (lambda ()
                           (error '"No clause matching" _val207652207659_)))
                        (_K207655207678_
                         (lambda (_value207666_ _key207667_)
                           (let* ((_kdata207669_
                                   (std/text/utf8#string->utf8__0
                                    (symbol->string _key207667_)))
                                  (_klen207671_
                                   (u8vector-length _kdata207669_))
                                  (_vdata207673_
                                   (if (string? _value207666_)
                                       (std/text/utf8#string->utf8__0
                                        _value207666_)
                                       _value207666_))
                                  (_vlen207675_
                                   (u8vector-length _vdata207673_)))
                             (_write-length207648_ _port207645_ _klen207671_)
                             (_write-length207648_ _port207645_ _vlen207675_)
                             (write-subu8vector
                              _kdata207669_
                              '0
                              _klen207671_
                              _port207645_)
                             (write-subu8vector
                              _vdata207673_
                              '0
                              _vlen207675_
                              _port207645_)))))
                   (if (##pair? _val207652207659_)
                       (let ((_hd207656207681_ (##car _val207652207659_))
                             (_tl207657207683_ (##cdr _val207652207659_)))
                         (let* ((_key207686_ _hd207656207681_)
                                (_value207688_ _tl207657207683_))
                           (_K207655207678_ _value207688_ _key207686_)))
                       (_E207654207663_))))))
          (if (pair? _iterable207690_)
              (for-each _iter-do207692_ _iterable207690_)
              (let ((_$e207695_ (null? _iterable207690_)))
                (if _$e207695_
                    _$e207695_
                    (let ((_it207698_ (std/iter#iter _iterable207690_)))
                      (let _lp207701_ ()
                        (let ((_val207705_ (std/iter#iter-next! _it207698_)))
                          (if (eq? std/iter#iter-end _val207705_)
                              '#!void
                              (begin
                                (_iter-do207692_ _val207705_)
                                (_lp207701_)))))
                      (std/iter#iter-fini! _it207698_)
                      '#!void))))))))
  (define std/web/fastcgi#fcgi-begin-request-e
    (lambda (_data207640_)
      (let ((_role207642_
             (fxior (fxarithmetic-shift (u8vector-ref _data207640_ '0) '8)
                    (u8vector-ref _data207640_ '1)))
            (_flags207643_ (u8vector-ref _data207640_ '2)))
        (if (eq? _role207642_ std/web/fastcgi#FCGI-RESPONDER)
            (values 'FCGI-RESPONDER _flags207643_)
            (if (eq? _role207642_ std/web/fastcgi#FCGI-AUTHORIZER)
                (values 'FCGI-AUTHORIZER _flags207643_)
                (if (eq? _role207642_ std/web/fastcgi#FCGI-FILTER)
                    (values 'FCGI-FILTER _flags207643_)
                    (values _role207642_ _flags207643_)))))))
  (define std/web/fastcgi#fcgi-get-values-e
    (lambda (_data207638_)
      (map car
           (std/web/fastcgi#fcgi-read-key-value-pairs
            (open-input-u8vector _data207638_)))))
  (define std/web/fastcgi#fcgi-params-e
    (lambda (_data207636_)
      (std/web/fastcgi#fcgi-read-key-value-pairs
       (open-input-u8vector _data207636_))))
  (define std/web/fastcgi#fcgi-get-values-result-data
    (lambda (_alst207632_)
      (let ((_outp207634_ (open-output-u8vector)))
        (std/web/fastcgi#fcgi-write-key-value-pairs _outp207634_ _alst207632_)
        (get-output-u8vector _outp207634_))))
  (define std/web/fastcgi#fcgi-unknown-type-data
    (lambda (_type207628_)
      (let ((_data207630_ (make-u8vector '8)))
        (u8vector-set! _data207630_ '0 _type207628_)
        _data207630_)))
  (define std/web/fastcgi#fcgi-end-request-data
    (lambda (_app-status207623_ _proto-status207624_)
      (let ((_data207626_ (make-u8vector '8)))
        (u8vector-set!
         _data207626_
         '0
         (fxand (fxarithmetic-shift _app-status207623_ '-24) '255))
        (u8vector-set!
         _data207626_
         '1
         (fxand (fxarithmetic-shift _app-status207623_ '-16) '255))
        (u8vector-set!
         _data207626_
         '2
         (fxand (fxarithmetic-shift _app-status207623_ '-8) '255))
        (u8vector-set! _data207626_ '3 (fxand _app-status207623_ '255))
        (u8vector-set! _data207626_ '4 _proto-status207624_)
        _data207626_))))
