/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepoBasic;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestKeys;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0011\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u000bH\u0014J,\u0010\u0017\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J,\u0010\u001a\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J,\u0010\u001b\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J,\u0010\u001c\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "disableIfNoVisibleChildren", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getData", "Lkotlin/Pair;", "", "Lorg/jetbrains/plugins/github/api/GithubRepositoryPath;", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;", "dataContext", "getDataFromHistory", "project", "Lcom/intellij/openapi/project/Project;", "getDataFromLog", "getDataFromPullRequest", "getDataFromVirtualFile", "isPopup", "update", "Companion", "Data", "intellij.vcs.github"})
public class GithubOpenInBrowserActionGroup
extends ActionGroup
implements DumbAware {
    private static final String CANNOT_OPEN_IN_BROWSER = "Can't open in browser";
    @Deprecated
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        v0 = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"e.dataContext");
        v1 = this.getData(v0);
        repositories = v1 != null ? (Set<E>)v1.getFirst() : null;
        v2 = e.getPresentation();
        v3 = v2;
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"e.presentation");
        if (repositories == null) ** GOTO lbl-1000
        var3_3 = repositories;
        var4_4 = v3;
        var5_5 = var3_3.isEmpty() == false;
        v3 = var4_4;
        if (var5_5) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        v3.setEnabledAndVisible(v4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (e == null) {
            return new AnAction[0];
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
        Pair<Set<GithubRepositoryPath>, Data> pair = this.getData(dataContext);
        if (pair == null) {
            return new AnAction[0];
        }
        Pair<Set<GithubRepositoryPath>, Data> data = pair;
        if (((Set)data.getFirst()).size() <= 1) {
            return new AnAction[0];
        }
        Iterable iterable = $receiver$iv = (Iterable)data.getFirst();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GithubRepositoryPath githubRepositoryPath = (GithubRepositoryPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            Companion.GithubOpenInBrowserAction githubOpenInBrowserAction = new Companion.GithubOpenInBrowserAction((GithubRepositoryPath)it, (Data)data.getSecond());
            collection.add(githubOpenInBrowserAction);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
        if (anActionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return anActionArray;
    }

    public boolean isPopup() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Pair<Set<GithubRepositoryPath>, Data> pair;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
            Pair<Set<GithubRepositoryPath>, Data> pair2 = this.getData(dataContext);
            if (pair2 == null) break block0;
            Pair<Set<GithubRepositoryPath>, Data> it = pair = pair2;
            new Companion.GithubOpenInBrowserAction((GithubRepositoryPath)CollectionsKt.first((Iterable)((Iterable)it.getFirst())), (Data)it.getSecond()).actionPerformed(e);
        }
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = this.getData(context);
        return object != null && (object = (Set)object.getFirst()) != null && object.size() == 1;
    }

    public boolean disableIfNoVisibleChildren() {
        return false;
    }

    @Nullable
    protected Pair<Set<GithubRepositoryPath>, Data> getData(@NotNull DataContext dataContext) {
        Pair<Set<GithubRepositoryPath>, Data> pair;
        Pair<Set<GithubRepositoryPath>, Data> pair2;
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"dataContext.getData(Comm\u2026s.PROJECT) ?: return null");
        Project project2 = project;
        Pair<Set<GithubRepositoryPath>, Data> pair3 = this.getDataFromPullRequest(project2, dataContext);
        if (pair3 == null) {
            pair3 = pair2 = this.getDataFromHistory(project2, dataContext);
        }
        if (pair3 == null) {
            pair2 = pair = this.getDataFromLog(project2, dataContext);
        }
        if (pair2 == null) {
            pair = this.getDataFromVirtualFile(project2, dataContext);
        }
        return pair;
    }

    private final Pair<Set<GithubRepositoryPath>, Data> getDataFromPullRequest(Project project, DataContext dataContext) {
        GithubSearchedIssue githubSearchedIssue = (GithubSearchedIssue)dataContext.getData(GithubPullRequestKeys.getSELECTED_PULL_REQUEST());
        if (githubSearchedIssue == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)githubSearchedIssue, (String)"dataContext.getData(Gith\u2026L_REQUEST) ?: return null");
        GithubSearchedIssue pullRequest = githubSearchedIssue;
        GithubServerPath githubServerPath = (GithubServerPath)dataContext.getData(GithubPullRequestKeys.getSERVER_PATH());
        if (githubServerPath == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"dataContext.getData(Gith\u2026RVER_PATH) ?: return null");
        GithubServerPath serverPath = githubServerPath;
        Object object = (GithubRepoDetailed)dataContext.getData(GithubPullRequestKeys.getREPO_DETAILS());
        if (object == null || (object = ((GithubRepoBasic)object).getFullPath()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataContext.getData(Gith\u2026?.fullPath ?: return null");
        Object fullPath = object;
        Object object2 = pullRequest.getPullRequestLinks();
        if (object2 == null || (object2 = ((GithubSearchedIssue.PullRequestLinks)object2).getHtmlUrl()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"pullRequest.pullRequestL\u2026s?.htmlUrl ?: return null");
        Object htmlUrl = object2;
        return TuplesKt.to((Object)SetsKt.setOf((Object)new GithubRepositoryPath(serverPath, (GithubFullPath)fullPath)), (Object)new Data.URL(project, (String)htmlUrl));
    }

    private final Pair<Set<GithubRepositoryPath>, Data> getDataFromHistory(Project project, DataContext dataContext) {
        FilePath filePath = (FilePath)dataContext.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"dataContext.getData(VcsD\u2026FILE_PATH) ?: return null");
        FilePath filePath2 = filePath;
        VcsFileRevision vcsFileRevision = (VcsFileRevision)dataContext.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (vcsFileRevision == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsFileRevision, (String)"dataContext.getData(VcsD\u2026_REVISION) ?: return null");
        VcsFileRevision fileRevision = vcsFileRevision;
        if (!(fileRevision instanceof GitFileRevision)) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(filePath2);
        if (repository == null) {
            return null;
        }
        Object object = ServiceManager.getService(GithubGitHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        Set<GithubRepositoryPath> accessibleRepositories = ((GithubGitHelper)object).getPossibleRepositories(repository);
        if (accessibleRepositories.isEmpty()) {
            return null;
        }
        String string = ((GitFileRevision)fileRevision).getRevisionNumber().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileRevision.revisionNumber.asString()");
        return TuplesKt.to(accessibleRepositories, (Object)new Data.Revision(project, string));
    }

    private final Pair<Set<GithubRepositoryPath>, Data> getDataFromLog(Project project, DataContext dataContext) {
        VcsLog vcsLog = (VcsLog)dataContext.getData(VcsLogDataKeys.VCS_LOG);
        if (vcsLog == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLog, (String)"dataContext.getData(VcsL\u2026s.VCS_LOG) ?: return null");
        VcsLog log = vcsLog;
        List list2 = log.getSelectedCommits();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"log.selectedCommits");
        List selectedCommits = list2;
        if (selectedCommits.size() != 1) {
            return null;
        }
        CommitId commitId = (CommitId)ContainerUtil.getFirstItem((List)selectedCommits);
        if (commitId == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)commitId, (String)"ContainerUtil.getFirstIt\u2026edCommits) ?: return null");
        CommitId commit = commitId;
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(commit.getRoot());
        if (repository == null) {
            return null;
        }
        Object object = ServiceManager.getService(GithubGitHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        Set<GithubRepositoryPath> accessibleRepositories = ((GithubGitHelper)object).getPossibleRepositories(repository);
        if (accessibleRepositories.isEmpty()) {
            return null;
        }
        String string = commit.getHash().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commit.hash.asString()");
        return TuplesKt.to(accessibleRepositories, (Object)new Data.Revision(project, string));
    }

    private final Pair<Set<GithubRepositoryPath>, Data> getDataFromVirtualFile(Project project, DataContext dataContext) {
        Pair pair;
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"dataContext.getData(Comm\u2026TUAL_FILE) ?: return null");
        VirtualFile virtualFile2 = virtualFile;
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFileQuick(virtualFile2);
        if (repository == null) {
            return null;
        }
        Object object = ServiceManager.getService(GithubGitHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        Set<GithubRepositoryPath> accessibleRepositories = ((GithubGitHelper)object).getPossibleRepositories(repository);
        if (accessibleRepositories.isEmpty()) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager changeListManager2 = changeListManager;
        if (changeListManager2.isUnversioned(virtualFile2)) {
            return null;
        }
        Change change = changeListManager2.getChange(virtualFile2);
        if (change != null && change.getType() == Change.Type.NEW) {
            pair = null;
        } else {
            VirtualFile virtualFile3 = repository.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"repository.root");
            pair = TuplesKt.to(accessibleRepositories, (Object)new Data.File(project, virtualFile3, virtualFile2));
        }
        return pair;
    }

    public GithubOpenInBrowserActionGroup() {
        super("Open on GitHub", "Open corresponding link in browser", AllIcons.Vcs.Vendors.Github);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "File", "Revision", "URL", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data$File;", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data$Revision;", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data$URL;", "intellij.vcs.github"})
    protected static abstract class Data {
        @NotNull
        private final Project project;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        private Data(Project project) {
            this.project = project;
        }

        public /* synthetic */ Data(@NotNull Project project, DefaultConstructorMarker $constructor_marker) {
            this(project);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data$File;", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;", "project", "Lcom/intellij/openapi/project/Project;", "gitRepoRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getGitRepoRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "intellij.vcs.github"})
        public static final class File
        extends Data {
            @NotNull
            private final VirtualFile gitRepoRoot;
            @NotNull
            private final VirtualFile virtualFile;

            @NotNull
            public final VirtualFile getGitRepoRoot() {
                return this.gitRepoRoot;
            }

            @NotNull
            public final VirtualFile getVirtualFile() {
                return this.virtualFile;
            }

            public File(@NotNull Project project, @NotNull VirtualFile gitRepoRoot, @NotNull VirtualFile virtualFile) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)gitRepoRoot, (String)"gitRepoRoot");
                Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
                super(project, null);
                this.gitRepoRoot = gitRepoRoot;
                this.virtualFile = virtualFile;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data$Revision;", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;", "project", "Lcom/intellij/openapi/project/Project;", "revisionHash", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getRevisionHash", "()Ljava/lang/String;", "intellij.vcs.github"})
        public static final class Revision
        extends Data {
            @NotNull
            private final String revisionHash;

            @NotNull
            public final String getRevisionHash() {
                return this.revisionHash;
            }

            public Revision(@NotNull Project project, @NotNull String revisionHash) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)revisionHash, (String)"revisionHash");
                super(project, null);
                this.revisionHash = revisionHash;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data$URL;", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;", "project", "Lcom/intellij/openapi/project/Project;", "htmlUrl", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getHtmlUrl", "()Ljava/lang/String;", "intellij.vcs.github"})
        public static final class URL
        extends Data {
            @NotNull
            private final String htmlUrl;

            @NotNull
            public final String getHtmlUrl() {
                return this.htmlUrl;
            }

            public URL(@NotNull Project project, @NotNull String htmlUrl) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)htmlUrl, (String)"htmlUrl");
                super(project, null);
                this.htmlUrl = htmlUrl;
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Companion;", "", "()V", "CANNOT_OPEN_IN_BROWSER", "", "GithubOpenInBrowserAction", "intellij.vcs.github"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J2\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Companion$GithubOpenInBrowserAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "repoPath", "Lorg/jetbrains/plugins/github/api/GithubRepositoryPath;", "data", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;", "(Lorg/jetbrains/plugins/github/api/GithubRepositoryPath;Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;)V", "getData", "()Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getCurrentFileRevisionHash", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "makeUrlToOpen", "editor", "Lcom/intellij/openapi/editor/Editor;", "relativePath", "branch", "path", "openCommitInBrowser", "revisionHash", "openFileInBrowser", "repositoryRoot", "virtualFile", "intellij.vcs.github"})
        public static final class GithubOpenInBrowserAction
        extends DumbAwareAction {
            private final GithubRepositoryPath repoPath;
            @NotNull
            private final Data data;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Data data = this.data;
                if (data instanceof Data.Revision) {
                    this.openCommitInBrowser(this.repoPath, ((Data.Revision)this.data).getRevisionHash());
                } else if (data instanceof Data.File) {
                    this.openFileInBrowser(this.data.getProject(), ((Data.File)this.data).getGitRepoRoot(), this.repoPath, ((Data.File)this.data).getVirtualFile(), (Editor)e.getData(CommonDataKeys.EDITOR));
                } else if (data instanceof Data.URL) {
                    BrowserUtil.browse((String)((Data.URL)this.data).getHtmlUrl());
                }
            }

            private final void openCommitInBrowser(GithubRepositoryPath path, String revisionHash) {
                BrowserUtil.browse((String)(path.toUrl() + "/commit/" + revisionHash));
            }

            private final void openFileInBrowser(Project project, VirtualFile repositoryRoot, GithubRepositoryPath path, VirtualFile virtualFile, Editor editor) {
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)repositoryRoot);
                if (relativePath == null) {
                    Companion;
                    GithubNotifications.showError(project, GithubOpenInBrowserActionGroup.CANNOT_OPEN_IN_BROWSER, "File is not under repository root", "Root: " + repositoryRoot.getPresentableUrl() + ", file: " + virtualFile.getPresentableUrl());
                    return;
                }
                String hash = this.getCurrentFileRevisionHash(project, virtualFile);
                if (hash == null) {
                    Companion;
                    GithubNotifications.showError(project, GithubOpenInBrowserActionGroup.CANNOT_OPEN_IN_BROWSER, "Can't get last revision.");
                    return;
                }
                String githubUrl = this.makeUrlToOpen(editor, relativePath, hash, path);
                if (githubUrl != null) {
                    BrowserUtil.browse((String)githubUrl);
                }
            }

            private final String getCurrentFileRevisionHash(Project project, VirtualFile file) {
                String string;
                Ref ref = new Ref();
                new Task.Modal(ref, project, file, project, "Getting Last Revision", true){
                    final /* synthetic */ Ref $ref;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ VirtualFile $file;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        this.$ref.set((Object)((GitRevisionNumber)GitHistoryUtils.getCurrentRevision((Project)this.$project, (FilePath)VcsUtil.getFilePath((VirtualFile)this.$file), (String)"HEAD")));
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        GithubUtil.LOG.warn(error);
                    }
                    {
                        this.$ref = $captured_local_variable$0;
                        this.$project = $captured_local_variable$1;
                        this.$file = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                }.queue();
                if (ref.isNull()) {
                    string = null;
                } else {
                    Object object = ref.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ref.get()");
                    string = ((GitRevisionNumber)object).getRev();
                }
                return string;
            }

            private final String makeUrlToOpen(Editor editor, String relativePath, String branch, GithubRepositoryPath path) {
                StringBuilder builder = new StringBuilder();
                if (StringUtil.isEmptyOrSpaces((String)relativePath)) {
                    builder.append(path.toUrl()).append("/tree/").append(branch);
                } else {
                    builder.append(path.toUrl()).append("/blob/").append(branch).append('/').append(relativePath);
                }
                if (editor != null) {
                    Document document = editor.getDocument();
                    Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                    if (document.getLineCount() >= 1) {
                        SelectionModel selectionModel = editor.getSelectionModel();
                        Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"editor.selectionModel");
                        SelectionModel selectionModel2 = selectionModel;
                        int begin = editor.getDocument().getLineNumber(selectionModel2.getSelectionStart()) + 1;
                        int selectionEnd = selectionModel2.getSelectionEnd();
                        int end = editor.getDocument().getLineNumber(selectionEnd) + 1;
                        if (editor.getDocument().getLineStartOffset(end - 1) == selectionEnd) {
                            --end;
                        }
                        builder.append("#L").append(begin);
                        if (begin != end) {
                            builder.append("-L").append(end);
                        }
                    }
                }
                return builder.toString();
            }

            @NotNull
            public final Data getData() {
                return this.data;
            }

            public GithubOpenInBrowserAction(@NotNull GithubRepositoryPath repoPath, @NotNull Data data) {
                Intrinsics.checkParameterIsNotNull((Object)repoPath, (String)"repoPath");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                super(StringsKt.replace$default((String)repoPath.toString(), (char)'_', (char)' ', (boolean)false, (int)4, null));
                this.repoPath = repoPath;
                this.data = data;
            }
        }
    }
}

