/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.ListStack;

public class StrongConnectivityHelper {
    private final List<List<Statement>> components = new ArrayList<List<Statement>>();
    private final Set<Statement> setProcessed = new HashSet<Statement>();
    private ListStack<Statement> lstack;
    private int ncounter;
    private Set<Statement> tset;
    private Map<Statement, Integer> dfsnummap;
    private Map<Statement, Integer> lowmap;

    public StrongConnectivityHelper(Statement stat) {
        this.visitTree(stat.getFirst());
        for (Statement st : stat.getStats()) {
            if (this.setProcessed.contains(st) || !st.getPredecessorEdges(0x40000000).isEmpty()) continue;
            this.visitTree(st);
        }
        for (Statement st : stat.getStats()) {
            if (this.setProcessed.contains(st)) continue;
            this.visitTree(st);
        }
    }

    private void visitTree(Statement stat) {
        this.lstack = new ListStack();
        this.ncounter = 0;
        this.tset = new HashSet<Statement>();
        this.dfsnummap = new HashMap<Statement, Integer>();
        this.lowmap = new HashMap<Statement, Integer>();
        this.visit(stat);
        this.setProcessed.addAll(this.tset);
        this.setProcessed.add(stat);
    }

    private void visit(Statement stat) {
        this.lstack.push(stat);
        this.dfsnummap.put(stat, this.ncounter);
        this.lowmap.put(stat, this.ncounter);
        ++this.ncounter;
        List<Statement> lstSuccs = stat.getNeighbours(1, 1);
        lstSuccs.removeAll(this.setProcessed);
        for (Statement succ : lstSuccs) {
            int secvalue;
            if (this.tset.contains(succ)) {
                secvalue = this.dfsnummap.get(succ);
            } else {
                this.tset.add(succ);
                this.visit(succ);
                secvalue = this.lowmap.get(succ);
            }
            this.lowmap.put(stat, Math.min(this.lowmap.get(stat), secvalue));
        }
        if (this.lowmap.get(stat).intValue() == this.dfsnummap.get(stat).intValue()) {
            Statement v;
            ArrayList<Statement> lst = new ArrayList<Statement>();
            do {
                v = this.lstack.pop();
                lst.add(v);
            } while (v != stat);
            this.components.add(lst);
        }
    }

    public static boolean isExitComponent(List<? extends Statement> lst) {
        HashSet<Statement> set = new HashSet<Statement>();
        for (Statement statement : lst) {
            set.addAll(statement.getNeighbours(1, 1));
        }
        set.removeAll(lst);
        return set.size() == 0;
    }

    public static List<Statement> getExitReps(List<? extends List<Statement>> lst) {
        ArrayList<Statement> res = new ArrayList<Statement>();
        for (List<Statement> list : lst) {
            if (!StrongConnectivityHelper.isExitComponent(list)) continue;
            res.add(list.get(0));
        }
        return res;
    }

    public List<List<Statement>> getComponents() {
        return this.components;
    }
}

