/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructInnerClassesAttribute
extends StructGeneralAttribute {
    private List<Entry> entries;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.entries = new ArrayList<Entry>(len);
            for (int i = 0; i < len; ++i) {
                int innerNameIdx = data.readUnsignedShort();
                int outerNameIdx = data.readUnsignedShort();
                int simpleNameIdx = data.readUnsignedShort();
                int accessFlags = data.readUnsignedShort();
                String innerName = pool.getPrimitiveConstant(innerNameIdx).getString();
                String outerName = outerNameIdx != 0 ? pool.getPrimitiveConstant(outerNameIdx).getString() : null;
                String simpleName = simpleNameIdx != 0 ? pool.getPrimitiveConstant(simpleNameIdx).getString() : null;
                this.entries.add(new Entry(outerNameIdx, simpleNameIdx, accessFlags, innerName, outerName, simpleName));
            }
        } else {
            this.entries = Collections.emptyList();
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        public final int outerNameIdx;
        public final int simpleNameIdx;
        public final int accessFlags;
        public final String innerName;
        public final String enclosingName;
        public final String simpleName;

        private Entry(int outerNameIdx, int simpleNameIdx, int accessFlags, String innerName, String enclosingName, String simpleName) {
            this.outerNameIdx = outerNameIdx;
            this.simpleNameIdx = simpleNameIdx;
            this.accessFlags = accessFlags;
            this.innerName = innerName;
            this.enclosingName = enclosingName;
            this.simpleName = simpleName;
        }
    }
}

