/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemBeforeRunTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEditTaskDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ExternalSystemBeforeRunTaskProvider
extends BeforeRunTaskProvider<ExternalSystemBeforeRunTask> {
    @NotNull
    private final ProjectSystemId mySystemId;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Key<ExternalSystemBeforeRunTask> myId;

    public ExternalSystemBeforeRunTaskProvider(@NotNull ProjectSystemId systemId, @NotNull Project project, @NotNull Key<ExternalSystemBeforeRunTask> id) {
        if (systemId == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if (id == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        this.mySystemId = systemId;
        this.myProject = project;
        this.myId = id;
    }

    @NotNull
    public Key<ExternalSystemBeforeRunTask> getId() {
        Key<ExternalSystemBeforeRunTask> key = this.myId;
        if (key == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        return key;
    }

    public String getName() {
        return ExternalSystemBundle.message((String)"tasks.before.run.empty", (Object[])new Object[]{this.mySystemId.getReadableName()});
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull ExternalSystemBeforeRunTask task) {
        if (runConfiguration == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        if (task == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        ExternalSystemEditTaskDialog dialog = new ExternalSystemEditTaskDialog(this.myProject, task.getTaskExecutionSettings(), this.mySystemId);
        dialog.setTitle(ExternalSystemBundle.message((String)"tasks.select.task.title", (Object[])new Object[]{this.mySystemId.getReadableName()}));
        return dialog.showAndGet();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull ExternalSystemBeforeRunTask beforeRunTask) {
        if (configuration == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (beforeRunTask == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        ExternalSystemTaskExecutionSettings executionSettings = beforeRunTask.getTaskExecutionSettings();
        ArrayList tasks = ContainerUtilRt.newArrayList();
        for (String taskName : executionSettings.getTaskNames()) {
            tasks.add(new ExternalTaskPojo(taskName, executionSettings.getExternalProjectPath(), null));
        }
        if (tasks.isEmpty()) {
            return true;
        }
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment(this.myProject, this.mySystemId, executionSettings, DefaultRunExecutor.EXECUTOR_ID);
        if (environment == null) {
            return false;
        }
        return environment.getRunner().canRun(DefaultRunExecutor.EXECUTOR_ID, environment.getRunProfile());
    }

    public boolean executeTask(DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull ExternalSystemBeforeRunTask beforeRunTask) {
        if (configuration == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (env == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        if (beforeRunTask == null) {
            ExternalSystemBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        ExternalSystemTaskExecutionSettings executionSettings = beforeRunTask.getTaskExecutionSettings();
        ArrayList tasks = ContainerUtilRt.newArrayList();
        for (String taskName : executionSettings.getTaskNames()) {
            tasks.add(new ExternalTaskPojo(taskName, executionSettings.getExternalProjectPath(), null));
        }
        if (tasks.isEmpty()) {
            return true;
        }
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment(this.myProject, this.mySystemId, executionSettings, DefaultRunExecutor.EXECUTOR_ID);
        if (environment == null) {
            return false;
        }
        ProgramRunner runner = environment.getRunner();
        environment.setExecutionId(env.getExecutionId());
        return RunConfigurationBeforeRunProvider.doRunTask((String)DefaultRunExecutor.getRunExecutorInstance().getId(), (ExecutionEnvironment)environment, (ProgramRunner)runner);
    }

    public String getDescription(ExternalSystemBeforeRunTask task) {
        String externalProjectPath = task.getTaskExecutionSettings().getExternalProjectPath();
        if (task.getTaskExecutionSettings().getTaskNames().isEmpty()) {
            return ExternalSystemBundle.message((String)"tasks.before.run.empty", (Object[])new Object[]{this.mySystemId.getReadableName()});
        }
        String desc = StringUtil.join((Collection)task.getTaskExecutionSettings().getTaskNames(), (String)" ");
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)this.mySystemId, (Module)module) || !StringUtil.equals((CharSequence)externalProjectPath, (CharSequence)ExternalSystemApiUtil.getExternalProjectPath((Module)module))) continue;
            desc = module.getName() + ": " + desc;
            break;
        }
        return ExternalSystemBundle.message((String)"tasks.before.run", (Object[])new Object[]{this.mySystemId.getReadableName(), desc});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRunTask";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

