/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemResolveProjectTask
extends AbstractExternalSystemTask {
    private final AtomicReference<DataNode<ProjectData>> myExternalProject;
    @NotNull
    private final String myProjectPath;
    private final boolean myIsPreviewMode;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private final String myArguments;

    public ExternalSystemResolveProjectTask(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull String projectPath, boolean isPreviewMode) {
        if (externalSystemId == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(2);
        }
        this(externalSystemId, project, projectPath, null, null, isPreviewMode);
    }

    public ExternalSystemResolveProjectTask(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull String projectPath, @Nullable String vmOptions, @Nullable String arguments, boolean isPreviewMode) {
        if (externalSystemId == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(4);
        }
        if (projectPath == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(5);
        }
        super(externalSystemId, ExternalSystemTaskType.RESOLVE_PROJECT, project, projectPath);
        this.myExternalProject = new AtomicReference();
        this.myProjectPath = projectPath;
        this.myIsPreviewMode = isPreviewMode;
        this.myVmOptions = vmOptions;
        this.myArguments = arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        ExternalSystemExecutionSettings settings;
        RemoteExternalSystemProjectResolver<ExternalSystemExecutionSettings> resolver;
        Project ideProject;
        ExternalSystemProgressNotificationManagerImpl progressNotificationManager = (ExternalSystemProgressNotificationManagerImpl)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskId id = this.getId();
        try {
            progressNotificationManager.onStart(id, this.myProjectPath);
            ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
            ideProject = this.getIdeProject();
            resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
            settings = ExternalSystemApiUtil.getExecutionSettings((Project)ideProject, (String)this.myProjectPath, (ProjectSystemId)this.getExternalSystemId());
            if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
                settings.withVmOptions((Collection)ParametersListUtil.parse((String)this.myVmOptions));
            }
            if (StringUtil.isNotEmpty((String)this.myArguments)) {
                settings.withArguments((Collection)ParametersListUtil.parse((String)this.myArguments));
            }
        }
        catch (Exception e) {
            progressNotificationManager.onFailure(id, e);
            progressNotificationManager.onEnd(id);
            throw e;
        }
        try {
            DataNode<ProjectData> project = resolver.resolveProjectInfo(id, this.myProjectPath, this.myIsPreviewMode, settings);
            if (project != null) {
                this.myExternalProject.set(project);
                ExternalSystemManager systemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.getExternalSystemId());
                assert (systemManager != null);
                HashSet externalModulePaths = ContainerUtil.newHashSet();
                Collection moduleNodes = ExternalSystemApiUtil.findAll(project, (Key)ProjectKeys.MODULE);
                for (DataNode node : moduleNodes) {
                    externalModulePaths.add(((ModuleData)node.getData()).getLinkedExternalProjectPath());
                }
                String projectPath = ((ProjectData)project.getData()).getLinkedExternalProjectPath();
                ExternalProjectSettings linkedProjectSettings = ((AbstractExternalSystemSettings)systemManager.getSettingsProvider().fun((Object)ideProject)).getLinkedProjectSettings(projectPath);
                if (linkedProjectSettings != null) {
                    linkedProjectSettings.setModules((Set)externalModulePaths);
                }
            }
            progressNotificationManager.onSuccess(id);
        }
        finally {
            progressNotificationManager.onEnd(id);
        }
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        Project ideProject = this.getIdeProject();
        RemoteExternalSystemProjectResolver resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
        return resolver.cancelTask(this.getId());
    }

    @Override
    @NotNull
    protected String wrapProgressText(@NotNull String text) {
        if (text == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(6);
        }
        String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId().getReadableName(), text});
        if (string == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected void setState(@NotNull ExternalSystemTaskState state) {
        if (state == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(8);
        }
        super.setState(state);
        if (state.isStopped()) {
            InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(this.getExternalSystemId(), this.getExternalProjectPath(), (DataNode<ProjectData>)((DataNode)this.myExternalProject.getAndSet(null)));
            long currentTimeMillis = System.currentTimeMillis();
            projectInfo.setLastImportTimestamp(currentTimeMillis);
            projectInfo.setLastSuccessfulImportTimestamp(state == ExternalSystemTaskState.FAILED ? -1L : currentTimeMillis);
            ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.getIdeProject(), projectInfo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

