/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.Location;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.action.ExternalSystemViewGearAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectsViewImpl
extends SimpleToolWindowPanel
implements DataProvider,
ExternalProjectsView,
Disposable {
    public static final Logger LOG = Logger.getInstance(ExternalProjectsViewImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalProjectsManagerImpl myProjectsManager;
    @NotNull
    private final ToolWindowEx myToolWindow;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final ExternalSystemUiAware myUiAware;
    @NotNull
    private final Set<ExternalProjectsView.Listener> listeners;
    @Nullable
    private ExternalProjectsStructure myStructure;
    private SimpleTree myTree;
    @NotNull
    private final NotificationGroup myNotificationGroup;
    private final List<ExternalSystemViewContributor> myViewContributors;
    private ExternalProjectsViewState myState;

    public ExternalProjectsViewImpl(@NotNull Project project, @NotNull ToolWindowEx toolWindow, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(1);
        }
        if (externalSystemId == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(2);
        }
        super(true, true);
        this.listeners = ContainerUtil.newHashSet();
        this.myState = new ExternalProjectsViewState();
        this.myProject = project;
        this.myToolWindow = toolWindow;
        this.myExternalSystemId = externalSystemId;
        this.myUiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
        this.myProjectsManager = ExternalProjectsManagerImpl.getInstance(this.myProject);
        String toolWindowId = toolWindow instanceof ToolWindowImpl ? ((ToolWindowImpl)toolWindow).getId() : this.myExternalSystemId.getReadableName();
        String notificationId = "notification.group.id." + externalSystemId.getId().toLowerCase(Locale.ENGLISH);
        NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)notificationId);
        this.myNotificationGroup = registeredGroup != null ? registeredGroup : NotificationGroup.toolWindowGroup((String)notificationId, (String)toolWindowId);
        this.myViewContributors = Arrays.stream(ExternalSystemViewContributor.EP_NAME.getExtensions()).filter(c -> ProjectSystemId.IDE.equals((Object)c.getSystemId()) || this.myExternalSystemId.equals((Object)c.getSystemId())).collect(Collectors.toList());
        this.setName(this.myExternalSystemId.getReadableName() + " tool window");
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(3);
        }
        if (ExternalSystemDataKeys.VIEW.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.toolwindows.gradle";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.extractVirtualFile();
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.extractVirtualFiles();
        }
        if (Location.DATA_KEY.is(dataId)) {
            return this.extractLocation();
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractNavigatables();
        }
        if (ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.is(dataId)) {
            return this.myExternalSystemId;
        }
        if (ExternalSystemDataKeys.UI_AWARE.is(dataId)) {
            return this.myUiAware;
        }
        if (ExternalSystemDataKeys.SELECTED_PROJECT_NODE.is(dataId)) {
            return this.getSelectedProjectNode();
        }
        if (ExternalSystemDataKeys.SELECTED_NODES.is(dataId)) {
            return this.getSelectedNodes(ExternalSystemNode.class);
        }
        if (ExternalSystemDataKeys.PROJECTS_TREE.is(dataId)) {
            return this.myTree;
        }
        if (ExternalSystemDataKeys.NOTIFICATION_GROUP.is(dataId)) {
            return this.myNotificationGroup;
        }
        if (TouchbarDataKeys.ACTIONS_KEY.is(dataId)) {
            return new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("ExternalSystem.RefreshAllProjects")});
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    @NotNull
    public ExternalSystemUiAware getUiAware() {
        ExternalSystemUiAware externalSystemUiAware = this.myUiAware;
        if (externalSystemUiAware == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(5);
        }
        return externalSystemUiAware;
    }

    @Override
    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myProjectsManager.getShortcutsManager();
    }

    @Override
    public ExternalSystemTaskActivator getTaskActivator() {
        return this.myProjectsManager.getTaskActivator();
    }

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(6);
        }
        return projectSystemId;
    }

    @NotNull
    public NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = this.myNotificationGroup;
        if (notificationGroup == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(7);
        }
        return notificationGroup;
    }

    public void init() {
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.initTree();
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){
            boolean wasVisible = false;

            public void stateChanged() {
                if (ExternalProjectsViewImpl.this.myToolWindow.isDisposed()) {
                    return;
                }
                boolean visible = ExternalProjectsViewImpl.this.myToolWindow.isVisible();
                if (!visible || this.wasVisible) {
                    this.wasVisible = visible;
                    return;
                }
                ExternalProjectsViewImpl.this.scheduleStructureUpdate();
                this.wasVisible = true;
            }
        });
        this.getShortcutsManager().addListener(new ExternalSystemShortcutsManager.Listener(){

            @Override
            public void shortcutsUpdated() {
                ExternalProjectsViewImpl.this.scheduleTasksUpdate();
                ExternalProjectsViewImpl.this.scheduleStructureRequest(() -> {
                    assert (ExternalProjectsViewImpl.this.myStructure != null);
                    ExternalProjectsViewImpl.this.myStructure.updateNodes(RunConfigurationNode.class);
                });
            }
        });
        this.getTaskActivator().addListener(new ExternalSystemTaskActivator.Listener(){

            @Override
            public void tasksActivationChanged() {
                ExternalProjectsViewImpl.this.scheduleTasksUpdate();
                ExternalProjectsViewImpl.this.scheduleStructureRequest(() -> {
                    assert (ExternalProjectsViewImpl.this.myStructure != null);
                    ExternalProjectsViewImpl.this.myStructure.updateNodes(RunConfigurationNode.class);
                });
            }
        });
        busConnection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            private void changed() {
                ExternalProjectsViewImpl.this.scheduleStructureRequest(() -> {
                    assert (ExternalProjectsViewImpl.this.myStructure != null);
                    ExternalProjectsViewImpl.this.myStructure.visitNodes(ModuleNode.class, node -> node.updateRunConfigurations());
                });
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.changed();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.changed();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(2);
                }
                this.changed();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ExternalSystemApiUtil.subscribe((Project)this.myProject, (ProjectSystemId)this.myExternalSystemId, (ExternalSystemSettingsListener)new ExternalSystemSettingsListenerAdapter(){

            public void onUseAutoImportChange(boolean currentValue, @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    5.$$$reportNull$$$0(0);
                }
                ExternalProjectsViewImpl.this.scheduleStructureRequest(() -> {
                    if (linkedProjectPath == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    assert (ExternalProjectsViewImpl.this.myStructure != null);
                    List<ProjectNode> projectNodes = ExternalProjectsViewImpl.this.myStructure.getNodes(ProjectNode.class);
                    for (ProjectNode projectNode : projectNodes) {
                        ProjectData projectData = (ProjectData)projectNode.getData();
                        if (projectData == null || !projectData.getLinkedExternalProjectPath().equals(linkedProjectPath)) continue;
                        projectNode.updateProject();
                        break;
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "linkedProjectPath";
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onUseAutoImportChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onUseAutoImportChange$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myToolWindow.setAdditionalGearActions(this.createAdditionalGearActionsGroup());
        this.scheduleStructureUpdate();
    }

    @Override
    public void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
        if (node == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(8);
        }
        if (actionId != null) {
            ExternalSystemActionUtil.executeAction(actionId, this.getName(), inputEvent);
        }
        for (ExternalProjectsView.Listener listener : this.listeners) {
            listener.onDoubleClickOrEnter(node, inputEvent);
        }
    }

    @Override
    public void addListener(@NotNull ExternalProjectsView.Listener listener) {
        if (listener == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(9);
        }
        this.listeners.add(listener);
    }

    private ActionGroup createAdditionalGearActionsGroup() {
        String[] ids;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        for (String id : ids = new String[]{"ExternalSystem.GroupTasks", "ExternalSystem.ShowInheritedTasks", "ExternalSystem.ShowIgnored"}) {
            final AnAction gearAction = actionManager.getAction(id);
            if (!(gearAction instanceof ExternalSystemViewGearAction)) continue;
            ((ExternalSystemViewGearAction)gearAction).setView(this);
            group.add(gearAction);
            Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

                public void dispose() {
                    ((ExternalSystemViewGearAction)gearAction).setView(null);
                }
            });
        }
        return group;
    }

    private void initStructure() {
        this.myStructure = new ExternalProjectsStructure(this.myProject, this.myTree);
        Disposer.register((Disposable)this, (Disposable)this.myStructure);
        this.myStructure.init(this);
    }

    private void initTree() {
        this.myTree = new SimpleTree();
        this.myTree.getSelectionModel().setSelectionMode(4);
        final ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar(this.myExternalSystemId.getReadableName() + " View Toolbar", (ActionGroup)((DefaultActionGroup)actionManager.getAction("ExternalSystemView.ActionsToolbar")), true);
        actionToolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(actionToolbar.getComponent());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup;
                String id = this.getMenuId(ExternalProjectsViewImpl.this.getSelectedNodes(ExternalSystemNode.class));
                if (id != null && (actionGroup = (ActionGroup)actionManager.getAction(id)) != null) {
                    actionManager.createActionPopupMenu(ExternalProjectsViewImpl.this.getName(), actionGroup).getComponent().show(comp, x, y);
                }
            }

            @Nullable
            private String getMenuId(Collection<? extends ExternalSystemNode> nodes) {
                String id = null;
                for (ExternalSystemNode externalSystemNode : nodes) {
                    String menuId = externalSystemNode.getMenuId();
                    if (menuId == null) {
                        return null;
                    }
                    if (id == null) {
                        id = menuId;
                        continue;
                    }
                    if (id.equals(menuId)) continue;
                    return null;
                }
                return id;
            }
        });
    }

    public void scheduleStructureUpdate() {
        this.scheduleStructureRequest(() -> {
            Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(this.myProject, this.myExternalSystemId);
            List toImport = ContainerUtil.mapNotNull((Collection)projectsData, info -> info.getExternalProjectStructure());
            assert (this.myStructure != null);
            this.myStructure.updateProjects(toImport);
        });
    }

    protected boolean isUnitTestMode() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    public static void invokeLater(Project p, Runnable r) {
        ExternalProjectsViewImpl.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(Project p, ModalityState state, Runnable r) {
        if (ExternalProjectsViewImpl.isNoBackgroundMode()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeLater(DisposeAwareRunnable.create((Runnable)r, (Project)p), state);
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @Override
    public void updateUpTo(ExternalSystemNode node) {
        ExternalProjectsStructure structure = this.getStructure();
        if (structure != null) {
            structure.updateUpTo(node);
        }
    }

    @Override
    @Nullable
    public ExternalProjectsStructure getStructure() {
        return this.myStructure;
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode<?> parent, @NotNull DataNode<?> dataNode) {
        if (externalProjectsView == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(10);
        }
        if (dataNode == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(11);
        }
        SmartList result = new SmartList();
        MultiMap groups = ExternalSystemApiUtil.group((Collection)dataNode.getChildren());
        for (ExternalSystemViewContributor contributor : this.myViewContributors) {
            ContainerUtil.KeyOrderedMultiMap dataNodes = new ContainerUtil.KeyOrderedMultiMap();
            for (Key<?> key : contributor.getKeys()) {
                ContainerUtil.putIfNotNull(key, (Collection)groups.get(key), (MultiMap)dataNodes);
            }
            if (dataNodes.isEmpty()) continue;
            List<ExternalSystemNode<?>> childNodes = contributor.createNodes(externalProjectsView, (MultiMap<Key<?>, DataNode<?>>)dataNodes);
            result.addAll(childNodes);
            if (parent == null) continue;
            for (ExternalSystemNode<?> childNode : childNodes) {
                childNode.setParent(parent);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            ExternalProjectsViewImpl.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    @Nullable
    public ExternalProjectsViewState getState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myStructure != null) {
            try {
                this.myState.treeState = new Element("root");
                TreeState.createOn((JTree)this.myTree).writeExternal(this.myState.treeState);
            }
            catch (WriteExternalException e) {
                LOG.warn((Throwable)e);
            }
        }
        return this.myState;
    }

    public void loadState(ExternalProjectsViewState state) {
        this.myState = state;
    }

    @Override
    public boolean getShowIgnored() {
        return this.myState.showIgnored;
    }

    public void setShowIgnored(boolean value) {
        if (this.myState.showIgnored != value) {
            this.myState.showIgnored = value;
            this.scheduleStructureUpdate();
        }
    }

    @Override
    public boolean getGroupTasks() {
        return this.myState.groupTasks;
    }

    @Override
    public boolean useTasksNode() {
        return true;
    }

    public void setGroupTasks(boolean value) {
        if (this.myState.groupTasks != value) {
            this.myState.groupTasks = value;
            this.scheduleTasksRebuild();
        }
    }

    @Override
    public boolean showInheritedTasks() {
        return this.myState.showInheritedTasks;
    }

    public void setShowInheritedTasks(boolean value) {
        if (this.myState.showInheritedTasks != value) {
            this.myState.showInheritedTasks = value;
            this.scheduleStructureUpdate();
        }
    }

    @Override
    @Nullable
    public String getDisplayName(@Nullable DataNode node) {
        if (node == null) {
            return null;
        }
        return this.myViewContributors.stream().map(contributor -> contributor.getDisplayName(node)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void scheduleTasksRebuild() {
        this.scheduleStructureRequest(() -> {
            assert (this.myStructure != null);
            List<TasksNode> tasksNodes = this.myStructure.getNodes(TasksNode.class);
            for (TasksNode tasksNode : tasksNodes) {
                tasksNode.cleanUpCache();
                this.updateUpTo(tasksNode);
            }
        });
    }

    private void scheduleTasksUpdate() {
        this.scheduleStructureRequest(() -> {
            assert (this.myStructure != null);
            this.myStructure.updateNodes(TaskNode.class);
        });
    }

    private void scheduleStructureRequest(Runnable r) {
        if (this.isUnitTestMode()) {
            r.run();
            return;
        }
        ExternalProjectsViewImpl.invokeLater(this.myProject, () -> {
            boolean shouldCreate;
            if (!this.myToolWindow.isVisible()) {
                return;
            }
            boolean bl = shouldCreate = this.myStructure == null;
            if (shouldCreate) {
                this.initStructure();
            }
            this.myTree.setPaintBusy(true);
            try {
                r.run();
                if (shouldCreate) {
                    this.restoreTreeState();
                }
            }
            finally {
                this.myTree.setPaintBusy(false);
            }
        });
    }

    private void restoreTreeState() {
        TreeState.createFrom((Element)this.myState.treeState).applyTo((JTree)this.myTree);
    }

    private <T extends ExternalSystemNode> List<T> getSelectedNodes(Class<T> aClass) {
        return this.myStructure != null ? this.myStructure.getSelectedNodes(this.myTree, aClass) : ContainerUtil.emptyList();
    }

    private List<ProjectNode> getSelectedProjectNodes() {
        return this.getSelectedNodes(ProjectNode.class);
    }

    @Nullable
    private ProjectNode getSelectedProjectNode() {
        List<ProjectNode> projectNodes = this.getSelectedProjectNodes();
        return projectNodes.size() == 1 ? projectNodes.get(0) : null;
    }

    @Nullable
    private ExternalSystemTaskLocation extractLocation() {
        List<ExternalSystemNode> selectedNodes = this.getSelectedNodes(ExternalSystemNode.class);
        if (selectedNodes.isEmpty()) {
            return null;
        }
        List tasks = ContainerUtil.newSmartList();
        ExternalTaskExecutionInfo taskExecutionInfo = new ExternalTaskExecutionInfo();
        String projectPath = null;
        for (ExternalSystemNode node : selectedNodes) {
            Object data = node.getData();
            if (!(data instanceof TaskData)) continue;
            TaskData taskData = (TaskData)data;
            if (projectPath == null) {
                projectPath = taskData.getLinkedExternalProjectPath();
            } else if (!taskData.getLinkedExternalProjectPath().equals(projectPath)) {
                return null;
            }
            taskExecutionInfo.getSettings().getTaskNames().add(taskData.getName());
            taskExecutionInfo.getSettings().getTaskDescriptions().add(taskData.getDescription());
            tasks.add(taskData);
        }
        if (tasks.isEmpty()) {
            return null;
        }
        taskExecutionInfo.getSettings().setExternalSystemIdString(this.myExternalSystemId.toString());
        taskExecutionInfo.getSettings().setExternalProjectPath(projectPath);
        return ExternalSystemTaskLocation.create(this.myProject, this.myExternalSystemId, projectPath, taskExecutionInfo);
    }

    private VirtualFile extractVirtualFile() {
        for (ExternalSystemNode each : this.getSelectedNodes(ExternalSystemNode.class)) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            return file;
        }
        ProjectNode projectNode = this.getSelectedProjectNode();
        if (projectNode == null) {
            return null;
        }
        VirtualFile file = projectNode.getVirtualFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return file;
    }

    private Object extractVirtualFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (ExternalSystemNode each : this.getSelectedNodes(ExternalSystemNode.class)) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            files.add(file);
        }
        return files.isEmpty() ? null : VfsUtilCore.toVirtualFileArray(files);
    }

    private Object extractNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (ExternalSystemNode each : this.getSelectedNodes(ExternalSystemNode.class)) {
            Navigatable navigatable = each.getNavigatable();
            if (navigatable == null) continue;
            navigatables.add(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[0]);
    }

    public void dispose() {
        this.listeners.clear();
        this.myStructure = null;
        this.myTree = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiAware";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleDoubleClickOrEnter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

