/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\f2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u0012H\u0014J\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0010\u001a\u00060\u0011R\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0003H\u0014J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u000e2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u0012H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/CodeFenceMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "fenceStart", "", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Ljava/lang/String;)V", "endLineRegex", "Lkotlin/text/Regex;", "realInterestingOffset", "", "allowsSubBlocks", "", "calcNextInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "endsThisFence", "line", "", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "52a7eb3df0584991-compileKotlin"})
public final class CodeFenceMarkerBlock
extends MarkerBlockImpl {
    private final Regex endLineRegex;
    private int realInterestingOffset;
    private final ProductionHolder productionHolder;
    private final String fenceStart;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        int nextLineOffset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffset() < this.realInterestingOffset) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        boolean bl = pos.getOffsetInCurrentLine() == -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(pos, this.getConstraints());
        if (!nextLineConstraints.extendsPrev(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        this.realInterestingOffset = nextLineOffset = pos.getNextLineOrEofOffset();
        CharSequence currentLine = nextLineConstraints.eatItselfFromString(pos.getCurrentLine());
        if (this.endsThisFence(currentLine)) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset()), MarkdownTokenTypes.CODE_FENCE_END)));
            this.scheduleProcessingResult(nextLineOffset, MarkerBlock.ProcessingResult.Companion.getDEFAULT());
        } else {
            IntRange contentRange = new IntRange(Math.min(pos.getOffset() + 1 + this.getConstraints().getCharsEaten(pos.getCurrentLine()), nextLineOffset), nextLineOffset);
            if (contentRange.getStart() < contentRange.getEndInclusive()) {
                this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(contentRange, MarkdownTokenTypes.CODE_FENCE_CONTENT)));
            }
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    private final boolean endsThisFence(CharSequence line) {
        return this.endLineRegex.matches(line);
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.CODE_FENCE;
    }

    public CodeFenceMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull String fenceStart) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)fenceStart, (String)"fenceStart");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.fenceStart = fenceStart;
        this.endLineRegex = new Regex("^ {0,3}" + this.fenceStart + "+ *" + "$");
        this.realInterestingOffset = -1;
    }
}

