/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class ShowPropertiesDiffAction
extends AnAction
implements DumbAware {
    private static final String ourPropertiesDelimiter = "\n";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(0);
        }
        boolean isVisible = ShowPropertiesDiffAction.checkThatChangesAreUnderSvn((Change[])e.getData(VcsDataKeys.CHANGES));
        e.getPresentation().setVisible(isVisible);
        e.getPresentation().setEnabled(isVisible && e.getProject() != null);
    }

    private static boolean checkThatChangesAreUnderSvn(@Nullable Change[] changes) {
        return changes != null && ContainerUtil.exists((Object[])changes, change -> ShowPropertiesDiffAction.isUnderSvn(change.getBeforeRevision()) || ShowPropertiesDiffAction.isUnderSvn(change.getAfterRevision()));
    }

    private static boolean isUnderSvn(@Nullable ContentRevision revision) {
        return revision instanceof SvnBaseContentRevision;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Change[] changes;
        if (e == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(1);
        }
        if (ShowPropertiesDiffAction.checkThatChangesAreUnderSvn(changes = (Change[])e.getData(VcsDataKeys.CHANGE_LEAD_SELECTION))) {
            new CalculateAndShow((Project)e.getRequiredData(CommonDataKeys.PROJECT), changes[0], e.getPresentation().getText()).queue();
        }
    }

    @NotNull
    private static Revision getBeforeRevisionValue(@NotNull Change change) {
        ContentRevision beforeRevision;
        if (change == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(2);
        }
        if ((beforeRevision = change.getBeforeRevision()) != null) {
            Revision revision = ((SvnRevisionNumber)beforeRevision.getRevisionNumber()).getRevision();
            if (revision == null) {
                ShowPropertiesDiffAction.$$$reportNull$$$0(3);
            }
            return revision;
        }
        Revision revision = Revision.of(((SvnRevisionNumber)((ContentRevision)ObjectUtils.notNull((Object)change.getAfterRevision())).getRevisionNumber()).getRevision().getNumber() - 1L);
        if (revision == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(4);
        }
        return revision;
    }

    @NotNull
    private static Revision getAfterRevisionValue(@NotNull Change change) {
        ContentRevision afterRevision;
        if (change == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(5);
        }
        if ((afterRevision = change.getAfterRevision()) != null) {
            Revision revision = afterRevision instanceof CurrentContentRevision ? Revision.WORKING : ((SvnRevisionNumber)afterRevision.getRevisionNumber()).getRevision();
            if (revision == null) {
                ShowPropertiesDiffAction.$$$reportNull$$$0(6);
            }
            return revision;
        }
        Revision revision = Revision.of(((SvnRevisionNumber)((ContentRevision)ObjectUtils.notNull((Object)change.getBeforeRevision())).getRevisionNumber()).getRevision().getNumber() + 1L);
        if (revision == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(7);
        }
        return revision;
    }

    @NotNull
    private static String getDiffWindowTitle(@NotNull Change change) {
        if (change == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(8);
        }
        if (change.isMoved() || change.isRenamed()) {
            FilePath beforeFilePath = ChangesUtil.getBeforePath((Change)change);
            FilePath afterFilePath = ChangesUtil.getAfterPath((Change)change);
            String beforePath = beforeFilePath == null ? "" : beforeFilePath.getPath();
            String afterPath = afterFilePath == null ? "" : afterFilePath.getPath();
            String string = SvnBundle.message("action.Subversion.properties.difference.diff.for.move.title", beforePath, afterPath);
            if (string == null) {
                ShowPropertiesDiffAction.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = SvnBundle.message("action.Subversion.properties.difference.diff.title", ChangesUtil.getFilePath((Change)change).getPath());
        if (string == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static int compareRevisions(@NotNull Revision revision1, @NotNull Revision revision2) {
        if (revision1 == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(11);
        }
        if (revision2 == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(12);
        }
        if (revision1.equals(revision2)) {
            return 0;
        }
        if (Revision.WORKING.equals(revision1)) {
            return 1;
        }
        if (Revision.WORKING.equals(revision2)) {
            return -1;
        }
        if (Revision.HEAD.equals(revision1)) {
            return 1;
        }
        if (Revision.HEAD.equals(revision2)) {
            return -1;
        }
        return revision1.getNumber() > revision2.getNumber() ? 1 : -1;
    }

    @NotNull
    private static String revisionToString(@Nullable Revision revision) {
        String string = revision == null ? "not exists" : revision.toString();
        if (string == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @Nullable ContentRevision contentRevision, @Nullable Revision revision) throws SvnBindException {
        Target target;
        if (vcs == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(14);
        }
        if (contentRevision == null) {
            List<PropertyData> list = Collections.emptyList();
            if (list == null) {
                ShowPropertiesDiffAction.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (contentRevision instanceof SvnRepositoryContentRevision) {
            SvnRepositoryContentRevision svnRevision = (SvnRepositoryContentRevision)contentRevision;
            target = Target.on(svnRevision.getUrl(), revision);
        } else {
            File ioFile = contentRevision.getFile().getIOFile();
            target = Target.on(ioFile, revision);
        }
        List<PropertyData> list = ShowPropertiesDiffAction.getPropertyList(vcs, target, revision);
        if (list == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull Url url, @Nullable Revision revision) throws SvnBindException {
        if (vcs == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(17);
        }
        if (url == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(18);
        }
        List<PropertyData> list = ShowPropertiesDiffAction.getPropertyList(vcs, Target.on(url, revision), revision);
        if (list == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull File ioFile, @Nullable Revision revision) throws SvnBindException {
        if (vcs == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(20);
        }
        if (ioFile == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(21);
        }
        List<PropertyData> list = ShowPropertiesDiffAction.getPropertyList(vcs, Target.on(ioFile, revision), revision);
        if (list == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable Revision revision) throws SvnBindException {
        if (vcs == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(23);
        }
        if (target == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(24);
        }
        ArrayList<PropertyData> lines = new ArrayList<PropertyData>();
        PropertyConsumer propertyHandler = ShowPropertiesDiffAction.createHandler(revision, lines);
        vcs.getFactory(target).createPropertyClient().list(target, revision, Depth.EMPTY, propertyHandler);
        ArrayList<PropertyData> arrayList = lines;
        if (arrayList == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    private static PropertyConsumer createHandler(Revision revision, final @NotNull List<? super PropertyData> lines) {
        ProgressIndicator indicator;
        if (lines == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(26);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.checkCanceled();
            indicator.setText(SvnBundle.message("show.properties.diff.progress.text.revision.information", revision.toString()));
        }
        PropertyConsumer propertyConsumer = new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(Url url, PropertyData property) {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(long revision, PropertyData property) {
            }

            private void registerProperty(@NotNull PropertyData property) {
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(SvnBundle.message("show.properties.diff.progress.text2.property.information", property.getName()));
                }
                lines.add(property);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/actions/ShowPropertiesDiffAction$1", "registerProperty"));
            }
        };
        if (propertyConsumer == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(27);
        }
        return propertyConsumer;
    }

    @NotNull
    public static String toSortedStringPresentation(@NotNull List<? extends PropertyData> lines) {
        if (lines == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(28);
        }
        StringBuilder sb = new StringBuilder();
        Collections.sort(lines, Comparator.comparing(PropertyData::getName));
        for (PropertyData propertyData : lines) {
            ShowPropertiesDiffAction.addPropertyPresentation(propertyData, sb);
        }
        String string = sb.toString();
        if (string == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static void addPropertyPresentation(@NotNull PropertyData property, @NotNull StringBuilder sb) {
        if (property == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(30);
        }
        if (sb == null) {
            ShowPropertiesDiffAction.$$$reportNull$$$0(31);
        }
        if (sb.length() != 0) {
            sb.append(ourPropertiesDelimiter);
        }
        sb.append(property.getName()).append("=").append(StringUtil.notNullize((String)PropertyValue.toString(property.getValue())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/ShowPropertiesDiffAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision2";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/ShowPropertiesDiffAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRevisionValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterRevisionValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffWindowTitle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "revisionToString";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toSortedStringPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeRevisionValue";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 29: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAfterRevisionValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDiffWindowTitle";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareRevisions";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toSortedStringPresentation";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CalculateAndShow
    extends Task.Backgroundable {
        private final Change myChange;
        private List<PropertyData> myBeforeContent;
        private List<PropertyData> myAfterContent;
        private Revision myBeforeRevisionValue;
        private Revision myAfterRevision;
        private SvnBindException myException;
        private final String myErrorTitle;

        private CalculateAndShow(@NotNull Project project, Change change, String errorTitle) {
            if (project == null) {
                CalculateAndShow.$$$reportNull$$$0(0);
            }
            super(project, SvnBundle.message("fetching.properties.contents.progress.title", new Object[0]), true, PerformInBackgroundOption.DEAF);
            this.myChange = change;
            this.myErrorTitle = errorTitle;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CalculateAndShow.$$$reportNull$$$0(1);
            }
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            try {
                this.myBeforeRevisionValue = ShowPropertiesDiffAction.getBeforeRevisionValue(this.myChange);
                this.myAfterRevision = ShowPropertiesDiffAction.getAfterRevisionValue(this.myChange);
                this.myBeforeContent = ShowPropertiesDiffAction.getPropertyList(vcs, this.myChange.getBeforeRevision(), this.myBeforeRevisionValue);
                indicator.checkCanceled();
                this.myAfterContent = ShowPropertiesDiffAction.getPropertyList(vcs, this.myChange.getAfterRevision(), this.myAfterRevision);
            }
            catch (SvnBindException exc) {
                this.myException = exc;
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                Messages.showErrorDialog((String)this.myException.getMessage(), (String)this.myErrorTitle);
                return;
            }
            if (this.myBeforeContent != null && this.myAfterContent != null && this.myBeforeRevisionValue != null && this.myAfterRevision != null) {
                SvnPropertiesDiffRequest diffRequest = ShowPropertiesDiffAction.compareRevisions(this.myBeforeRevisionValue, this.myAfterRevision) > 0 ? new SvnPropertiesDiffRequest(ShowPropertiesDiffAction.getDiffWindowTitle(this.myChange), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myAfterContent), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myBeforeContent), ShowPropertiesDiffAction.revisionToString(this.myAfterRevision), ShowPropertiesDiffAction.revisionToString(this.myBeforeRevisionValue)) : new SvnPropertiesDiffRequest(ShowPropertiesDiffAction.getDiffWindowTitle(this.myChange), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myBeforeContent), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myAfterContent), ShowPropertiesDiffAction.revisionToString(this.myBeforeRevisionValue), ShowPropertiesDiffAction.revisionToString(this.myAfterRevision));
                DiffManager.getInstance().showDiff(this.myProject, (DiffRequest)diffRequest);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/actions/ShowPropertiesDiffAction$CalculateAndShow";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

