/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.rollback.ChangesAfterPathComparator;
import org.jetbrains.idea.svn.rollback.ChangesChecker;
import org.jetbrains.idea.svn.rollback.Reverter;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;

public class SvnRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final SvnVcs mySvnVcs;

    public SvnRollbackEnvironment(SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    public String getRollbackOperationName() {
        return SvnBundle.message("action.name.revert", new Object[0]);
    }

    public void rollbackChanges(@NotNull List<Change> changes, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (changes == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(0);
        }
        if (exceptions == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(1);
        }
        if (listener == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(2);
        }
        listener.indeterminate();
        for (Map.Entry entry : SvnUtil.splitChangesIntoWc(this.mySvnVcs, changes).entrySet()) {
            List sortedChanges = ContainerUtil.sorted((Collection)((Collection)entry.getValue()), (Comparator)ChangesAfterPathComparator.getInstance());
            this.rollbackGroupForWc(sortedChanges, exceptions, listener);
        }
    }

    private void rollbackGroupForWc(@NotNull List<Change> changes, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (changes == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(3);
        }
        if (exceptions == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(5);
        }
        UnversionedAndNotTouchedFilesGroupCollector collector = new UnversionedAndNotTouchedFilesGroupCollector();
        ChangesChecker checker = new ChangesChecker(this.mySvnVcs, collector);
        checker.gather(changes);
        exceptions.addAll(checker.getExceptions());
        Reverter reverter = new Reverter(this.mySvnVcs, listener, exceptions);
        reverter.moveRenamesToTmp(collector);
        reverter.revert(checker.getForAdds(), true);
        reverter.revert(checker.getForDeletes(), true);
        reverter.revert(checker.getForEdits(), false);
        reverter.moveGroup();
        for (Couple<File> pair : collector.getToBeDeleted()) {
            if (!((File)pair.getFirst()).exists()) continue;
            FileUtil.delete((File)((File)pair.getSecond()));
        }
    }

    public void rollbackMissingFileDeletion(@NotNull List<FilePath> filePaths, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (filePaths == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(6);
        }
        if (exceptions == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(7);
        }
        if (listener == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(8);
        }
        for (FilePath filePath : filePaths) {
            listener.accept(filePath);
            try {
                this.revertFileOrDir(filePath);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
    }

    private void revertFileOrDir(@NotNull FilePath filePath) throws VcsException {
        File file;
        Info info;
        if (filePath == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(9);
        }
        if ((info = this.mySvnVcs.getInfo(file = filePath.getIOFile())) != null) {
            if (info.isFile()) {
                this.doRevert(file, false);
            } else if ("add".equals(info.getSchedule()) || this.mySvnVcs.getWorkingCopyFormat(file).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
                this.doRevert(file, true);
            } else {
                this.mySvnVcs.getFactory(file).createUpdateClient().doUpdate(file, Revision.HEAD, Depth.INFINITY, false, false);
            }
        } else {
            throw new VcsException("Can not get 'svn info' for " + file.getPath());
        }
    }

    private void doRevert(@NotNull File path, boolean recursive) throws VcsException {
        if (path == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(10);
        }
        this.mySvnVcs.getFactory(path).createRevertClient().revert(Collections.singletonList(path), Depth.allOrFiles(recursive), null);
    }

    public static boolean isMoveRenameReplace(@NotNull Change c) {
        if (c == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(11);
        }
        if (c.getAfterRevision() == null || c.getBeforeRevision() == null) {
            return false;
        }
        return c.isIsReplaced() || c.isMoved() || c.isRenamed() || !Comparing.equal((Object)c.getBeforeRevision().getFile(), (Object)c.getAfterRevision().getFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "rollbackChanges";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rollbackGroupForWc";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "rollbackMissingFileDeletion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "revertFileOrDir";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doRevert";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isMoveRenameReplace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

