/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQImportCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQImportCommand(@NotNull HgRepository repository) {
        if (repository == null) {
            HgQImportCommand.$$$reportNull$$$0(0);
        }
        this.myRepository = repository;
    }

    public void execute(@NotNull String startRevisionNumber) {
        if (startRevisionNumber == null) {
            HgQImportCommand.$$$reportNull$$$0(1);
        }
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myRepository.getProject(), () -> {
            if (startRevisionNumber == null) {
                HgQImportCommand.$$$reportNull$$$0(3);
            }
            this.executeInCurrentThread(startRevisionNumber);
        });
    }

    public void executeInCurrentThread(@NotNull String startRevisionNumber) {
        if (startRevisionNumber == null) {
            HgQImportCommand.$$$reportNull$$$0(2);
        }
        Project project = this.myRepository.getProject();
        String lastRevisionName = this.myRepository.getMQAppliedPatches().isEmpty() ? "tip" : "qparent";
        ArrayList arguments = ContainerUtil.newArrayList((Object[])new String[]{"--rev", startRevisionNumber + ":" + lastRevisionName});
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(this.myRepository.getRoot(), "qimport", arguments);
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "Import failed", "Import revision from " + startRevisionNumber + " to qparent failed");
        }
        this.myRepository.update();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRevisionNumber";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/command/mq/HgQImportCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInCurrentThread";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

